# Configuration file for Consociata, to be modified before you start the application
# See documentation of Ruby/Sinatra for syntax of this file: http://sinatrarb.com/intro.html

configure do 
   # Name to be displayed in the template. You should indicate here whenever you use Elefas or Exilis, or you may use your own internal name
   set :app_name, 'Exilis Translation Memory Manager'
   
   # Text which will appear in the main window, used to make announements
   set :announce, 'This is a <b>sample</b> config file, don\'t forget to adapt it to your needs'
   
   # List of supported formats for input files
   # Should be taken from Spongiae, this will be changed later
   set :input_formats, [ 'HTML','Java properties','Docbook','Microsoft Open XML','LibreOffice Open Document' ]
   
   # Path to either Exilis or Elefas. Points to top directory, not to bin
   set :exe_dir, '../Exilis'
   
   # Whenever we are using Elefas or Exilis. actually not possible to use both in same web interface.
   set :app_type, 'Exilis'
   
   # Database. In Exilis, this is a directory
   set :database, './test'
   # Also supported: multi-hosts
   # set :database, '/path/to/databases/$HOST[1]'
   
   # Since statistics may be slow, do not display them on first screen
   set :always_recalc_stats, false
      
   # Allow individual searches. For Exlilis no special reason to disable.
   set :allow_small_search, true 
   
   # Up to 20K, upload synchronously. Else, reply immediately and load in background
   set :limit_sync_upload => 20_000
   
   # Allow search from file to file
   set :dest_dir => '/tmp'
end 
