#! /usr/bin/ruby

require 'sinatra'
require './config'	# loads config.rb

if defined? settings.auth then
    require './auth'
else
    # Emulate the function used in routes
    def protected!()
        return 'admin', 'admin'
    end
end    

def cur_database(request,short=false)
    res = settings.database.dup
    if res =~ /\$HOST/ then
        host = request.env['SERVER_NAME'].split(/\./)  # header
        res.gsub!(/\$HOST\[(\d+)\]/) { num = $1.to_i; host[num - 1] }
    end
    if short then   # for display, only name
       res = $1 if res =~ /^([\w\-]+):/     # Elefas short format
       res = $1 if res =~ /\/([\w\-]+)\??/     # URL or directory
       res = $2 if res =~ /(db|catalog)=([\w\-]+)/       # parameters
    end
    res
end

if defined? settings.deamon then
    if settings.deamon[:must_start] then
        exe_name = "#{settings.exe_dir}/bin/ef-deamon.rb #{settings.database}"
        exe_name = exe_name + ' ' + settings.deamon[:import_dir] 
        exe_name = exe_name + ' ' + settings.deamon[:search_input] 
        exe_name = exe_name + ' ' + settings.deamon[:search_result] 
        puts "Running #{exe_name}"
        fork { exec exe_name }
    end
    require 'fileutils'
end

def stats(request)
  if settings.app_type =~ /f/ then 
  	exe_name = "#{settings.exe_dir}/bin/ef-stats.rb #{cur_database(request)} 2>&1"
  elsif settings.app_type =~ /x/ then
  	exe_name = "#{settings.exe_dir}/bin/ex-stats.rb #{cur_database(request)} 2>&1"
  else
  	halt 'Must configure Elefas or Exilis (parameter "app_type")'
  end
  result = IO.popen(exe_name, 'r') { |io| io.read }
  result.gsub! /Collection.*\d+/, '' if defined? settings.collections
  result = $1 if result =~ /(FATAL.+)\n/
  return result
end

current_stats = {}
$cs_proc_ids = Hash.new  if defined? settings.proc_logs

get '/' do
    current_user_rights = protected! 
  locals = { :rights => current_user_rights[0], :msg_status => 'INFO', :umail => current_user_rights[2] }
  if defined? settings.announce then
      locals[:command_res] = settings.announce 
      if settings.announce.is_a? Hash then
          choice = settings.announce[:choice]
          if choice =~ /\$HOST/ then
              host = request.env['SERVER_NAME'].split(/\./)  # header
              choice = choice.gsub(/\$HOST\[(\d+)\]/) { num = $1.to_i; host[num - 1] }
          end      
          locals[:command_res] = locals[:command_res][choice]
      end
      locals[:command_res] = File.read($1) if locals[:command_res] =~ /^file:(.+\..+)$/
  end
  if settings.always_recalc_stats
      locals[:stats] = stats(request) 
  else  # to save time, do not recalculate them
      current_stats[request.env['SERVER_NAME']] = stats(request) if current_stats[request.env['SERVER_NAME']] == nil
      locals[:stats] = current_stats[request.env['SERVER_NAME']]
  end
  if locals[:stats] =~ /(FATAL|ERROR):?\s+(.+)/ then
      locals[:command_res] = $2; locals[:stats] = ''; 
      locals[:msg_status] = $1
  end
  locals[:db] = cur_database(request,true) if settings.database =~ /\$/
  erb :home, :locals =>  locals
end

get '/help' do
    help_file = settings.help
    if help_file.is_a? Hash then
        choice = help_file[:choice].dup
        if choice =~ /\$HOST/ then
            host = request.env['SERVER_NAME'].split(/\./)  # header
            choice.gsub!(/\$HOST\[(\d+)\]/) { num = $1.to_i; host[num - 1] }
        end      
        if help_file.key?(choice) then help_file = help_file[choice] else help_file = help_file['default'] end
    end
    send_file help_file
end

# -------------- Usage routes ------------------

require './routes/simple-search' if settings.allow_small_search
require './routes/file-search' if defined? settings.dest_dir 

def is_async_mode?(file)
    return false unless defined? settings.limit_sync_upload
    return File.size(file) > settings.limit_sync_upload
end

def import(tmpfile,name,collection)  
  if settings.app_type =~ /f/ then 
      exe_name = "#{settings.exe_dir}/bin/ef-import.rb"
  elsif settings.app_type =~ /x/ then
      exe_name = "#{settings.exe_dir}/bin/ex-load.rb"
  else
      halt 'Must configure Elefas or Exilis (parameter "app_type")'
  end
  cmd = "#{exe_name} '#{cur_database(request)}' '#{tmpfile.path}'"
  if settings.app_type =~ /f/ then 
      collection = '' unless defined? collection
      cmd = cmd + " '#{collection}:#{name}'"
  elsif settings.app_type =~ /x/ then
      cmd.sub! /\.rb /, ".rb '.p.Document Name=#{name}' "  
  end
  
  if is_async_mode?(tmpfile.path) then
    if defined? settings.deamon then
        if defined? collection then
            FileUtils.cp(tmpfile.path, "#{settings.deamon[:import_dir]}/coll-#{collection}/#{name}")            
        else
            FileUtils.cp(tmpfile.path, "#{settings.deamon[:import_dir]}/#{name}")
        end
    else
        # Launch a process per upload.
        # Note: limiting access to the database is responsability of the started processes
        cmd = cmd + " >> '#{settings.proc_logs[:location]}/#{name}.log' 2>&1" if defined? settings.proc_logs
        pid = fork { exec cmd }
        $cs_proc_ids[pid] = [ 'Import', name, Time.now, request.env['REMOTE_USER'], cur_database(request,true) ] if defined? settings.proc_logs
    end
    return "Upload of #{name} started"
  else
    start = Time.now
    result = IO.popen(cmd, 'r+') do |io|
        begin
            while blk = tmpfile.read(65536)
                io.write blk.inspect
            end 
        rescue
        
        end
        io.close_write
        io.read
    end
    return result + "\n<br>Duration: #{Time.now.to_i - start.to_i} seconds"
  end
end

# Version for HTML
post '/upload' do
    current_user_rights = protected! 
    halt 'You are not authorized to import files' if defined? current_user_rights[0] and current_user_rights[0] !~ /admin|upload/
  unless params[:file] && (tmpfile = params[:file][:tempfile]) && (name = params[:file][:filename])
      halt "No file selected"
  end
  start = Time.now
  result = import(tmpfile,name,params[:collection])
  result = result + "\n<br>Duration: #{Time.now.to_i - start.to_i} seconds" unless is_async_mode?(tmpfile.path) 
  locals = { :command_res => result, :stats => stats(request), :msg_status => 'OK', :umail => current_user_rights[2] }  
  locals[:db] = cur_database(request) if settings.database =~ /\$/
  erb :home, :locals => locals
end

# Version for REST
get '/api/upload' do
    current_user_rights = protected! ; current_user_rights = current_user_rights[0]
    halt 'You are not authorized to import files' if defined? current_user_rights and current_user_rights !~ /admin|upload/
  start = Time.now
  name = params[:file]; name = $1 if name =~ /\/(.+)$/
  mode = 'sync'; mode = 'async' if is_async_mode?(params[:file])
  result = ''
  File.open(params[:file]) { |io| result = import(io,nameparams[:collection]) }  
  return <<EOF
{ "result": "#{result}", "mode": "#{mode}", "duration": #{Time.now.to_i - start.to_i} }
EOF
end

require 'tempfile'

post '/api/upload' do
    current_user_rights = protected! ; current_user_rights = current_user_rights[0]
    halt 'You are not authorized to import files' if defined? current_user_rights and current_user_rights !~ /admin|upload/
  start = Time.now
  tmpFile = Tempfile.new(['upload','.tmx'])
  tmpFile.write request.body.read
  mode = 'sync'; mode = 'async' if is_async_mode?(tmpFile)
  result = import(tmpFile,'upload.tmx')
  return <<EOF
{ "result": "#{result}", "mode": "#{mode}", "duration": #{Time.now.to_i - start.to_i} }
EOF
end

# -------------- Administration routes ------------------

get '/running' do
    erb :procs, :locals =>  { :db => cur_database(request,true) }
end

helpers do
    def main_admin_page(command_res = '', status = 'INFO')
        if defined? settings.segmentation then
            if settings.segmentation.is_a? Hash then
                segfile = settings.segmentation[db]
            else
                segfile = settings.segmentation.dup
                segfile.gsub!(/\$HOST\[(\d+)\]/) { host = request.env['SERVER_NAME'].split(/\./) ; num = $1.to_i; host[num - 1] }
            end
        else
            segfile = nil
        end    
        ucount = users_count if defined? settings.auth
        erb :admin, :locals => { :command_res => command_res, :msg_status => status, 
                                 :segfile => segfile, :users_count => ucount }        
    end
end


get '/admin' do
    current_user_rights = protected! 
    halt 'You are not authorized to access this part' if defined? current_user_rights[0] and current_user_rights[0] !~ /admin/
    main_admin_page()
end

post '/admin/seg-rules/upload' do
    current_user_rights = protected! 
    halt 'You are not authorized to import files' if defined? current_user_rights[0] and current_user_rights[0] !~ /admin/
  unless params[:file] && (tmpfile = params[:file][:tempfile]) && (name = params[:file][:filename])
      halt "No file selected"
  end
  start = Time.now;  command_res = ''
    if settings.segmentation.is_a? Hash then
        segfile = settings.segmentation[db]
    else
        segfile = settings.segmentation.dup
        segfile.gsub!(/\$HOST\[(\d+)\]/) { num = $1.to_i; host = request.env['SERVER_NAME'].split(/\./) ; host[num - 1] }
    end
  result = ''
  File.delete segfile if File.exists? segfile
   FileUtils.cp(tmpfile.path, segfile)
  result = result + "\n<br>Duration: #{Time.now.to_i - start.to_i} seconds" 
  
  erb :admin, :locals => { :command_res => result + command_res, :segfile => segfile,:msg_status => 'OK' }    
end
