
# Search for one phrase. Put in separate file because it may not be loaded at all if option is unactivated

post '/simple-search' do
    protected!
    start = Time.now
    
    res = []; err = nil
    lang = params['src']
    lang = lang + ':' + params['tra'] unless params['tra'] == nil or params['tra'].length < 2
    db = settings.database.gsub(/\$HOST\[(\d+)\]/) { num = $1.to_i; host = request.env['SERVER_NAME'].split(/\./); host[num - 1] }
    
  if settings.app_type =~ /f/ then 
      collection = "--collection #{params[:collection]}" unless params[:collection] == nil or params[:collection] == ''
  	exe_name = "#{settings.exe_dir}/bin/ef-find.rb #{db} #{lang} #{collection} --query-string '#{params['phrase']}'"
  elsif settings.app_type =~ /x/ then
  	exe_name = "#{settings.exe_dir}/bin/ex-find.rb #{db} #{lang} -phrase '#{params['phrase']}'"
  else
  	halt 'Must configure Elefas or Exilis (parameter "app_type")'
  end
    
  puts "call #{exe_name}"
  IO.popen(exe_name, 'r') do |io| 
      if params['fmt'] == 'tmx' then
          headers 'Content-Type' => 'text/xml; charset=utf-8'
          return io.read
      end
      
      headers 'Content-Type' => 'text/html; charset=utf-8'
      idx = 0
      while line = io.gets('</tu>')
          next unless line =~ /<\/tu>/
          row = {}; res << row
          idx = idx + 1; row['id'] = idx
          row['id'] = $1 if line =~ /id\s*=\s*['"](.+?)['"]/
          row['doc'] = $3 if line =~ /<prop type\s*=\s*(['"])(file|Document name)\1>(.+?)<\/prop>/m
          row['tra'] = ''
          line.scan(/<tuv(.+?)>(.+?)<\/tuv>/m) do |tuv|
              attr = $1; seg = $2; 
              seg = $1 if seg =~ /<seg>(.+)<\/seg>/m; lang = $1 if attr =~ /\b(?:xml:)?lang\s*=\s*[\'\"]([a-zA-Z]{2})/m
              if lang.upcase == params['src'].upcase then
                 row['src'] = seg
              elsif params['tra'] == nil or params['tra'].length == 0 or params['tra'].upcase.include?($1.upcase) then
                 row['tra'] = row['tra'] + "<b>" + lang + "</b>:"
                 row['tra'] = row['tra'] + " (<font color=blue>#{$3}</font>)" if attr =~ /(creation|change)id\s*([\"\'])(.+?)\2/
                 row['tra'] = row['tra'] + seg if seg != nil and seg.length > 0
                 row['tra'] = row['tra'] + " <br>\n"
              end
          end
      end
  end
  
    
    erb :search_result, :locals =>  {
            :src_lang => params['src'], :search_time => (Time.now - start) , :error => err, :result => res, :count => res.count
        }
end
