/**************************************************************************
 Silvestris Cyclotis
 
 Copyright (C) 2014-2015 Silvestris project (http://www.silvestris-lab.org/)
 
 This file is part of Cyclotis plugin for OmegaT
 
 Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
 You may not use this work except in compliance with the Licence.
 You may obtain a copy of the Licence at: L<http://ec.europa.eu/idabc/eupl>

 Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the Licence for the specific language governing permissions and limitations under the Licence. 
 **************************************************************************/

package org.silvestrislab.cyclotis.omegat;

import org.omegat.util.Preferences;
import org.omegat.util.TMXProp;
import org.omegat.core.data.PrepareTMXEntry;

import org.silvestrislab.cyclotis.omegat.tm.PropertiesStore;

import java.util.Map;
import java.util.HashMap;
import java.util.Properties;

public abstract class HttpCyclotisTMX<T extends PrepareTMXEntry> extends HttpCyclotis<T>  {

	public static final int COL_AUTHOR = 2;
	public static final int COL_DATE = 3;
	public static final int COL_CHANGER = 4;
	public static final int COL_CHANGEDATE = 5;
	public static final int COL_PROPS = 6;
	public static final int COL_NOTE = 7;

	private String author;	
	public final PropertiesStore store;

	protected HttpCyclotisTMX (Properties propList) { 
		super(propList); 

		this.author = propList.getProperty ("author");
		if (this.author == null) this.author = Preferences.getPreferenceDefault(Preferences.TEAM_AUTHOR, System.getProperty("user.name"));
		this.store = new PropertiesStore(this, propList);
	}

	protected HttpCyclotisTMX (HttpCyclotisTMX ori) { 
		super(ori); this.author = ori.author; this.store = ori.store;
	}

	protected Map<String,String> encodeArgs (T entry)  {
		Map<String, String> args = new HashMap<String,String> ();
		args.put("src", reformatText(entry.source, false));
		args.put("tra", reformatText(entry.translation,false));
		args.put("author", this.author);
		if (entry.note != null) args.put ("note", entry.note);	
		if (entry.otherProperties != null)
			for (TMXProp prop: entry.otherProperties)
				args.put("props." + prop.getType(), prop.getValue());
		return args;
	}	
	
	/* ------------  Logging -------------- */
	
	public StringBuffer entryToLogString (T entry, boolean detailed, boolean digest) {
		StringBuffer buf;
		if (detailed)
			buf = new StringBuffer("\t<TMX Entry author='" + entry.creator 
				+ "' creation-date='" + LONG_LOG_DATE_FORMAT.format(new java.util.Date(entry.creationDate)) + "'"
				+ " changer = '" + entry.changer + "' change-date='" + LONG_LOG_DATE_FORMAT.format(new java.util.Date(entry.changeDate)) + ">\n");
		else
			buf = new StringBuffer("\t<TMX Entry>\n");			
		if (! digest) {
			buf.append ("\t\t<source>" + entry.source + "</source>\n");		
			buf.append ("\t\t<target>" + entry.translation + "</target>\n");
		} else {
			buf.append ("\t\t<source digest='" + digest(entry.source) + "'>" + entry.source + "</source>\n");		
			buf.append ("\t\t<target digest='" + digest(entry.translation) + "'>" + entry.translation + "</target>\n");			
		}
		buf.append ("\t</TMX Entry>");
		return buf;
	}


}