/**************************************************************************
 Silvestris Cyclotis
 
 Copyright (C) 2015 Silvestris project (http://www.silvestris-lab.org/)
 
 This file is part of Cyclotis plugin for OmegaT
 
 Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
 You may not use this work except in compliance with the Licence.
 You may obtain a copy of the Licence at: L<http://ec.europa.eu/idabc/eupl>

 Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the Licence for the specific language governing permissions and limitations under the Licence. 
 **************************************************************************/

package org.silvestrislab.cyclotis.omegat.http;

import org.silvestrislab.cyclotis.omegat.HttpCyclotis;

import java.io.InputStream;
import java.util.List;

public class FormatFactory {
	public HttpOutputFormat createFormat (String name) throws Exception {
		if (name.contains("plain") || name.contains("line")) return new LineFormat(name);
		if (name.contains("tmx")) return new TMXFormat(name);
		throw new Exception ("Unknown format for output: " +name);
	}
}
