/**************************************************************************
 Silvestris Cyclotis
 
 Copyright (C) 2014 Silvestris project (http://www.silvestris-lab.org/)
 
 This file is part of Cyclotis plugin for OmegaT
 
 Licensed under the EUPL, Version 1.1 or - as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
 You may not use this work except in compliance with the Licence.
 You may obtain a copy of the Licence at: L<http://ec.europa.eu/idabc/eupl>

 Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the Licence for the specific language governing permissions and limitations under the Licence. 
 **************************************************************************/

package org.silvestrislab.cyclotis.omegat.proj.ctx;

import org.omegat.core.data.SourceTextEntry;

import java.security.*;


public class DigestStringContextMode extends StringContextMode implements org.silvestrislab.cyclotis.omegat.Cyclotis.DigestAlgorithm {

	private MessageDigest md; 
	private String CONV_DEFAULT;
	
	public DigestStringContextMode (String algo) throws Exception {
		md = MessageDigest.getInstance(algo);
		CONV_DEFAULT = convert("default");
	}
	
	protected String convert (String orig) {
		try {
			byte[] hash = md.digest(orig.getBytes("UTF-8"));
			
			StringBuilder sb = new StringBuilder(2*hash.length); for (byte b : hash) sb.append(String.format("%02x", b & 0xff));
			return sb.toString();
		} catch (Exception e) {
			e.printStackTrace();
			return orig;
		}
	}

	public String defaultValueForSource (String sourceText) {
		return convert(sourceText);
	}

	public String nonDefaultValueForEntry (SourceTextEntry key) {
		return convert(key.getKey().toString());
	}

	public boolean isDefault (String value) {
		return value == null || value.equals (CONV_DEFAULT);
	}	
	public boolean isDefault (SourceTextEntry key, String value) {
		return value == null || value.equals (CONV_DEFAULT) || value.equals (convert (key.getKey().sourceText));
	}
			
	public boolean isCorrectKey (SourceTextEntry key, String value) {
		return value != null && value.equals (convert (key.getKey().toString()));
	}
	
	public String toString() {
		return "digest(" + md.getAlgorithm() + ")";
	}

	public boolean isUnique() {
		return true;
	}

	public String digest(String text) {
		return convert(text);
	}	
}
