/**************************************************************************
 Silvestris Cyclotis
 
 Copyright (C) 2014 Silvestris project (http://www.silvestris-lab.org/)
 
 This file is part of Cyclotis plugin for OmegaT
 
 Licensed under the EUPL, Version 1.1 or - as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
 You may not use this work except in compliance with the Licence.
 You may obtain a copy of the Licence at: L<http://ec.europa.eu/idabc/eupl>

 Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the Licence for the specific language governing permissions and limitations under the Licence. 
 **************************************************************************/

package org.silvestrislab.cyclotis.omegat.proj.ctx;

import org.omegat.core.data.SourceTextEntry;


public class EntryNumContextMode extends IntContextMode {

	public Integer defaultValueForSource (String sourceText) {
		return 0;
	}

	public Integer nonDefaultValueForEntry (SourceTextEntry key) {
		return key.entryNum();
	}
	
	public boolean isDefault (Integer value) {
		return value == 0 || value == null;
	}	

	public boolean isDefault (SourceTextEntry key, Integer value) {
		return value == 0 || value == null;
	}
	
	public boolean isCorrectKey (SourceTextEntry key, Integer value) {
		return key.entryNum() == value;
	}

	public String toString() {
		return "entryNum";
	}
}
