/**************************************************************************
 Silvestris Cyclotis - Intermediate real-time translation memory server
 
 Copyright (C) 2013 Silvestris project (http://www.silvestris-lab.org/)
 
 This file is only a stub to enable compilation of Cyclotis plugin.
 
 You may not use this work except in compliance with the Licence.
 You may obtain a copy of the Licence at: L<http://ec.europa.eu/idabc/eupl>

 Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the Licence for the specific language governing permissions and limitations under the Licence. 
 **************************************************************************/


package org.omegat.core.data;

import java.util.Map;

/**
 * Storage for TMX entry.
 * 
 * @author Alex Buloichik (alex73mail@gmail.com)
 * @author Guido Leenders
 * @author Aaron Madlon-Kay
 */
public class TMXEntry {
	public enum ExternalLinked{};
	
    public final String source;
    public final String translation;
    public final String changer;
    public final long changeDate;
    public final String creator;
    public final long creationDate;
    public final String note;
    public final boolean defaultTranslation;
	public final Map<String,String> properties;
	public final ExternalLinked linked = null;

    public TMXEntry(String source, String translation, String changer, long changeDate,
            String creator, long creationDate, String note, boolean defaultTranslation,
            Map<String,String> properties) {
        this.source = source;
        this.translation = translation;
        this.changer = changer;
        this.changeDate = changeDate;
        this.creator = creator;
        this.creationDate = creationDate;
        this.note = note;
        this.defaultTranslation = defaultTranslation;
		this.properties = properties;
    }

    public TMXEntry(String source, String translation, String changer, long changeDate, String note,
            boolean defaultTranslation, Map<String,String> properties) {
        this(source, translation, changer, changeDate, null, 0, note, defaultTranslation, properties);
	}
		
	public TMXEntry(String source, String translation, String changer, long changeDate, String note,
            boolean defaultTranslation) {
        this (source, translation, changer, changeDate, note, defaultTranslation, null);
	}

    public TMXEntry(String source, String translation, boolean defaultTranslation) {
        this(source, translation, null, 0, null, 0, null, defaultTranslation, null);
    }

    public boolean isTranslated() {
        return translation != null;
    }
    
    public boolean hasNote() {
        return note != null;
    }
}
