/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool
          with fuzzy matching, translation memory, keyword search,
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2015 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.matching.external;

import org.omegat.core.search.ISearchable;
import org.omegat.core.data.PrepareTMXEntry;

/**
 * An external memory which can retreive all its contents.
 * Such a memory can be included in auto/ and in search window.
 * 
 * Most local memories should be browsable, 
 * but some servers, such as MyMemory, are not.
 * 
 * @author Thomas Cordonnier
 */
public interface IBrowsableMemory extends IExternalMemory, ISearchable<PrepareTMXEntry> {

    /** 
     * Returns all entries from the memory. 
	 * Since this can be very big, returns an iterable which is not necessairly a collection in memory. 
	 **/
	public Iterable<PrepareTMXEntry> getEntries() throws Exception;
	
}
