/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.glos;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.glossaries.IWritableGlossary;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.Language;
import org.silvestrislab.cyclotis.omegat.PostgresqlCyclotis;

public class PostgresqlGlossary
extends PostgresqlCyclotis<GlossaryEntry>
implements IWritableGlossary {
    private String srcLang;
    private boolean priority = false;
    private Map<String, String> indexTypes = new HashMap<String, String>();
    private static final Pattern PTN_WORD = Pattern.compile("\\pL+");

    public PostgresqlGlossary(Properties propList) throws SQLException, ClassNotFoundException {
        super(propList);
        for (String propName : propList.stringPropertyNames()) {
            if (!propName.startsWith("dict.")) continue;
            this.indexTypes.put(propName.substring(5), propList.getProperty(propName));
        }
        this.priority = "true".equals(propList.getProperty("##PriorityGlossary##"));
        this.srcLang = propList.getProperty("srcLang");
        if (this.srcLang != null) {
            this.srcLang = this.postgresIndexType(this.srcLang);
        }
    }

    @Override
    protected GlossaryEntry buildEntry(ResultSet set) throws SQLException {
        String note = set.getString("NOTE");
        if (note == null) {
            note = "";
        }
        return new GlossaryEntry(this.reformatText(set.getString("SRC"), true), this.reformatText(set.getString("TRA"), true), note, this.priority, this.getMemoryName());
    }

    @Override
    protected String selectCondition() {
        this.logMessage("sql", "Select statement = select * from " + this.tableRead + " where to_tsvector(? :: regconfig,src) @@ to_tsquery(? :: regconfig, ?)");
        return " to_tsvector(? :: regconfig,src) @@ to_tsquery(? :: regconfig, ?)";
    }

    @Override
    protected List<String> insertFields() {
        ArrayList<String> res = new ArrayList<String>(4);
        res.add("SRC");
        res.add("TRA");
        if (this.hasNote) {
            res.add("NOTE");
        }
        if (this.mem_id != null) {
            if (this.mem_id instanceof Integer) {
                res.add("MEM_ID");
            } else if (this.mem_id instanceof Long) {
                res.add("MEM_CODE");
            } else if (this.mem_id instanceof String) {
                res.add("MEM_PATH");
            }
        }
        return res;
    }

    private String postgresIndexType(String langName) {
        if (langName != null) {
            if (langName.startsWith("en")) {
                return "english";
            }
            if (langName.startsWith("fr")) {
                return "french";
            }
            if (langName.startsWith("es")) {
                return "spanish";
            }
            if (langName.startsWith("de")) {
                return "german";
            }
            if (langName.startsWith("da")) {
                return "danish";
            }
            if (langName.startsWith("nl")) {
                return "dutch";
            }
            if (langName.startsWith("fi")) {
                return "finnish";
            }
            if (langName.startsWith("hu")) {
                return "hungarian";
            }
            if (langName.startsWith("it")) {
                return "italian";
            }
            if (langName.startsWith("nb")) {
                return "norwegian";
            }
            if (langName.startsWith("nn")) {
                return "norwegian";
            }
            if (langName.startsWith("no")) {
                return "norwegian";
            }
            if (langName.startsWith("pt")) {
                return "portugese";
            }
            if (langName.startsWith("ro")) {
                return "romanian";
            }
            if (langName.startsWith("ru")) {
                return "russian";
            }
            if (langName.startsWith("sv")) {
                return "swedish";
            }
            if (langName.startsWith("tr")) {
                return "turkish";
            }
        }
        return "simple";
    }

    public List<GlossaryEntry> search(Language sLang, Language tLang, String srcText) throws Exception {
        this.logMessage("search", "Searching for '" + srcText + "'");
        Matcher matcher = PTN_WORD.matcher(srcText);
        StringBuffer query = new StringBuffer();
        while (matcher.find()) {
            query.append(" | ").append(matcher.group());
        }
        String indexType = this.srcLang != null ? this.srcLang : this.postgresIndexType(sLang.getLanguageCode());
        PreparedStatement pSelect = this.getSelectStatement();
        pSelect.setString(1, indexType);
        pSelect.setString(2, indexType);
        pSelect.setString(3, query.toString().substring(3));
        return this.retreiveQuery(pSelect);
    }

    public void addEntry(Language sLang, Language tLang, GlossaryEntry entry) throws Exception {
        PreparedStatement pInsert = this.getInsertStatement();
        try {
            pInsert.setString(1, this.reformatText(entry.getSrcText(), false));
            pInsert.setString(2, this.reformatText(entry.getLocText(), false));
            if (this.hasNote) {
                pInsert.setString(3, entry.getCommentText());
            }
            pInsert.executeUpdate();
            this.logEntry("update-contents", entry, false);
        }
        catch (Exception e) {
            this.logException(e);
            throw e;
        }
    }

    public StringBuffer entryToLogString(GlossaryEntry entry, boolean detailed, boolean digest) {
        StringBuffer buf = new StringBuffer("\t<Glossary Entry>\n");
        if (!digest) {
            buf.append("\t\t<source>" + entry.getSrcText() + "</source>\n");
            buf.append("\t\t<target>" + entry.getLocText() + "</target>\n");
        } else {
            buf.append("\t\t<source digest='" + this.digest(entry.getSrcText()) + "'>" + entry.getSrcText() + "</source>\n");
            buf.append("\t\t<target digest='" + this.digest(entry.getLocText()) + "'>" + entry.getLocText() + "</target>\n");
        }
        buf.append("\t</Glossary Entry>");
        return buf;
    }
}

