module Spongiae
   module Unit
      
       # ----------------- For unilingual files ------------
       
       class Unilingual
           attr_reader :props, :text, :id, :file
           
           def initialize(file, id, props, text)
               @props = props; @id = id; @text = text; @file = file
           end
           
           def srcText() @text end
       end
       
       # ----------------- For TMX -------------------
       
       class Variant
           attr_reader :props, :text, :lang
           
           def initialize(lang, props, text)
               @props = props; @lang = lang; @text = text
           end           
       end
       
       class Multilingual
           attr_reader :props, :variants, :id
           
           def initialize(id, props)
               @props = props; @id = id
               @variants = { } # hash of Variants per language
           end
       end

       # ----------------- For strictly bilingual formats like XLIFF or PO -------------------
       
       class Bilingual
           attr_reader :props, :srcText, :traText, :id, :file
           
           def initialize(file, id, props, srcText, traText)
               @props = props; @id = id; @srcText = srcText; @traText = traText; @file = file
           end
       end
   end
end
