require 'java'


module Culter end
module Culter::Ensis

  class EnsisWindow < javax.swing.JFrame
    def initialize(title)
      super(title)
      self.contentPane.setLayout(javax.swing.BoxLayout.new(self.contentPane, javax.swing.BoxLayout::Y_AXIS))      
      # @culter = culter ===> error, why?!?
      self.create_all_components
    end
    
    def start
      self.pack; self.show
    end
        
    def add_pane(name,box) 
      box.setBorder(javax.swing.BorderFactory.createTitledBorder(name))
      self.contentPane.add(box)
    end
  end
  
  # ------------------------------ Editor ------------------------

  class Editor < EnsisWindow
    def initialize(culter)
      super('Segmentation Rules Editor' + (culter == nil ? '' : culter.name))
      @culter = culter
      self.jMenuBar = javax.swing.JMenuBar.new
      menu1 = javax.swing.JMenu.new('Test')
      self.jMenuBar.add menu1
      item1 = javax.swing.JMenuItem.new 'Test'
      item1.addActionListener { |ev| open_test }
      item2 = javax.swing.JMenuItem.new 'Quit'      
      item2.addActionListener { |ev| java.lang.System.exit(0) }
      menu1.add item1; menu1.add item2
      self.setDefaultCloseOperation(javax.swing.JFrame::EXIT_ON_CLOSE);
      self.contentPane.components.each { |item| item.post_init(culter) }
    end
    def input_dialog(question) return javax.swing.JOptionPane.showInputDialog(self, question); end
  end
  
  class OptionsBox < javax.swing.Box
    def initialize(culter)
      super(javax.swing.BoxLayout::Y_AXIS)
      self.add(@cascade = box('Cascade', culter, 'cascade'))
      self.add(formats = javax.swing.Box.new(javax.swing.BoxLayout::X_AXIS))
      formats.add(javax.swing.JLabel.new('Format handles: '))
      formats.add(@fmtStart = box('Start',culter, 'formatHandle.start'))
      formats.add(@fmtEnd = box('End', culter,'formatHandle.end'))
      formats.add(@fmtIsolated = box('Isolated', culter,'formatHandle.isolated'))
    end
    
    def post_init(culter)
      set_box_value(@cascade,'cascade',culter)
      set_box_value(@fmtStart,'formatHandle.start',culter)
      set_box_value(@fmtEnd,'formatHandle.end',culter)
      set_box_value(@fmtIsolated,'formatHandle.isolated',culter)
    end    
      
    def set_box_value(box,field,culter)  
      if field =~ /^(.+)\.(.+)/
          box.selected = culter.send($1)[$2]
      else
          box.selected = culter.send(field)
      end
    end
    
    def box(title, culter, field)
      box = javax.swing.JCheckBox.new(title)
      box.enabled = false	# We are not yet in an editor
      return box
    end
    
  end
  
  class RulesMappingBox < javax.swing.JPanel
    def initialize(culter)
      super
      self.layout = java.awt.BorderLayout.new
      self.add(javax.swing.JScrollPane.new(@list = javax.swing.JList.new), java.awt.BorderLayout::CENTER)
      @list.model = javax.swing.DefaultListModel.new
      @list.addMouseListener(DoubleClickListener.new(self))
    end
    
    def post_init(culter)  
      culter.defaultMapRule.each do |mr| @list.model.addElement("#{mr.pattern.to_s} => #{mr.rulename}") end
      @langRules = culter.langRules
    end
    
    def selectedItem() 
      txt = @list.model.elementAt(@list.selectedIndex) 
      txt[txt.index(' => ') + 4, txt.length]
    end
  end

  class LangRuleTableModel < javax.swing.table.AbstractTableModel
    def initialize(langRule) 
      super()
      @langRule = langRule
    end
    
    def getColumnCount() 4 end
    def getRowCount() @langRule.count end
    def getValueAt(row,col) 
      rule0 = @langRule[row]
      if col == 0 then  
	if rule0.is_a? Culter::CSC::ApplyRuleTemplate then
	  return 'Apply template'
	else
	  if rule0.break then return 'Break' else return 'Exception' end
	end
      end
      if col == 1 then 
	if rule0.is_a? Culter::CSC::ApplyRuleTemplate then
	  return rule0.ruleRef.name
	else
	  if rule0.ruleName =~ /[!:]/ then return '' else return rule0.ruleName end
	end
      end
      if col == 2 then 
	if rule0.is_a? Culter::CSC::ApplyRuleTemplate then
	  return rule0.ruleRef.rewriteRule.before
	else
	  return rule0.before
	end
      end
      if col == 3 then 
	if rule0.is_a? Culter::CSC::ApplyRuleTemplate then
	  return rule0.ruleRef.rewriteRule.after
	else
	  return rule0.after
	end
      end
      return ""
    end
  end
  
  class LangRuleViewDialog < javax.swing.JDialog
    def initialize(name,langRule)
      super(nil, name, true)
      self.add(@view = LangRuleView.new(langRule), java.awt.BorderLayout::CENTER)
      size = @view.preferredSize; size.width = 500; size.height = 100; @view.preferredSize = size
      pack
    end
    def action!() show end
  end  
  
  class LangRuleView < javax.swing.JTable
    def initialize(langRule)
      super(LangRuleTableModel.new(langRule))
      columnModel.getColumn(0).preferredWidth = 100
      columnModel.getColumn(1).preferredWidth = 50
      columnModel.getColumn(2).preferredWidth = 100
      columnModel.getColumn(3).preferredWidth = 100  
      selectionModel.addListSelectionListener { |ev| action_view }
      @langRule = langRule
    end
    def paramsForSelectedRule() 
      if @langRule[selectedRow].is_a? Culter::CSC::ApplyRuleTemplate then
         return @langRule[selectedRow].params
      else
	return nil
      end
    end
    def currentRuleName() getValueAt(selectedRow, 1) end    
  end
  
  class ApplyTemplateListDialog < javax.swing.JDialog
    def initialize(name,list)
      super(nil, name, true)
      self.contentPane.setLayout(javax.swing.BoxLayout.new(self.contentPane, javax.swing.BoxLayout::Y_AXIS))
      @view = Hash.new
      list.each do |paramName, values|
	  self.contentPane.add(javax.swing.JLabel.new("Parameter '#{paramName}':"))
          self.contentPane.add(@view[paramName] = ApplyTemplateListView.new(values))
      end
      pack
    end
    def action!() show end
  end  
  
  class ApplyTemplateListView < javax.swing.JList
    def initialize(list)
      super(javax.swing.DefaultListModel.new)
      if list.is_a? String then item = list; list = Array.new; list.push item end
      list.each { |item| self.model.addElement(item) }
    end
  end  
  
  
  class DoubleClickListener < java.awt.event.MouseAdapter
    def initialize(box) super(); @box = box end
    def mouseClicked(ev) 
      if ev.clickCount == 2 then @box.action_view end 
    end 
  end
    
  class TemplatesBox < javax.swing.JPanel
    
    def initialize(culter)
      super
      self.layout = java.awt.BorderLayout.new
      self.add(javax.swing.JScrollPane.new(@list = javax.swing.JList.new), java.awt.BorderLayout::CENTER)
      @list.model = javax.swing.DefaultListModel.new      
      @list.addMouseListener(DoubleClickListener.new(self))
    end
    
    def post_init(culter)
      if culter.respond_to? 'ruleTemplates'
	 @map = culter.ruleTemplates
         culter.ruleTemplates.each do |name,rule| @list.model.addElement(name) end
      else
	 @map = {}
      end
    end
    def selectedItem() @list.model.elementAt(@list.selectedIndex) end
  end  
  
  class RuleViewDialog < javax.swing.JDialog
    def initialize(rule)
      super(nil, "Rule #{if rule.respond_to? 'name' then rule.name else 'View rule' end}", true)
      self.contentPane.setLayout(javax.swing.BoxLayout.new(self.contentPane, javax.swing.BoxLayout::Y_AXIS))
      self.contentPane.add(panel1 = javax.swing.JPanel.new)
      panel1.layout = java.awt.FlowLayout.new
      panel1.add(rbBreak = javax.swing.JRadioButton.new('Break'))
      panel1.add(rbException = javax.swing.JRadioButton.new('Exception'))
      group = javax.swing.ButtonGroup.new; group.add(rbBreak); group.add(rbException)
      rbBreak.enabled = rbException.enabled = false
      self.contentPane.add(panel2 = javax.swing.JPanel.new)
      panel2.layout = java.awt.FlowLayout.new
      panel2.add(javax.swing.JLabel.new('Before: '))
      panel2.add(beforeBox = javax.swing.JTextField.new(20))      
      self.contentPane.add(panel3 = javax.swing.JPanel.new)      
      panel3.layout = java.awt.FlowLayout.new
      panel3.add(javax.swing.JLabel.new('After: '))
      panel3.add(afterBox = javax.swing.JTextField.new(20))
      self.contentPane.add(panelButtons = javax.swing.JPanel.new)
      panelButtons.layout = java.awt.FlowLayout.new
      panelButtons.add(okBtn = javax.swing.JButton.new('OK'))
      okBtn.addActionListener { |ev| visible = false; dispose }
      @rule = rule
      if rule.respond_to? 'rewriteRule' then rule = rule.rewriteRule end
      if rule.break then rbBreak.selected = true else rbException.selected = true end 
      beforeBox.text = rule.before; afterBox.text = rule.after
      beforeBox.editable = afterBox.editable = false
      pack
    end
    def action!() show end
  end  
  
  # ------------------------------ Tester ------------------------
  
  class Tester < EnsisWindow
    def initialize(culter)
      super('Segmentation Rules Tester - ' + culter.name)
      @culter = culter
      self.setDefaultCloseOperation(javax.swing.JFrame::DISPOSE_ON_CLOSE);
    end
  end
  
  class MyChangeListener
    include javax.swing.event.DocumentListener
    def initialize(textBox,culter,resultBox)
       @textBox = textBox; @culter = culter; @resultBox = resultBox  
    end
    
    def changeUpdate(ev) end
    def insertUpdate(ev) @resultBox.setContents(DebugLine.cut_debug(@culter,@textBox.text)); end
    def removeUpdate(ev) @resultBox.setContents(DebugLine.cut_debug(@culter,@textBox.text)); end
  end
  
  class TextBox < javax.swing.JPanel
    def initialize(culter,resultBox)
      super()
      self.layout = java.awt.BorderLayout.new
      self.add(text = javax.swing.JTextArea.new, java.awt.BorderLayout::CENTER)
      text.document.addDocumentListener(MyChangeListener.new(text,culter,resultBox))
      text.preferredSize = java.awt.Dimension.new(500,100)
      text.lineWrap = text.wrapStyleWord = true
    end    
  end
  
  class MyTableModel < javax.swing.table.AbstractTableModel
    def initialize() 
      @split = Array.new
    end
    
    def contents=(ct) @split = ct end
    
    def getColumnCount() 3 end
    def getRowCount() @split.count end
    def getValueAt(row,col) 
      if col == 0 then return row + 1 end
      if col == 1 then 
          return @split[row].phrase_with_mark 
      end
      if col == 2 then 
          return @split[row].rules.join("\n")
      end
      return ""
    end
  end
  
  class MultilineCellRenderer < javax.swing.JTextArea
    include javax.swing.table.TableCellRenderer
    def initialize(width) super(); @width = width end    
    def getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col)
      self.setText(value.to_s);
      self.wrapStyleWord = self.lineWrap = true
      return self
    end
    
    def calcRowHeight(value)  
      lineCount = 0
      metrics = self.getFontMetrics(self.font)
      self.text.split("\n").each do |line| 
          lineCount = lineCount + metrics.stringWidth(line) / @width + 1
      end
      if lineCount > 0 then return metrics.height * lineCount + 5 else return metrics.height + 5 end
    end
  end
  
  class ResultBox < javax.swing.JPanel
    def initialize
      super
      self.add(@view = javax.swing.JTable.new(), java.awt.BorderLayout::CENTER)
      size = @view.preferredSize; size.width = 500; size.height = 400; @view.preferredSize = size
      @view.showGrid = true
      @view.model = MyTableModel.new()
      @view.columnModel.getColumn(0).preferredWidth = 50
      @view.columnModel.getColumn(1).preferredWidth = 350; @view.columnModel.getColumn(1).cellRenderer = MultilineCellRenderer.new(350)
      @view.columnModel.getColumn(2).preferredWidth = 100; @view.columnModel.getColumn(2).cellRenderer = MultilineCellRenderer.new(100)
    end
    
    def setContents(split)
       @view.model.contents = split
       (0 .. split.count - 1).each do |row|
           height2 = @view.columnModel.getColumn(1).cellRenderer.calcRowHeight(@view.model.getValueAt(row,1))
           height3 = @view.columnModel.getColumn(2).cellRenderer.calcRowHeight(@view.model.getValueAt(row,2))
           if @view.getRowHeight() < height2 then @view.setRowHeight(height2) end
           if @view.getRowHeight() < height3 then @view.setRowHeight(height3) end
       end
       @view.rowHeight = 20 if split.count * @view.rowHeight > 400
       repaint
    end
  end

end

