
$LOAD_PATH << "#{File.dirname(__FILE__)}/../lib"                # For non-standard installation
require 'spongiae/formats/all'  # also contains ExtensionsHash
 
require 'test/unit'

class TestRegHash < Test::Unit::TestCase
    def setup
       @tab = Spongiae::Formats::ExtensionsHash.new({})
       @tab[:id] = 5
       @tab['str'] = 3
       @tab[/de/] = 9
       @tab[/a+/i] = 11
    end
    
    def testString
        assert_equal(@tab[:id], 5)
        assert_equal(@tab['str'], 3)
        assert_equal(@tab[:str], nil)
        assert_equal(@tab['id'], nil)
    end
    
    def testRegex
        assert_equal(@tab['monde'], 9)
        assert_equal(@tab['defi'], 9)
        assert_equal(@tab['xyz'], nil)
        
        assert_equal(@tab['graal'], 11)
        assert_equal(@tab['Aachen'], 11)
        assert_equal(@tab['part'], 11)
        assert_equal(@tab['zut'], nil)
    end
end

