$LOAD_PATH << "#{File.dirname(__FILE__)}/../lib"                # For non-standard installation
require 'spongiae/unit' # contains PropertiesArray and other things

require 'test/unit'

class TestPropertiesArray < Test::Unit::TestCase
    def setup
       @tab = Spongiae::Unit::PropertiesArray.new
       @tab['a'] = 5
       @tab['b'] = 2
       @tab['a'] = "xr"
       @tab['b'] = 10
       @tab['b'] = 'x'
       @tab['c'] = 8
       @tab['a'] = 4
    end
    
    # [](string) returns first value
    def testSingle
        assert_equal(@tab['a'], 5)
    end
    
    def testEach
        @tab.each_with_index do |k,v,i|
            assert_equal(k,'a') if i == 0 or i == 2 or i == 6
            assert_equal(v,'x') if i == 4
        end
    end
    
    def testCopy
        tab1 = Spongiae::Unit::PropertiesArray.new @tab
        assert_equal(tab1['a'], 5)
        tab1.each_with_index do |k,v,i|
            assert_equal(k,'a') if i == 0 or i == 2 or i == 6
            assert_equal(v,'x') if i == 4
        end        
    end
    
    def testInitFromHash
        tab1 = Spongiae::Unit::PropertiesArray.new({ 'a' => 5, 'b' => 10, :c => 30 })
        assert_equal(tab1['a'], 5)        
        assert_equal(tab1[:c], 30)        
        assert_equal(tab1['d'], nil)        
    end
    
    def testClone
        tab1 = @tab.clone
        assert_equal(tab1['a'], 5)
        tab1.each_with_index do |k,v,i|
            assert_equal(k,'a') if i == 0 or i == 2 or i == 6
            assert_equal(v,'x') if i == 4
        end
        tab1['zz'] = 3
        assert_equal(tab1['zz'], 3)    
        assert_equal(@tab['zz'], 3)    
    end
    
    def testDelete
        tab1 = @tab.clone
        assert_equal(tab1['b'], 2)  # first value
        tab1.delete! 1
        assert_equal(tab1['b'], 10) # first after deletion
        tab1.delete! 'b'
        assert_equal(tab1['b'], nil) # first after deletion        
    end
    
    def testReplace
        tab1 = @tab.copyWith('c', 9)
        assert_equal(tab1['b'], 2)  # first value
        assert_equal(tab1['c'], 9)  # first value
        tab1 = @tab.copyWith('b', 12)
        assert_equal(tab1['b'], 12)  # first value
        assert_equal(tab1['a'], 5)  # first value
        tab1 = @tab.copyWith('e', 9)    # value absent from original
        assert_equal(tab1['b'], 2)  # first value
        assert_equal(tab1['e'], 9)  # first value
    end
end

