require 'anguilla'

##
# This module enables usage of anguilla for zip files
module Anguilla::Zip

    case $Anguilla_method
       when 'REXML'
             require 'zip'
             def self.browsingZip(fileName) Zip::File.foreach(fileName) { |entry| yield entry } end
             def self.parse(source,callback) 
                 if source.is_a? Zip::InputStream then
                     raise 'Parsing Zip entries is not implemented'
                 else
                     Anguilla.parse(source,callback) 
                 end
             end
             
       when 'nokogiri'
             require 'zip'
             def self.browsingZip(fileName) Zip::File.foreach(fileName) { |entry| yield entry } end
             def self.parse(source,callback) 
                 if source.is_a? Zip::InputStream then
                     parser = Nokogiri::XML::SAX::Parser.new(Anguilla::NokogiriCallbacksDelegate.new(callback))
                     parser.parse(source)
                 else
                     Anguilla.parse(source,callback) 
                 end
             end
             
             
       when 'libxml'
             require 'zip'
             def self.browsingZip(fileName) Zip::File.foreach(fileName) { |entry| yield entry } end
             def self.parse(source,callback) 
                 if source.is_a? Zip::InputStream then
                     parser = LibXML::XML::SaxParser.io(Anguilla::SaxDelegate.new(callback))
                     parser.parse(source)
                 else
                     Anguilla.parse(source,callback) 
                 end
             end
             
       when 'java-sax'
             def self.parse(source,callback)
                 parser = $ParserFactory.newSAXParser()
                 if source.respond_to? 'markSupported' then  # Java InputStream
                     parser.parse(org.xml.sax.InputSource.new(source), Anguilla::JavaSaxToRuby.new(callback))
                 elsif source.is_a? AZipEntry then  
                     parser.parse(org.xml.sax.InputSource.new(source.get_input_stream), Anguilla::JavaSaxToRuby.new(callback))
                 else
                     Anguilla::parse(source,callback)
                 end
             end  
             
             # Emulate Ruby entry per Java's ZipEntry
             class AZipEntry
                 def initialize(javaZipFile,javaZipEntry) @zipFile = javaZipFile; @entry = javaZipEntry end 
                 def name() @entry.getName() end
                 def get_input_stream() @zipFile.getInputStream(@entry) end
             end
             
             def self.browsingZip(fileName) 
                zip = java.util.zip.ZipFile.new(fileName)
                enum = zip.entries                
                while enum.hasMoreElements()
                    yield AZipEntry.new(zip,enum.nextElement)
                end
                zip.close
             end
             
       when 'net-pull'
           
             def self.parse(source,callback)
                 if source.respond_to? 'Flush' then  # C#'s stream
                    Anguilla::parse_reader(System::Xml::XmlReader::Create(source),callback)
                 elsif source.is_a? AZipEntry then  
                    Anguilla::parse_reader(System::Xml::XmlReader::Create(source.get_input_stream),callback)
                 else
                     Anguilla::parse(source,callback)
                 end
             end  
             
             require 'System.IO.Compression'
             # Emulate Ruby entry per C#'s ZipArchiveEntry
             class AZipEntry
                 def initialize(netEntry) @entry = netEntry end 
                 def name() @entry.Name end
                 def get_input_stream() @entry.Open end
             end
             
             def self.browsingZip(fileName) 
                zip = ZipFile.OpenRead(fileName)
                zip.Entries.each { |entry| yield AZipEntry.new(entry) }
                zip.Close
             end
             
        end # Case
    
end
