module Culter end
module Culter::Args

  $CULTER_VERBOSE = 0   # even if set_verbosity! is not used, which can occur in libraries  
  def self.set_verbosity!
    if not(ARGV.empty?) and (ARGV[0] =~ /-v/) then 
      while ARGV[0] =~ /-(v+)/ do  $CULTER_VERBOSE = $CULTER_VERBOSE + $1.length; ARGV.shift ; end
    end
  end
  
  def self.segmenter_from_args(args = ARGV)
      doc = doc_from_args(args)
      return doc unless doc.respond_to? :segmenter
      lang = ''
      if args.is_a? Hash then
          args.each do |key,val| 
              lang = val if key =~ /^--src/ and key =~ /lang/i
              lang = val if lang.length == 0 and key =~ /^\-o/
          end
      elsif args.is_a? Array then
          args.each_with_index do |key,idx| 
              lang = args[idx + 1] if key =~ /^--src/ and key =~ /lang/i
              lang = args[idx + 1] if lang.length == 0 and key =~ /^\-o/
          end
      end
      if lang.length == 0 then
           puts "Could not find source language for segmentation, using x-unknown" if $CULTER_VERBOSE > 0
           lang = 'x-unknown'
      end
      return doc.segmenter(lang)
   end
      
  
  def self.doc_from_args(args = ARGV)
    if args == nil or args.empty?
      require 'culter/simple'
      if $CULTER_VERBOSE > 0 then puts "Using simple segmenter" end
      return Culter::Simple.new
    else
      if args.is_a? Hash then
          doc = ''; args.each do |key,val| 
              doc = val if key =~ /^--seg/
              doc = val if doc.length == 0 and key =~ /^\-s/
          end
      elsif args.is_a? Array then
          doc = ''; args.each_with_index do |key,idx| 
              doc = args[idx + 1] if key =~ /^--seg/
              doc = args[idx + 1] if doc.length == 0 and key =~ /^\-s/
          end
          # For culter.rb
          doc = args.shift if args[0] =~ /\.(cs[ce][xy])$/i
          doc = args.shift if args[0] =~ /\.srx$/i
          doc = args.shift if args[0] =~ /^simple$/i
      end
      return doc_from_args(nil) if doc =~ /^simple$/i
      return load_file(doc)
    end
  end
  
  def self.load_file(data)      
    if data =~ /\.srx$/i
      require 'culter/srx'
      return Culter::SRX::SrxDocument.new(data)
    elsif data =~ /\.cscx$/i
      require 'culter/cscx'
      return Culter::CSC::XML::CscxDocument.new(data)
    elsif data =~ /\.cscy$/
      require 'culter/cscy'
      return Culter::CSC::YML::CscyDocument.new(data)		
    elsif data =~ /\.csex$/i
      require 'culter/csex'
      return Culter::CSE::XML::CsexDocument.new(data)
    elsif data =~ /\.csey$/i
      require 'culter/cscy'
      return Culter::CSE::YML::CseyDocument.new(data)
    else
      raise ArgumentError.new("#{data} is not a valid segmentation format")	
    end
  end
  
  def self.get_segmenter(doc, data)
    if data =~ /^(.+):(.+)$/
      culter = doc.segmenter($2,$1)
    elsif data != nil
      culter = doc.segmenter(data)
    else
      raise ArgumentError.new("Missing language")
    end
    if $CULTER_VERBOSE > 0 then puts "#{culter.rulesCount} rules found." end
    return culter
  end
  
end
