 
module Spongiae
   module Stats
       
        class StatsRow
            def initialize() @units = 0; @words = 0; @chars = 0; @nbChars = 0 end
            
            def add_unit(unit)
                @units = @units + 1
                unit.scan(/\b\p{Letter}+\b/) { @words = @words + 1 }
                @chars = @chars + unit.length
                @nbChars = @nbChars + unit.gsub(/[\s\r\n\t]/,'').length           
            end
        end
        
        class SegmentsStatsRow < StatsRow
            def initialize() super(); @segments = 0 end
                
            def add_unit(unit, culter = nil)
                super(unit)
                if culter != nil then
                    segments = culter.cut(unit)
                    @segments = @segments + segments.count
                else
                    @segments = @segments + 1
                end
            end
            
            attr_reader :units, :segments, :words, :chars, :nbChars
        end
        
   end
end
