#! /usr/bin/env ruby 

$LOAD_PATH << "#{File.dirname(__FILE__)}/../lib"                # For non-standard installation
require 'spongiae/formats/all'

file = 'example.properties'
ext = $1 if file =~ /\.(\w+)$/
fmt = Spongiae::Formats::ALL[ext].sniff(file)
fmt.load!
$reader = fmt.create(file)


require 'test/unit'

class TestFormatRecognition < Test::Unit::TestCase
    def testRecognition
        assert_equal($reader.class, Spongiae::Formats::JavaProperties)
    end
end

$units = {}
$reader.read_unit { |unit| $units[unit.id] = unit }

class TestContents < Test::Unit::TestCase
    def testEncode
        assert_equal($units['TEST_ENCODE_RU'].srcText, 'Хорошо')
    end
    
    def testLines
        assert_equal($units['TEST_LINES'].srcText, 'Test in two lines')
    end
    
    # In release 1.x, placeables are not treated, but considered as simple strings
    def testPlaceable
        assert_equal($units['TEST_LINES'].srcText.class, String)
        assert_equal($units['TEST_PLACEABLE'].srcText.class, Spongiae::Tags::TaggedString)        
        assert_equal($units['TEST_PLACEABLE'].srcText.to_native_xml(), 'Found {1} documents')        
        assert_equal($units['TEST_PLACEABLE'].srcText.placeables.count, 1)  
        assert_equal($units['TEST_PLACEABLE'].srcText.placeables[0].pos,6)
        assert_equal($units['TEST_PLACEABLE'].srcText.placeables[0].item.contents,'{1}')
        assert_equal($units['TEST_PLACEABLE'].srcText.placeables[0].item.to_tmx(tags: false),'{1}')
        assert_equal($units['TEST_PLACEABLE'].srcText.placeables[0].item.to_tmx(tags: 'empty'),'<ph x="1" />')
        assert_equal($units['TEST_PLACEABLE'].srcText.placeables[0].item.to_tmx(tags: true),'<ph x="1">{1}</ph>')
    end
end
