/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.http;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.TMXProp;
import org.silvestrislab.cyclotis.omegat.HttpCyclotis;
import org.silvestrislab.cyclotis.omegat.http.HttpOutputFormat;
import org.silvestrislab.cyclotis.omegat.tm.HttpMemory;

public class LineFormat
implements HttpOutputFormat {
    public SimpleDateFormat PSQL_DATE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);

    public LineFormat(String name) {
        int idx = name.indexOf("dateFormat");
        if (idx > 0) {
            if ((idx = (name = name.substring(idx) + 11).indexOf(";")) > 0) {
                name = name.substring(0, idx);
            }
            if ((idx = name.indexOf("!")) > 0) {
                String lang = name.substring(0, idx);
                String spec = name.substring(idx + 1);
                this.PSQL_DATE = new SimpleDateFormat(spec, new Locale(lang));
            }
        }
    }

    @Override
    public String MIME() {
        return "text/plain";
    }

    @Override
    public <T> List<T> readFromGet(HttpCyclotis<T> cyclotis, InputStream is, String encoding) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, encoding));
        ArrayList<T> theList = new ArrayList<T>();
        while ((line = reader.readLine()) != null) {
            cyclotis.logMessage("http-response", "HTTP: " + line);
            if (line.trim().length() == 0 || line.startsWith(";")) continue;
            if (line.startsWith("!")) {
                cyclotis.logMessage("", "ERROR: " + line.substring(1).trim());
                if (theList.isEmpty()) {
                    throw new Exception(cyclotis.getProviderName() + "/" + cyclotis.getMemoryName() + ": " + line.substring(1).trim());
                }
            }
            line = line + "|||||---";
            String[] cols = line.split("\\|");
            for (int i = 0; i < cols.length; ++i) {
                try {
                    cols[i] = URLDecoder.decode(cols[i], "UTF-8");
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            theList.add(cyclotis.analyzeLine(this, cols));
        }
        return theList;
    }

    @Override
    public <T> Iterator<T> iterator(final HttpCyclotis<T> cyclotis, final InputStream is, final String encoding) {
        try {
            return new Iterator<T>(){
                BufferedReader reader;
                String line;
                {
                    this.reader = new BufferedReader(new InputStreamReader(is, encoding));
                    this.line = this.nextLine();
                }

                @Override
                public boolean hasNext() {
                    return this.line != null;
                }

                private String nextLine() {
                    try {
                        this.line = this.reader.readLine();
                        if (this.line == null) {
                            return this.line;
                        }
                        if (this.line.startsWith(";")) {
                            return this.nextLine();
                        }
                        if (this.line.startsWith("!")) {
                            cyclotis.logMessage("", "ERROR: " + this.line.substring(1).trim());
                            return this.nextLine();
                        }
                        return this.line;
                    }
                    catch (Exception ex) {
                        cyclotis.logException(ex);
                        this.line = null;
                        return null;
                    }
                }

                @Override
                public T next() {
                    cyclotis.logMessage("http-response", "HTTP: " + this.line);
                    this.line = this.line + "|||||---";
                    String[] cols = this.line.split("\\|");
                    for (int i = 0; i < cols.length; ++i) {
                        try {
                            cols[i] = URLDecoder.decode(cols[i], "UTF-8");
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    Object result = cyclotis.analyzeLine(LineFormat.this, cols);
                    this.line = this.nextLine();
                    return result;
                }
            };
        }
        catch (Exception e) {
            cyclotis.logException(e);
            return Collections.emptyIterator();
        }
    }

    private void fillEntry(HttpCyclotis<?> cyclotis, PrepareTMXEntry entry, String[] cols) {
        try {
            entry.source = cyclotis.reformatText(URLDecoder.decode(cols[0]), true);
            entry.translation = cyclotis.reformatText(URLDecoder.decode(cols[1]), true);
            entry.creator = URLDecoder.decode(cols[2]);
            entry.creationDate = this.PSQL_DATE.parse(cols[3]).getTime();
            entry.changer = URLDecoder.decode(cols[4]);
            entry.changeDate = this.PSQL_DATE.parse(cols[5]).getTime();
            entry.note = URLDecoder.decode(cols[7]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        entry.otherProperties = new ArrayList();
    }

    @Override
    public PrepareTMXEntry buildTmxEntry(HttpMemory memory, Object args) {
        PrepareTMXEntry entry = new PrepareTMXEntry();
        String[] cols = (String[])args;
        this.fillEntry(memory, entry, cols);
        entry.otherProperties = memory.store.fromDatabase(entry.otherProperties, entry);
        entry.otherProperties.add(new TMXProp("db.table.name", cols[8]));
        return entry;
    }

    @Override
    public GlossaryEntry buildGlossaryEntry(Object args, boolean priority) {
        String[] cols = (String[])args;
        if (cols[2] == null) {
            cols[2] = "";
        }
        for (int i = 0; i < cols.length; ++i) {
            try {
                cols[i] = URLDecoder.decode(cols[i], "UTF-8");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new GlossaryEntry(cols[0], cols[1], cols[2], priority);
    }
}

