/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.xliff;

import java.util.List;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.statistics.StatisticsSettings;
import org.omegat.filters3.Attribute;
import org.omegat.filters3.Attributes;
import org.omegat.filters3.Element;
import org.omegat.filters3.Tag;
import org.omegat.filters3.xml.DefaultXMLDialect;
import org.omegat.filters3.xml.XMLContentBasedTag;
import org.omegat.filters3.xml.XMLIntactTag;
import org.omegat.filters3.xml.XMLTag;
import org.omegat.filters3.xml.XMLText;
import org.omegat.filters3.xml.xliff.XLIFFOptions;
import org.omegat.util.InlineTagHandler;
import org.omegat.util.StringUtil;

public class XLIFFDialect
extends DefaultXMLDialect {
    private boolean forceShortCutToF;
    private boolean ignoreTypeForPhTags;
    private boolean ignoreTypeForBptTags;
    private boolean changeStateToNeedsReviewTranslation;
    protected XLIFFOptions.ID_TYPE altTransIDType;

    public void defineDialect(XLIFFOptions options) {
        this.defineParagraphTags(new String[]{"source", "target"});
        this.defineOutOfTurnTags(new String[]{"sub"});
        if (options.get26Compatibility()) {
            this.defineIntactTags(new String[]{"source", "header", "bin-unit", "prop-group", "count-group", "alt-trans", "note", "ph", "bpt", "ept", "it", "context", "seg-source", "sdl:seg-defs"});
        } else {
            this.defineIntactTags(new String[]{"source", "header", "bin-unit", "prop-group", "count-group", "alt-trans", "note", "context", "seg-source", "sdl:seg-defs"});
            this.defineContentBasedTag("bpt", Tag.Type.BEGIN);
            this.defineContentBasedTag("ept", Tag.Type.END);
            this.defineContentBasedTag("it", Tag.Type.ALONE);
            this.defineContentBasedTag("ph", Tag.Type.ALONE);
            this.forceShortCutToF = options.getForceShortcutToF();
            this.ignoreTypeForPhTags = options.getIgnoreTypeForPhTags();
            this.ignoreTypeForBptTags = options.getIgnoreTypeForBptTags();
            this.altTransIDType = options.getAltTransIDType();
            this.changeStateToNeedsReviewTranslation = options.getChangeStateToNeedsReviewTranslation();
        }
    }

    @Override
    public Boolean validatePreformatTag(String tag, Attributes atts) {
        if (!tag.equalsIgnoreCase("mrk")) {
            return false;
        }
        if (atts != null && "seg".equalsIgnoreCase(atts.getValueByName("mtype"))) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean validateIntactTag(String tag, Attributes atts) {
        if (tag.startsWith("str:")) {
            return true;
        }
        if (!(tag.equalsIgnoreCase("group") || tag.equalsIgnoreCase("trans-unit") || tag.equalsIgnoreCase("bin-unit"))) {
            return false;
        }
        if (atts != null && "no".equalsIgnoreCase(atts.getValueByName("translate"))) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean validateContentBasedTag(String tag, Attributes atts) {
        return "mrk".equals(tag) && atts != null && "protected".equals(atts.getValueByName("mtype"));
    }

    @Override
    public void handleXMLTag(XMLTag tag, boolean translated) {
        String nextTranslatedState;
        if (!"target".equals(tag.getTag())) {
            return;
        }
        Attribute attr = tag.getAttributeObject("state");
        if (attr == null) {
            return;
        }
        String state = attr.getValue();
        String string = nextTranslatedState = this.changeStateToNeedsReviewTranslation ? "needs-review-translation" : "translated";
        if (translated && ("needs-translation".equals(state) || "needs-review-translation".equals(state))) {
            attr.setValue(nextTranslatedState);
        } else if ("new".equals(state)) {
            String next = translated ? nextTranslatedState : "needs-translation";
            attr.setValue(next);
        }
    }

    @Override
    public String constructShortcuts(List<Element> elements, List<ProtectedPart> protectedParts) {
        protectedParts.clear();
        InlineTagHandler tagHandler = new InlineTagHandler();
        StringBuilder r = new StringBuilder();
        for (Element el : elements) {
            Tag tag;
            if (el instanceof XMLContentBasedTag) {
                boolean tagProtected;
                int tagIndex;
                int shortcutLetter;
                tag = (XMLContentBasedTag)el;
                String shortcut = null;
                if ("bpt".equals(tag.getTag())) {
                    tagHandler.startBPT(tag.getAttribute("rid"), tag.getAttribute("id"), tag.getAttribute("i"));
                    shortcutLetter = this.calcTagShortcutLetter((XMLContentBasedTag)tag, this.ignoreTypeForBptTags);
                    tagHandler.setTagShortcutLetter(shortcutLetter);
                    tagIndex = tagHandler.endBPT();
                    shortcut = "<" + (shortcutLetter != 0 ? String.valueOf(Character.toChars(shortcutLetter)) : Character.valueOf('f')) + tagIndex + '>';
                    tagProtected = false;
                } else if ("ept".equals(tag.getTag())) {
                    tagHandler.startEPT(tag.getAttribute("rid"), tag.getAttribute("id"), tag.getAttribute("i"));
                    tagIndex = tagHandler.endEPT();
                    shortcutLetter = tagHandler.getTagShortcutLetter();
                    shortcut = "</" + (shortcutLetter != 0 ? String.valueOf(Character.toChars(shortcutLetter)) : Character.valueOf('f')) + tagIndex + '>';
                    tagProtected = false;
                } else if ("it".equals(tag.getTag())) {
                    tagHandler.startOTHER();
                    tagHandler.setCurrentPos(tag.getAttribute("pos"));
                    tagIndex = tagHandler.endOTHER();
                    shortcutLetter = this.calcTagShortcutLetter((XMLContentBasedTag)tag);
                    if ("close".equals(tagHandler.getCurrentPos()) || "end".equals(tagHandler.getCurrentPos())) {
                        if (this.forceShortCutToF) {
                            shortcutLetter = 102;
                        }
                        shortcut = "</" + (shortcutLetter != 0 ? String.valueOf(Character.toChars(shortcutLetter)) : Character.valueOf('f')) + tagIndex + '>';
                    } else {
                        shortcut = "<" + (shortcutLetter != 0 ? String.valueOf(Character.toChars(shortcutLetter)) : Character.valueOf('f')) + tagIndex + '>';
                    }
                    tagProtected = false;
                } else if ("ph".equals(tag.getTag())) {
                    tagHandler.startOTHER();
                    tagIndex = tagHandler.endOTHER();
                    shortcutLetter = this.calcTagShortcutLetter((XMLContentBasedTag)tag, this.ignoreTypeForPhTags);
                    shortcut = "<" + (shortcutLetter != 0 ? String.valueOf(Character.toChars(shortcutLetter)) : Character.valueOf('f')) + tagIndex + "/>";
                    tagProtected = false;
                } else if ("mrk".equals(tag.getTag())) {
                    tagHandler.startOTHER();
                    tagIndex = tagHandler.endOTHER();
                    shortcutLetter = 109;
                    shortcut = "<m" + tagIndex + ">" + ((XMLIntactTag)tag).getIntactContents().sourceToOriginal() + "</m" + tagIndex + ">";
                    tagProtected = true;
                } else {
                    shortcutLetter = 102;
                    tagIndex = -1;
                    tagProtected = false;
                }
                ((XMLContentBasedTag)tag).setShortcutLetter(shortcutLetter);
                ((XMLContentBasedTag)tag).setShortcutIndex(tagIndex);
                ((XMLContentBasedTag)tag).setShortcut(shortcut);
                r.append(shortcut);
                ProtectedPart pp = new ProtectedPart();
                pp.setTextInSourceSegment(shortcut);
                pp.setDetailsFromSourceFile(((XMLIntactTag)tag).toOriginal());
                if (tagProtected) {
                    if (StatisticsSettings.isCountingProtectedText()) {
                        pp.setReplacementWordsCountCalculation("\b" + ((XMLIntactTag)tag).getIntactContents().sourceToOriginal() + "\b");
                    } else {
                        pp.setReplacementWordsCountCalculation("\b");
                    }
                    pp.setReplacementUniquenessCalculation("\b");
                    pp.setReplacementMatchCalculation(((XMLIntactTag)tag).getIntactContents().sourceToOriginal());
                } else {
                    if (StatisticsSettings.isCountingStandardTags()) {
                        pp.setReplacementWordsCountCalculation(tag.toSafeCalcShortcut());
                    } else {
                        pp.setReplacementWordsCountCalculation("\b");
                    }
                    pp.setReplacementUniquenessCalculation("\b");
                    pp.setReplacementMatchCalculation("\b");
                }
                protectedParts.add(pp);
                continue;
            }
            if (el instanceof Tag) {
                tag = (Tag)el;
                int tagIndex = tagHandler.paired(tag.getTag(), tag.getType());
                tag.setIndex(tagIndex);
                String shortcut = tag.toShortcut();
                r.append(shortcut);
                ProtectedPart pp = new ProtectedPart();
                pp.setTextInSourceSegment(shortcut);
                pp.setDetailsFromSourceFile(tag.toOriginal());
                if (StatisticsSettings.isCountingStandardTags()) {
                    pp.setReplacementWordsCountCalculation(tag.toSafeCalcShortcut());
                } else {
                    pp.setReplacementWordsCountCalculation("\b");
                }
                pp.setReplacementUniquenessCalculation("\b");
                pp.setReplacementMatchCalculation("\b");
                protectedParts.add(pp);
                continue;
            }
            r.append(el.toShortcut());
        }
        return r.toString();
    }

    private int calcTagShortcutLetter(XMLContentBasedTag tag) {
        return this.calcTagShortcutLetter(tag, false);
    }

    private int calcTagShortcutLetter(XMLContentBasedTag tag, boolean ignoreTypeForPhtags) {
        int s;
        if (!tag.getIntactContents().isEmpty() && tag.getIntactContents().get(0) instanceof XMLText) {
            XMLText xmlText = (XMLText)tag.getIntactContents().get(0);
            s = StringUtil.getFirstLetterLowercase(xmlText.getText());
        } else {
            String type = StringUtil.nvl(tag.getAttribute("ctype"), tag.getAttribute("type"));
            s = type != null && !ignoreTypeForPhtags ? StringUtil.getFirstLetterLowercase(type) : 0;
        }
        return s;
    }
}

