/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.omegat.core.spellchecker.DictionaryManager;
import org.omegat.util.HttpConnectionUtils;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class DictionaryInstallerDialog
extends JDialog {
    private final DictionaryManager dicMan;
    private final DefaultListModel<String> listModel = new DefaultListModel();
    private LoaderWorker loader = null;
    private InstallerWorker installer = null;
    private static final Cursor HOURGLASS_CURSOR = Cursor.getPredefinedCursor(3);
    private JButton closeButton;
    private JList<String> dictionaryList;
    private JTextArea infoTextArea;
    private JButton installButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane2;
    private JLabel listLabel;
    private JProgressBar progressBar;

    public DictionaryInstallerDialog(Window parent, DictionaryManager dicMan) {
        super(parent, JDialog.DEFAULT_MODALITY_TYPE);
        StaticUIUtils.setEscapeClosable(this);
        this.dicMan = dicMan;
        this.initComponents();
        this.dictionaryList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    DictionaryInstallerDialog.this.installButtonActionPerformed(null);
                }
            }
        });
        this.setLocationRelativeTo(parent);
        this.dictionaryListValueChanged(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                DictionaryInstallerDialog.this.progressBar.setVisible(true);
                DictionaryInstallerDialog.this.loader = new LoaderWorker();
                DictionaryInstallerDialog.this.loader.execute();
            }
        });
    }

    private void initComponents() {
        this.infoTextArea = new JTextArea();
        this.jPanel1 = new JPanel();
        this.listLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.dictionaryList = new JList();
        this.jPanel2 = new JPanel();
        this.installButton = new JButton();
        this.jPanel3 = new JPanel();
        this.progressBar = new JProgressBar();
        this.jPanel4 = new JPanel();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(OStrings.getString("GUI_DICTIONARY_INSTALLER_TITLE"));
        this.setPreferredSize(new Dimension(400, 500));
        this.infoTextArea.setEditable(false);
        this.infoTextArea.setFont(new JLabel().getFont());
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setText(OStrings.getString("GUI_DICTIONARY_INSTALLER_TEXT_GO"));
        this.infoTextArea.setWrapStyleWord(true);
        this.infoTextArea.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.infoTextArea.setDragEnabled(false);
        this.infoTextArea.setFocusable(false);
        this.infoTextArea.setOpaque(false);
        this.getContentPane().add((Component)this.infoTextArea, "North");
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jPanel1.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.listLabel, (String)OStrings.getString("GUI_DICTIONARY_INSTALLER_AVAILABLE"));
        this.jPanel1.add((Component)this.listLabel, "North");
        this.dictionaryList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DictionaryInstallerDialog.this.dictionaryListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.dictionaryList);
        this.jPanel1.add((Component)this.jScrollPane2, "Center");
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.jPanel2.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.installButton, (String)OStrings.getString("GUI_DICTIONARY_INSTALLER_INSTALL"));
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DictionaryInstallerDialog.this.installButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.installButton, "North");
        this.jPanel1.add((Component)this.jPanel2, "East");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jPanel3.setLayout(new BorderLayout());
        this.progressBar.setIndeterminate(true);
        this.jPanel3.add((Component)this.progressBar, "Center");
        this.jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 2));
        Mnemonics.setLocalizedText((AbstractButton)this.closeButton, (String)OStrings.getString("BUTTON_CLOSE"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DictionaryInstallerDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.closeButton);
        this.jPanel3.add((Component)this.jPanel4, "East");
        this.getContentPane().add((Component)this.jPanel3, "South");
        this.pack();
    }

    private void installButtonActionPerformed(ActionEvent evt) {
        if (this.installer != null) {
            this.installer.cancel(true);
        }
        this.progressBar.setVisible(true);
        this.installButton.setEnabled(false);
        this.closeButton.setEnabled(false);
        this.installer = new InstallerWorker();
        this.installer.execute();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        if (this.installer != null) {
            this.installer.cancel(true);
        }
        if (this.loader != null) {
            this.loader.cancel(true);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void dictionaryListValueChanged(ListSelectionEvent evt) {
        this.installButton.setEnabled(!this.dictionaryList.getSelectedValuesList().isEmpty());
    }

    private class InstallerWorker
    extends SwingWorker<List<String>, String> {
        private Cursor oldCursor;

        private InstallerWorker() {
        }

        @Override
        protected List<String> doInBackground() throws Exception {
            this.oldCursor = DictionaryInstallerDialog.this.getCursor();
            DictionaryInstallerDialog.this.setCursor(HOURGLASS_CURSOR);
            List selection = DictionaryInstallerDialog.this.dictionaryList.getSelectedValuesList();
            ArrayList<String> completed = new ArrayList<String>();
            for (String item : selection) {
                if (this.isCancelled()) break;
                String langCode = item.substring(0, item.indexOf(" "));
                try {
                    DictionaryInstallerDialog.this.dicMan.installRemoteDictionary(langCode);
                    completed.add(item);
                    this.publish(item);
                }
                catch (HttpConnectionUtils.FlakyDownloadException ex) {
                    Log.log(ex);
                    this.showError(OStrings.getString("GUI_SPELLCHECKER_ERROR_ON_INSTALL"));
                }
                catch (Exception ex) {
                    Log.log(ex);
                    this.showError(ex.toString());
                }
            }
            return completed;
        }

        private void showError(String msg) {
            DictionaryInstallerDialog.this.setCursor(this.oldCursor);
            JOptionPane.showMessageDialog(DictionaryInstallerDialog.this, msg, OStrings.getString("ERROR_TITLE"), 0);
            DictionaryInstallerDialog.this.setCursor(HOURGLASS_CURSOR);
        }

        @Override
        protected void process(List<String> chunks) {
            chunks.forEach(DictionaryInstallerDialog.this.listModel::removeElement);
        }

        @Override
        protected void done() {
            try {
                ((List)this.get()).forEach(DictionaryInstallerDialog.this.listModel::removeElement);
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
            DictionaryInstallerDialog.this.setCursor(this.oldCursor);
            DictionaryInstallerDialog.this.progressBar.setVisible(false);
            DictionaryInstallerDialog.this.installButton.setEnabled(true);
            DictionaryInstallerDialog.this.closeButton.setEnabled(true);
        }
    }

    private class LoaderWorker
    extends SwingWorker<List<String>, Void> {
        private LoaderWorker() {
        }

        @Override
        protected List<String> doInBackground() throws Exception {
            return DictionaryInstallerDialog.this.dicMan.getInstallableDictionaryNameList();
        }

        @Override
        protected void done() {
            try {
                List list = (List)this.get();
                list.forEach(DictionaryInstallerDialog.this.listModel::addElement);
                DictionaryInstallerDialog.this.dictionaryList.setModel(DictionaryInstallerDialog.this.listModel);
                DictionaryInstallerDialog.this.dictionaryList.setEnabled(true);
                if (list.isEmpty()) {
                    DictionaryInstallerDialog.this.installButton.setEnabled(false);
                    DictionaryInstallerDialog.this.infoTextArea.setText(OStrings.getString("GUI_DICTIONARY_INSTALLER_TEXT_NOTHING"));
                }
                DictionaryInstallerDialog.this.progressBar.setVisible(false);
            }
            catch (InterruptedException | ExecutionException ex) {
                Log.log(ex);
                JOptionPane.showMessageDialog(DictionaryInstallerDialog.this, ex.getLocalizedMessage(), OStrings.getString("ERROR_TITLE"), 0);
                DictionaryInstallerDialog.this.closeButtonActionPerformed(null);
            }
        }
    }
}

