/*
 * Decompiled with CFR 0.152.
 */
package net.briac.omegat.plugin.omt;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.briac.omegat.plugin.omt.ManageOMTPackage;
import org.apache.commons.io.FilenameUtils;

public class DirectoryFilter
implements DirectoryStream.Filter<Path> {
    private final List<Pattern> excludePatterns = new ArrayList<Pattern>();
    private final Path projectRoot;

    public DirectoryFilter(Path projectRoot, List<String> excludePatterns) {
        this.projectRoot = projectRoot;
        for (String e : excludePatterns) {
            this.excludePatterns.add(Pattern.compile(e));
        }
        this.excludePatterns.add(Pattern.compile("\\.lck$"));
        this.excludePatterns.add(Pattern.compile("omt-packer.log".replace(".", "\\.") + "$"));
    }

    @Override
    public boolean accept(Path entry) throws IOException {
        String matchEntry = FilenameUtils.normalizeNoEndSeparator((String)this.projectRoot.relativize(entry).toString(), (boolean)true);
        for (Pattern excludePattern : this.excludePatterns) {
            if (!excludePattern.matcher(matchEntry).find()) continue;
            ManageOMTPackage.omtPackLog(String.format("Exclude entry [%s] from regex [%s]", matchEntry, excludePattern.pattern()));
            return false;
        }
        return true;
    }
}

