/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.po;

import java.awt.Window;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.omegat.core.data.ProtectedPart;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.po.PoOptionsDialog;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.StringUtil;
import org.omegat.util.TagUtil;

public class PoFilter
extends AbstractFilter {
    public static final String OPTION_ALLOW_BLANK = "disallowBlank";
    public static final String OPTION_ALLOW_EDITING_BLANK_SEGMENT = "allowEditingBlankSegment";
    public static final String OPTION_SKIP_HEADER = "skipHeader";
    public static final String OPTION_AUTO_FILL_IN_PLURAL_STATEMENT = "autoFillInPluralStatement";
    public static final String OPTION_FORMAT_MONOLINGUAL = "monolingualFormat";
    private static final Map<String, PluralInfo> PLURAL_INFOS;
    private boolean allowBlank = false;
    private boolean allowEditingBlankSegment = false;
    private boolean skipHeader = false;
    private boolean formatMonolingual = false;
    private boolean autoFillInPluralStatement = false;
    protected static final Pattern COMMENT_FUZZY;
    protected static final Pattern COMMENT_FUZZY_OTHER;
    protected static final Pattern COMMENT_FUZZY_MSGID;
    protected static final Pattern COMMENT_FUZZY_MSGCTX;
    protected static final Pattern COMMENT_NOWRAP;
    protected static final Pattern COMMENT_TRANSLATOR;
    protected static final Pattern COMMENT_EXTRACTED;
    protected static final Pattern COMMENT_REFERENCE;
    protected static final Pattern MSG_ID;
    protected static final Pattern MSG_STR;
    protected static final Pattern MSG_CTX;
    protected static final Pattern MSG_OTHER;
    protected static final Pattern PLURAL_FORMS;
    protected static final Pattern MSG_FUZZY;
    private StringBuilder[] sources;
    private StringBuilder[] targets;
    private StringBuilder translatorComments;
    private StringBuilder extractedComments;
    private StringBuilder references;
    private StringBuilder sourceFuzzyTrue;
    private int plurals = 2;
    private String path;
    private boolean nowrap;
    private boolean fuzzy;
    private boolean fuzzyTrue;
    private boolean headerProcessed;
    private BufferedWriter out;
    protected static final Pattern R1;
    protected static final Pattern R2;
    protected static final Pattern R3;
    protected static final Pattern R4;

    @Override
    public String getFileFormatName() {
        return OStrings.getString("POFILTER_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.po", StandardCharsets.UTF_8.name(), StandardCharsets.UTF_8.name()), new Instance("*.pot", StandardCharsets.UTF_8.name(), StandardCharsets.UTF_8.name())};
    }

    @Override
    protected BufferedReader createReader(File inFile, String inEncoding) throws IOException {
        BOMInputStream bomInputStream = new BOMInputStream(Files.newInputStream(inFile.toPath(), new OpenOption[0]), new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE});
        ByteOrderMark bom = bomInputStream.getBOM();
        String charset = bom != null ? bom.getCharsetName() : (inEncoding == null ? Charset.defaultCharset().name() : inEncoding);
        return new BufferedReader(new InputStreamReader((InputStream)bomInputStream, charset));
    }

    @Override
    protected BufferedWriter createWriter(File outFile, String outEncoding) throws IOException {
        if (outFile == null) {
            return null;
        }
        Charset charset = outEncoding != null ? Charset.forName(outEncoding) : Charset.defaultCharset();
        return Files.newBufferedWriter(outFile.toPath(), charset, new OpenOption[0]);
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return true;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    public String getFuzzyMark() {
        return "PO-fuzzy";
    }

    @Override
    public void processFile(File inFile, File outFile, FilterContext fc) throws IOException, TranslationException {
        String allowBlankStr = (String)this.processOptions.get(OPTION_ALLOW_BLANK);
        this.allowBlank = allowBlankStr == null || allowBlankStr.equalsIgnoreCase("true");
        String allowEditingBlankSegmentStr = (String)this.processOptions.get(OPTION_ALLOW_EDITING_BLANK_SEGMENT);
        this.allowEditingBlankSegment = allowEditingBlankSegmentStr == null || allowEditingBlankSegmentStr.equalsIgnoreCase("true");
        String skipHeaderStr = (String)this.processOptions.get(OPTION_SKIP_HEADER);
        this.skipHeader = "true".equalsIgnoreCase(skipHeaderStr);
        String autoFillInPluralStatementStr = (String)this.processOptions.get(OPTION_AUTO_FILL_IN_PLURAL_STATEMENT);
        this.autoFillInPluralStatement = "true".equalsIgnoreCase(autoFillInPluralStatementStr);
        String formatMonolingualStr = (String)this.processOptions.get(OPTION_FORMAT_MONOLINGUAL);
        this.formatMonolingual = "true".equalsIgnoreCase(formatMonolingualStr);
        this.inEncodingLastParsedFile = fc.getInEncoding();
        try (BufferedReader reader = this.createReader(inFile, this.inEncodingLastParsedFile);
             BufferedWriter writer = this.createWriter(outFile, fc.getOutEncoding());){
            this.processFile(reader, writer, fc);
        }
    }

    @Override
    protected void alignFile(BufferedReader sourceFile, BufferedReader translatedFile, FilterContext fc) throws Exception {
        this.out = null;
        this.processPoFile(translatedFile, fc);
    }

    @Override
    public void processFile(BufferedReader in, BufferedWriter out, FilterContext fc) throws IOException {
        this.out = out;
        this.processPoFile(in, fc);
    }

    private void processPoFile(BufferedReader in, FilterContext fc) throws IOException {
        String s;
        this.fuzzy = false;
        this.fuzzyTrue = false;
        this.nowrap = false;
        MODE currentMode = null;
        int currentPlural = 0;
        this.headerProcessed = false;
        this.sources = new StringBuilder[2];
        this.sources[0] = new StringBuilder();
        this.sources[1] = new StringBuilder();
        this.targets = new StringBuilder[2];
        this.targets[0] = new StringBuilder();
        this.targets[1] = new StringBuilder();
        this.translatorComments = new StringBuilder();
        this.extractedComments = new StringBuilder();
        this.references = new StringBuilder();
        this.sourceFuzzyTrue = new StringBuilder();
        this.path = "";
        while ((s = in.readLine()) != null) {
            Matcher mTrueFuzzy = COMMENT_FUZZY_MSGID.matcher(s = s.trim());
            if (mTrueFuzzy.matches()) {
                this.fuzzyTrue = true;
                this.sourceFuzzyTrue.append(mTrueFuzzy.group(1));
                continue;
            }
            Matcher mFuzzyCtx = COMMENT_FUZZY_MSGCTX.matcher(s);
            if (mFuzzyCtx.matches()) continue;
            if (COMMENT_FUZZY.matcher(s).matches()) {
                currentPlural = 0;
                this.fuzzy = true;
                this.flushTranslation(currentMode, fc);
                continue;
            }
            if (COMMENT_FUZZY_OTHER.matcher(s).matches()) {
                currentPlural = 0;
                this.fuzzy = true;
                this.flushTranslation(currentMode, fc);
                s = s.replaceAll("(.*), fuzzy(.*)", "$1$2");
            }
            if (COMMENT_NOWRAP.matcher(s).matches()) {
                currentPlural = 0;
                this.flushTranslation(currentMode, fc);
                this.nowrap = true;
                this.eol(s);
                continue;
            }
            Matcher mId = MSG_ID.matcher(s);
            if (mId.matches()) {
                currentPlural = 0;
                String text = mId.group(2);
                if (mId.group(1) == null) {
                    if (this.sources[0].length() > 0) {
                        this.flushTranslation(currentMode, fc);
                    }
                    currentMode = MODE.MSGID;
                    this.sources[0].append(text);
                } else {
                    currentMode = MODE.MSGID_PLURAL;
                    this.sources[1].append(text);
                }
                this.eol(s);
                continue;
            }
            Matcher mStr = MSG_STR.matcher(s);
            if (mStr.matches()) {
                if (this.allowEditingBlankSegment && this.sources[0].length() == 0 && this.references.length() > 0 && this.headerProcessed) {
                    String aux = this.references + this.extractedComments.toString();
                    this.sources[0].append(aux);
                }
                String text = mStr.group(3);
                if (mStr.group(1) == null) {
                    currentMode = MODE.MSGSTR;
                    this.targets[0].append(text);
                    currentPlural = 0;
                    continue;
                }
                currentMode = MODE.MSGSTR_PLURAL;
                currentPlural = Integer.parseInt(mStr.group(2));
                if (currentPlural >= this.plurals) continue;
                this.targets[currentPlural].append(text);
                continue;
            }
            Matcher mCtx = MSG_CTX.matcher(s);
            if (mCtx.matches()) {
                currentMode = MODE.MSGCTX;
                currentPlural = 0;
                this.path = mCtx.group(1);
                this.eol(s);
                continue;
            }
            Matcher mReference = COMMENT_REFERENCE.matcher(s);
            if (mReference.matches()) {
                currentPlural = 0;
                this.references.append(mReference.group(1));
                this.references.append("\n");
                this.eol(s);
                continue;
            }
            Matcher mExtracted = COMMENT_EXTRACTED.matcher(s);
            if (mExtracted.matches()) {
                currentPlural = 0;
                this.extractedComments.append(mExtracted.group(1));
                this.extractedComments.append("\n");
                this.eol(s);
                continue;
            }
            Matcher mTranslator = COMMENT_TRANSLATOR.matcher(s);
            if (mTranslator.matches()) {
                currentPlural = 0;
                this.translatorComments.append(mTranslator.group(1));
                this.translatorComments.append("\n");
                this.eol(s);
                continue;
            }
            Matcher mMsgFuzzy = MSG_FUZZY.matcher(s);
            if (mMsgFuzzy.matches()) {
                this.sourceFuzzyTrue.append(mMsgFuzzy.group(1));
                continue;
            }
            Matcher mOther = MSG_OTHER.matcher(s);
            if (mOther.matches()) {
                String text = mOther.group(1);
                if (currentMode == null) {
                    throw new IOException(OStrings.getString("POFILTER_INVALID_FORMAT"));
                }
                switch (currentMode) {
                    case MSGID: {
                        this.sources[0].append(text);
                        this.eol(s);
                        break;
                    }
                    case MSGID_PLURAL: {
                        this.sources[1].append(text);
                        this.eol(s);
                        break;
                    }
                    case MSGSTR: {
                        this.targets[0].append(text);
                        break;
                    }
                    case MSGSTR_PLURAL: {
                        this.targets[currentPlural].append(text);
                        break;
                    }
                    case MSGCTX: {
                        this.eol(s);
                    }
                }
                continue;
            }
            this.flushTranslation(currentMode, fc);
            this.eol(s);
        }
        this.flushTranslation(currentMode, fc);
    }

    protected void eol(String s) throws IOException {
        if (this.out != null) {
            this.out.write(s);
            this.out.write(10);
        }
    }

    protected void parseOrAlign(int pair) {
        String pathSuffix;
        String s;
        String c = "";
        if (pair > 0) {
            s = this.unescape(this.sources[1].toString());
            pathSuffix = "[" + pair + "]";
            c = c + StringUtil.format(OStrings.getString("POFILTER_PLURAL_FORM_COMMENT"), pair) + "\n";
        } else {
            s = this.unescape(this.sources[pair].toString());
            pathSuffix = "";
        }
        String t = this.unescape(this.targets[pair].toString());
        if (this.translatorComments.length() > 0) {
            c = c + OStrings.getString("POFILTER_TRANSLATOR_COMMENTS") + "\n" + this.unescape(this.translatorComments.toString() + "\n");
        }
        if (this.extractedComments.length() > 0) {
            c = c + OStrings.getString("POFILTER_EXTRACTED_COMMENTS") + "\n" + this.unescape(this.extractedComments.toString() + "\n");
        }
        if (this.references.length() > 0) {
            c = c + OStrings.getString("POFILTER_REFERENCES") + "\n" + this.unescape(this.references.toString() + "\n");
        }
        if (c.length() == 0) {
            c = null;
        }
        this.parseOrAlign(s, t, c, pathSuffix);
    }

    protected void parseOrAlign(String source, String translation, String comments, String pathSuffix) {
        if (translation.isEmpty()) {
            translation = null;
        }
        if (this.entryParseCallback != null) {
            if (this.formatMonolingual) {
                List<ProtectedPart> protectedParts = TagUtil.applyCustomProtectedParts(translation, PatternConsts.PRINTF_VARS, null);
                this.entryParseCallback.addEntry(source, translation, null, this.fuzzy, comments, this.path + pathSuffix, this, protectedParts);
            } else {
                List<ProtectedPart> protectedParts = TagUtil.applyCustomProtectedParts(source, PatternConsts.PRINTF_VARS, null);
                if (this.fuzzyTrue) {
                    String[] props = new String[]{"comment", comments, "reference", "true"};
                    this.entryParseCallback.addEntryWithProperties(null, this.sourceFuzzyTrue.toString(), translation, false, props, this.path + pathSuffix, this, null);
                    this.fuzzyTrue = false;
                    this.fuzzy = false;
                    translation = null;
                }
                this.entryParseCallback.addEntry(null, source, translation, this.fuzzy, comments, this.path + pathSuffix, this, protectedParts);
            }
        } else if (this.entryAlignCallback != null) {
            this.entryAlignCallback.addTranslation(null, source, translation, this.fuzzy, this.path + pathSuffix, this);
        }
    }

    protected void parseHeader(String header, FilterContext fc) {
        if (this.entryParseCallback != null && !this.skipHeader) {
            header = this.unescape(this.autoFillInPluralStatement(header, fc));
            List<ProtectedPart> protectedParts = TagUtil.applyCustomProtectedParts(header, PatternConsts.PRINTF_VARS, null);
            this.entryParseCallback.addEntry(null, header, null, false, null, this.path, this, protectedParts);
        }
    }

    protected void flushTranslation(MODE currentMode, FilterContext fc) throws IOException {
        if (this.sources[0].length() == 0 && this.path.isEmpty()) {
            this.headerProcessed = true;
            if (this.targets[0].length() == 0) {
                return;
            }
            StringBuilder targets0 = this.targets[0];
            String header = this.targets[0].toString();
            Matcher pluralMatcher = PLURAL_FORMS.matcher(header);
            if (pluralMatcher.find()) {
                String nrOfPluralsString = header.substring(pluralMatcher.start(1), pluralMatcher.end(1));
                this.plurals = Integer.parseInt(nrOfPluralsString);
            } else {
                Language targetLang = fc.getTargetLang();
                String lang = targetLang.getLanguageCode().toLowerCase(Locale.ENGLISH);
                PluralInfo pluralInfo = PLURAL_INFOS.get(lang);
                if (pluralInfo != null) {
                    this.plurals = pluralInfo.plurals;
                }
            }
            this.targets = new StringBuilder[this.plurals];
            this.targets[0] = targets0;
            for (int i = 1; i < this.plurals; ++i) {
                this.targets[i] = new StringBuilder();
            }
            if (this.out != null) {
                this.out.write("msgstr " + this.getTranslation(null, this.targets[0], false, true, fc, 0) + "\n");
            } else {
                this.parseHeader(this.targets[0].toString(), fc);
            }
            this.fuzzy = false;
        } else {
            int i;
            if (this.sources[1].length() == 0) {
                if (this.out != null) {
                    if (this.formatMonolingual) {
                        this.out.write("msgstr " + this.getTranslation(this.sources[0].toString(), this.targets[0], this.allowBlank, false, fc, 0) + "\n");
                    } else {
                        this.out.write("msgstr " + this.getTranslation(null, this.sources[0], this.allowBlank, false, fc, 0) + "\n");
                    }
                } else {
                    this.parseOrAlign(0);
                }
            } else if (this.out != null) {
                this.out.write("msgstr[0] " + this.getTranslation(null, this.sources[0], this.allowBlank, false, fc, 0) + "\n");
                for (i = 1; i < this.plurals; ++i) {
                    this.out.write("msgstr[" + i + "] " + this.getTranslation(null, this.sources[1], this.allowBlank, false, fc, i) + "\n");
                }
            } else {
                this.parseOrAlign(0);
                for (i = 1; i < this.plurals; ++i) {
                    this.parseOrAlign(i);
                }
            }
            this.fuzzy = false;
        }
        this.sources[0].setLength(0);
        this.sources[1].setLength(0);
        for (int i = 0; i < this.plurals; ++i) {
            this.targets[i].setLength(0);
        }
        this.path = "";
        this.translatorComments.setLength(0);
        this.extractedComments.setLength(0);
        this.references.setLength(0);
        this.sourceFuzzyTrue.setLength(0);
    }

    private String getTranslation(String id, StringBuilder en, boolean allowNull, boolean isHeader, FilterContext fc, int plural) {
        String entry = this.unescape(en.toString());
        String pathSuffix = plural > 0 ? "[" + plural + "]" : "";
        String translation = null;
        if (isHeader) {
            entry = this.autoFillInPluralStatement(entry, fc);
        }
        if ((translation = isHeader && this.skipHeader ? entry : this.entryTranslateCallback.getTranslation(id, entry, this.path + pathSuffix)) == null && !allowNull) {
            translation = entry;
        }
        if (translation != null) {
            return "\"" + this.escape(translation) + "\"";
        }
        return "\"\"";
    }

    private String autoFillInPluralStatement(String header, FilterContext fc) {
        Language targetLang;
        String lang;
        PluralInfo pluralInfo;
        if (this.autoFillInPluralStatement && (pluralInfo = PLURAL_INFOS.get(lang = (targetLang = fc.getTargetLang()).getLanguageCode().toLowerCase(Locale.ENGLISH))) != null) {
            return header.replaceAll("Plural-Forms: nplurals=INTEGER; plural=EXPRESSION;", "Plural-Forms: nplurals=" + pluralInfo.plurals + "; plural=" + pluralInfo.expression + ";");
        }
        return header;
    }

    private String unescape(String entry) {
        entry = R1.matcher(entry).replaceAll("$1\"");
        entry = R2.matcher(entry).replaceAll("$1\n");
        entry = R3.matcher(entry).replaceAll("$1\t");
        entry = R4.matcher(entry).replaceAll("\\\n");
        entry = entry.replace("\\\\", "\\");
        return entry;
    }

    private String escape(String translation) {
        translation = translation.replace("\\", "\\\\");
        translation = translation.replace("\"", "\\\"");
        if ((translation = translation.replace("\n", "\\n\"\n\"")).endsWith("\"\n\"")) {
            translation = translation.substring(0, translation.length() - 3);
        }
        if (this.nowrap && translation.contains("\n")) {
            translation = "\"\n\"" + translation;
        }
        translation = translation.replace("\t", "\\t");
        return translation;
    }

    @Override
    public Map<String, String> changeOptions(Window parent, Map<String, String> config) {
        try {
            PoOptionsDialog dialog = new PoOptionsDialog(parent, config);
            dialog.setVisible(true);
            if (1 == dialog.getReturnStatus()) {
                return dialog.getOptions();
            }
            return null;
        }
        catch (Exception e) {
            Log.log(OStrings.getString("POFILTER_EXCEPTION"));
            Log.log(e);
            return null;
        }
    }

    @Override
    public boolean hasOptions() {
        return true;
    }

    @Override
    public boolean isBilingual() {
        return true;
    }

    static {
        HashMap<String, PluralInfo> info = new HashMap<String, PluralInfo>();
        info.put("ach", new PluralInfo(2, "(n > 1)"));
        info.put("af", new PluralInfo(2, "(n != 1)"));
        info.put("ak", new PluralInfo(2, "(n > 1)"));
        info.put("am", new PluralInfo(2, "(n > 1)"));
        info.put("an", new PluralInfo(2, "(n != 1)"));
        info.put("ar", new PluralInfo(6, " n==0 ? 0 : n==1 ? 1 : n==2 ? 2 : n%100>=3 && n%100<=10 ? 3 : n%100>=11 ? 4 : 5"));
        info.put("arn", new PluralInfo(2, "(n > 1)"));
        info.put("ast", new PluralInfo(2, "(n != 1)"));
        info.put("ay", new PluralInfo(1, "0"));
        info.put("az", new PluralInfo(2, "(n != 1) "));
        info.put("be", new PluralInfo(3, "(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2)"));
        info.put("bg", new PluralInfo(2, "(n != 1)"));
        info.put("bn", new PluralInfo(2, "(n != 1)"));
        info.put("bo", new PluralInfo(1, "0"));
        info.put("br", new PluralInfo(2, "(n > 1)"));
        info.put("brx", new PluralInfo(2, "(n != 1)"));
        info.put("bs", new PluralInfo(3, "(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2) "));
        info.put("ca", new PluralInfo(2, "(n != 1)"));
        info.put("cgg", new PluralInfo(1, "0"));
        info.put("cs", new PluralInfo(3, "(n==1) ? 0 : (n>=2 && n<=4) ? 1 : 2"));
        info.put("csb", new PluralInfo(3, "n==1 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2"));
        info.put("cy", new PluralInfo(4, " (n==1) ? 0 : (n==2) ? 1 : (n != 8 && n != 11) ? 2 : 3"));
        info.put("da", new PluralInfo(2, "(n != 1)"));
        info.put("de", new PluralInfo(2, "(n != 1)"));
        info.put("doi", new PluralInfo(2, "(n != 1)"));
        info.put("dz", new PluralInfo(1, "0"));
        info.put("el", new PluralInfo(2, "(n != 1)"));
        info.put("en", new PluralInfo(2, "(n != 1)"));
        info.put("eo", new PluralInfo(2, "(n != 1)"));
        info.put("es", new PluralInfo(2, "(n != 1)"));
        info.put("et", new PluralInfo(2, "(n != 1)"));
        info.put("eu", new PluralInfo(2, "(n != 1)"));
        info.put("fa", new PluralInfo(1, "0"));
        info.put("ff", new PluralInfo(2, "(n != 1)"));
        info.put("fi", new PluralInfo(2, "(n != 1)"));
        info.put("fil", new PluralInfo(2, "n > 1"));
        info.put("fo", new PluralInfo(2, "(n != 1)"));
        info.put("fr", new PluralInfo(2, "(n > 1)"));
        info.put("fur", new PluralInfo(2, "(n != 1)"));
        info.put("fy", new PluralInfo(2, "(n != 1)"));
        info.put("ga", new PluralInfo(5, "n==1 ? 0 : n==2 ? 1 : n<7 ? 2 : n<11 ? 3 : 4"));
        info.put("gd", new PluralInfo(4, "(n==1 || n==11) ? 0 : (n==2 || n==12) ? 1 : (n > 2 && n < 20) ? 2 : 3"));
        info.put("gl", new PluralInfo(2, "(n != 1)"));
        info.put("gu", new PluralInfo(2, "(n != 1)"));
        info.put("gun", new PluralInfo(2, "(n > 1)"));
        info.put("ha", new PluralInfo(2, "(n != 1)"));
        info.put("he", new PluralInfo(2, "(n != 1)"));
        info.put("hi", new PluralInfo(2, "(n != 1)"));
        info.put("hne", new PluralInfo(2, "(n != 1)"));
        info.put("hy", new PluralInfo(2, "(n != 1)"));
        info.put("hr", new PluralInfo(3, "(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2)"));
        info.put("hu", new PluralInfo(2, "(n != 1)"));
        info.put("ia", new PluralInfo(2, "(n != 1)"));
        info.put("id", new PluralInfo(1, "0"));
        info.put("is", new PluralInfo(2, "(n%10!=1 || n%100==11)"));
        info.put("it", new PluralInfo(2, "(n != 1)"));
        info.put("ja", new PluralInfo(1, "0"));
        info.put("jbo", new PluralInfo(1, "0"));
        info.put("jv", new PluralInfo(2, "n!=0"));
        info.put("ka", new PluralInfo(1, "0"));
        info.put("kk", new PluralInfo(1, "0"));
        info.put("km", new PluralInfo(1, "0"));
        info.put("kn", new PluralInfo(2, "(n!=1)"));
        info.put("ko", new PluralInfo(1, "0"));
        info.put("ku", new PluralInfo(2, "(n!= 1)"));
        info.put("kw", new PluralInfo(4, " (n==1) ? 0 : (n==2) ? 1 : (n == 3) ? 2 : 3"));
        info.put("ky", new PluralInfo(1, "0"));
        info.put("lb", new PluralInfo(2, "(n != 1)"));
        info.put("ln", new PluralInfo(2, "n>1"));
        info.put("lo", new PluralInfo(1, "0"));
        info.put("lt", new PluralInfo(3, "(n%10==1 && n%100!=11 ? 0 : n%10>=2 && (n%100<10 or n%100>=20) ? 1 : 2)"));
        info.put("lv", new PluralInfo(3, "(n%10==1 && n%100!=11 ? 0 : n != 0 ? 1 : 2)"));
        info.put("mai", new PluralInfo(2, "(n != 1)"));
        info.put("mfe", new PluralInfo(2, "(n > 1)"));
        info.put("mg", new PluralInfo(2, "(n > 1)"));
        info.put("mi", new PluralInfo(2, "(n > 1)"));
        info.put("mk", new PluralInfo(2, " n==1 || n%10==1 ? 0 : 1"));
        info.put("ml", new PluralInfo(2, "(n != 1)"));
        info.put("mn", new PluralInfo(2, "(n != 1)"));
        info.put("mni", new PluralInfo(2, "(n != 1)"));
        info.put("mnk", new PluralInfo(3, "(n==0 ? 0 : n==1 ? 1 : 2"));
        info.put("mr", new PluralInfo(2, "(n != 1)"));
        info.put("ms", new PluralInfo(1, "0"));
        info.put("mt", new PluralInfo(4, "(n==1 ? 0 : n==0 || ( n%100>1 && n%100<11) ? 1 : (n%100>10 && n%100<20 ) ? 2 : 3)"));
        info.put("my", new PluralInfo(1, "0"));
        info.put("nah", new PluralInfo(2, "(n != 1)"));
        info.put("nap", new PluralInfo(2, "(n != 1)"));
        info.put("nb", new PluralInfo(2, "(n != 1)"));
        info.put("ne", new PluralInfo(2, "(n != 1)"));
        info.put("nl", new PluralInfo(2, "(n != 1)"));
        info.put("se", new PluralInfo(2, "(n != 1)"));
        info.put("nn", new PluralInfo(2, "(n != 1)"));
        info.put("no", new PluralInfo(2, "(n != 1)"));
        info.put("nso", new PluralInfo(2, "(n != 1)"));
        info.put("oc", new PluralInfo(2, "(n > 1)"));
        info.put("or", new PluralInfo(2, "(n != 1)"));
        info.put("ps", new PluralInfo(2, "(n != 1)"));
        info.put("pa", new PluralInfo(2, "(n != 1)"));
        info.put("pap", new PluralInfo(2, "(n != 1)"));
        info.put("pl", new PluralInfo(3, "(n==1 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2)"));
        info.put("pms", new PluralInfo(2, "(n != 1)"));
        info.put("pt", new PluralInfo(2, "(n != 1)"));
        info.put("rm", new PluralInfo(2, "(n!=1)"));
        info.put("ro", new PluralInfo(3, "(n==1 ? 0 : (n==0 || (n%100 > 0 && n%100 < 20)) ? 1 : 2)"));
        info.put("ru", new PluralInfo(3, "(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2)"));
        info.put("rw", new PluralInfo(2, "(n != 1)"));
        info.put("sah", new PluralInfo(1, "0"));
        info.put("sat", new PluralInfo(2, "(n != 1)"));
        info.put("sco", new PluralInfo(2, "(n != 1)"));
        info.put("sd", new PluralInfo(2, "(n != 1)"));
        info.put("si", new PluralInfo(2, "(n != 1)"));
        info.put("sk", new PluralInfo(3, "(n==1) ? 0 : (n>=2 && n<=4) ? 1 : 2"));
        info.put("sl", new PluralInfo(4, "(n%100==1 ? 1 : n%100==2 ? 2 : n%100==3 || n%100==4 ? 3 : 0)"));
        info.put("so", new PluralInfo(2, "n != 1"));
        info.put("son", new PluralInfo(2, "(n != 1)"));
        info.put("sq", new PluralInfo(2, "(n != 1)"));
        info.put("sr", new PluralInfo(3, "(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2)"));
        info.put("su", new PluralInfo(1, "0"));
        info.put("sw", new PluralInfo(2, "(n != 1)"));
        info.put("sv", new PluralInfo(2, "(n != 1)"));
        info.put("ta", new PluralInfo(2, "(n != 1)"));
        info.put("te", new PluralInfo(2, "(n != 1)"));
        info.put("tg", new PluralInfo(2, "(n > 1)"));
        info.put("ti", new PluralInfo(2, "n > 1"));
        info.put("th", new PluralInfo(1, "0"));
        info.put("tk", new PluralInfo(2, "(n != 1)"));
        info.put("tr", new PluralInfo(2, "(n>1)"));
        info.put("tt", new PluralInfo(1, "0"));
        info.put("ug", new PluralInfo(1, "0"));
        info.put("uk", new PluralInfo(3, "(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2)"));
        info.put("ur", new PluralInfo(2, "(n != 1)"));
        info.put("uz", new PluralInfo(2, "(n > 1)"));
        info.put("vi", new PluralInfo(1, "0"));
        info.put("wa", new PluralInfo(2, "(n > 1)"));
        info.put("wo", new PluralInfo(1, "0"));
        info.put("yo", new PluralInfo(2, "(n != 1)"));
        info.put("zh", new PluralInfo(1, "0 "));
        PLURAL_INFOS = Collections.unmodifiableMap(info);
        COMMENT_FUZZY = Pattern.compile("#, fuzzy");
        COMMENT_FUZZY_OTHER = Pattern.compile("#,.* fuzzy.*");
        COMMENT_FUZZY_MSGID = Pattern.compile("#\\|.* msgid.*\"(.*)\"");
        COMMENT_FUZZY_MSGCTX = Pattern.compile("#\\|.* msgctxt\\s+\"(.*)\"");
        COMMENT_NOWRAP = Pattern.compile("#,.* no-wrap.*");
        COMMENT_TRANSLATOR = Pattern.compile("# (.*)");
        COMMENT_EXTRACTED = Pattern.compile("#\\. (.*)");
        COMMENT_REFERENCE = Pattern.compile("#: (.*)");
        MSG_ID = Pattern.compile("msgid(_plural)?\\s+\"(.*)\"");
        MSG_STR = Pattern.compile("msgstr(\\[([0-9]+)\\])?\\s+\"(.*)\"");
        MSG_CTX = Pattern.compile("msgctxt\\s+\"(.*)\"");
        MSG_OTHER = Pattern.compile("\"(.*)\"");
        PLURAL_FORMS = Pattern.compile("Plural-Forms: *nplurals= *([0-9]+) *; *plural", 2);
        MSG_FUZZY = Pattern.compile("#\\|\\s\"(.*)\"");
        R1 = Pattern.compile("(?<!\\\\)((\\\\\\\\)*)\\\\\"");
        R2 = Pattern.compile("(?<!\\\\)((\\\\\\\\)*)\\\\n");
        R3 = Pattern.compile("(?<!\\\\)((\\\\\\\\)*)\\\\t");
        R4 = Pattern.compile("^\\\\n");
    }

    static enum MODE {
        MSGID,
        MSGSTR,
        MSGID_PLURAL,
        MSGSTR_PLURAL,
        MSGCTX;

    }

    private static class PluralInfo {
        public int plurals;
        public String expression;

        PluralInfo(int nrOfPlurals, String pluralExpression) {
            this.plurals = nrOfPlurals;
            this.expression = pluralExpression;
        }
    }
}

