/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.scripting;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ui.CollapsibleSectionPanel;
import org.fife.rsta.ui.GoToDialog;
import org.fife.rsta.ui.search.FindDialog;
import org.fife.rsta.ui.search.FindToolBar;
import org.fife.rsta.ui.search.ReplaceDialog;
import org.fife.rsta.ui.search.ReplaceToolBar;
import org.fife.rsta.ui.search.SearchEvent;
import org.fife.rsta.ui.search.SearchListener;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import org.omegat.gui.scripting.AbstractScriptEditor;
import org.omegat.gui.scripting.ScriptingWindow;
import org.omegat.util.Java8Compat;
import org.omegat.util.OStrings;
import org.openide.awt.Mnemonics;

public class RichScriptEditor
extends AbstractScriptEditor
implements SearchListener {
    private RSyntaxTextArea m_scriptEditor;
    private CollapsibleSectionPanel m_csp;
    private FindDialog m_findDialog;
    private ReplaceDialog m_replaceDialog;
    private FindToolBar m_findToolBar;
    private ReplaceToolBar m_replaceToolBar;
    private ScriptingWindow m_scriptingWindow;

    @Override
    public JTextArea getTextArea() {
        return this.m_scriptEditor;
    }

    @Override
    public void setHighlighting(String extension) {
        switch (extension) {
            case "groovy": {
                this.m_scriptEditor.setSyntaxEditingStyle("text/groovy");
                break;
            }
            case "js": {
                this.m_scriptEditor.setSyntaxEditingStyle("text/javascript");
                break;
            }
            case "py": {
                this.m_scriptEditor.setSyntaxEditingStyle("text/python");
                break;
            }
            default: {
                this.m_scriptEditor.setSyntaxEditingStyle("text/plain");
            }
        }
    }

    public void initSearchDialogs() {
        this.m_findDialog = new FindDialog((Frame)this.m_scriptingWindow.frame, (SearchListener)this);
        this.m_replaceDialog = new ReplaceDialog((Frame)this.m_scriptingWindow.frame, (SearchListener)this);
        SearchContext context = this.m_findDialog.getSearchContext();
        this.m_replaceDialog.setSearchContext(context);
        this.m_findToolBar = new FindToolBar((SearchListener)this);
        this.m_findToolBar.setSearchContext(context);
        this.m_replaceToolBar = new ReplaceToolBar((SearchListener)this);
        this.m_replaceToolBar.setSearchContext(context);
    }

    public void searchEvent(SearchEvent e) {
        SearchEvent.Type type = e.getType();
        SearchContext context = e.getSearchContext();
        SearchResult result = null;
        switch (type) {
            default: {
                result = SearchEngine.markAll((RTextArea)this.m_scriptEditor, (SearchContext)context);
                break;
            }
            case FIND: {
                result = SearchEngine.find((JTextArea)this.m_scriptEditor, (SearchContext)context);
                if (result.wasFound()) break;
                UIManager.getLookAndFeel().provideErrorFeedback((Component)this.m_scriptEditor);
                break;
            }
            case REPLACE: {
                result = SearchEngine.replace((RTextArea)this.m_scriptEditor, (SearchContext)context);
                if (result.wasFound()) break;
                UIManager.getLookAndFeel().provideErrorFeedback((Component)this.m_scriptEditor);
                break;
            }
            case REPLACE_ALL: {
                result = SearchEngine.replaceAll((RTextArea)this.m_scriptEditor, (SearchContext)context);
                JOptionPane.showMessageDialog(null, result.getCount() + " occurrences replaced.");
            }
        }
    }

    @Override
    public void enhanceMenu(JMenuBar mb) {
        JMenu menu = new JMenu();
        Mnemonics.setLocalizedText((AbstractButton)menu, (String)OStrings.getString("SCW_MENU_EDIT"));
        JMenuItem item = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)item, (String)OStrings.getString("SCW_MENU_FIND"));
        item.setAccelerator(KeyStroke.getKeyStroke(70, Java8Compat.getMenuShortcutKeyMaskEx()));
        item.addActionListener(new ShowFindDialogAction());
        menu.add(item);
        item = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)item, (String)OStrings.getString("SCW_MENU_REPLACE"));
        item.setAccelerator(KeyStroke.getKeyStroke(71, Java8Compat.getMenuShortcutKeyMaskEx()));
        item.addActionListener(new ShowReplaceDialogAction());
        menu.add(item);
        item = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)item, (String)OStrings.getString("SCW_MENU_GOTO_LINE"));
        item.setAccelerator(KeyStroke.getKeyStroke(76, Java8Compat.getMenuShortcutKeyMaskEx()));
        item.addActionListener(new GoToLineAction());
        menu.add(item);
        menu.addSeparator();
        int metaShiftMask = Java8Compat.getMenuShortcutKeyMaskEx() | 0x40;
        KeyStroke ks = KeyStroke.getKeyStroke(70, metaShiftMask);
        Action a = this.m_csp.addBottomComponent(ks, (JComponent)this.m_findToolBar);
        a.putValue("Name", OStrings.getString("SCW_MENU_SHOW_FIND_BAR"));
        menu.add(new JMenuItem(a));
        ks = KeyStroke.getKeyStroke(71, metaShiftMask);
        a = this.m_csp.addBottomComponent(ks, (JComponent)this.m_replaceToolBar);
        a.putValue("Name", OStrings.getString("SCW_MENU_SHOW_REPLACE_BAR"));
        menu.add(new JMenuItem(a));
        mb.add(menu);
    }

    @Override
    public void initLayout(ScriptingWindow scriptingWindow) {
        this.m_scriptingWindow = scriptingWindow;
        this.m_scriptEditor = new RSyntaxTextArea();
        this.m_scriptEditor.setFont(new Font("Monospaced", 0, this.m_scriptEditor.getFont().getSize()));
        DefaultCompletionProvider provider = new DefaultCompletionProvider();
        AutoCompletion ac = new AutoCompletion((CompletionProvider)provider);
        ac.install((JTextComponent)this.m_scriptEditor);
        this.m_scriptEditor.setSyntaxEditingStyle("text/groovy");
        this.m_scriptEditor.setCodeFoldingEnabled(true);
        RTextScrollPane scrollPaneEditor = new RTextScrollPane((RTextArea)this.m_scriptEditor);
        this.m_csp = new CollapsibleSectionPanel();
        this.m_scriptingWindow.frame.getContentPane().add((Component)this.m_csp);
        this.m_csp.add((Component)scrollPaneEditor);
        this.initSearchDialogs();
    }

    @Override
    public Component getPanel() {
        return this.m_csp;
    }

    private class ShowFindDialogAction
    implements ActionListener {
        private ShowFindDialogAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RichScriptEditor.this.m_replaceDialog.isVisible()) {
                RichScriptEditor.this.m_replaceDialog.setVisible(false);
            }
            RichScriptEditor.this.m_findDialog.setVisible(true);
        }
    }

    private class GoToLineAction
    implements ActionListener {
        private GoToLineAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RichScriptEditor.this.m_findDialog.isVisible()) {
                RichScriptEditor.this.m_findDialog.setVisible(false);
            }
            if (RichScriptEditor.this.m_replaceDialog.isVisible()) {
                RichScriptEditor.this.m_replaceDialog.setVisible(false);
            }
            GoToDialog dialog = new GoToDialog((Frame)((RichScriptEditor)RichScriptEditor.this).m_scriptingWindow.frame);
            dialog.setMaxLineNumberAllowed(RichScriptEditor.this.m_scriptEditor.getLineCount());
            dialog.setVisible(true);
            int line = dialog.getLineNumber();
            if (line > 0) {
                try {
                    RichScriptEditor.this.m_scriptEditor.setCaretPosition(RichScriptEditor.this.m_scriptEditor.getLineStartOffset(line - 1));
                }
                catch (BadLocationException ble) {
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)RichScriptEditor.this.m_scriptEditor);
                    ble.printStackTrace();
                }
            }
        }
    }

    private class ShowReplaceDialogAction
    implements ActionListener {
        private ShowReplaceDialogAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RichScriptEditor.this.m_findDialog.isVisible()) {
                RichScriptEditor.this.m_findDialog.setVisible(false);
            }
            RichScriptEditor.this.m_replaceDialog.setVisible(true);
        }
    }
}

