/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.segmentation;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import org.omegat.core.Core;
import org.omegat.core.segmentation.MapRule;
import org.omegat.core.segmentation.SRX;
import org.omegat.core.segmentation.Segmenter;
import org.omegat.core.segmentation.datamodels.MappingRulesModel;
import org.omegat.core.segmentation.datamodels.SegmentationRulesModel;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.segmentation.SegmentationCustomizerPanel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;

public class SegmentationCustomizerController
extends BasePreferencesController {
    private static final int MAX_ROW_COUNT = 10;
    private SegmentationCustomizerPanel panel;
    private final SRX defaultSRX;
    private final SRX userSRX;
    private final SRX projectSRX;
    private SRX editableSRX;
    private boolean isProjectSpecific;

    public SegmentationCustomizerController() {
        this(false, SRX.getDefault(), Preferences.getSRX(), null);
    }

    public SegmentationCustomizerController(boolean projectSpecific, SRX defaultSRX, SRX userSRX, SRX projectSRX) {
        this.isProjectSpecific = projectSpecific;
        this.defaultSRX = defaultSRX;
        this.userSRX = userSRX;
        this.projectSRX = projectSRX;
    }

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return this.isProjectSpecific ? OStrings.getString("GUI_SEGMENTATION_TITLE_PROJECTSPECIFIC") : OStrings.getString("GUI_SEGMENTATION_TITLE");
    }

    private void initGui() {
        this.panel = new SegmentationCustomizerPanel();
        this.panel.mapTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.panel.mapErrorsLabel.setText("");
            if (this.panel.mapTable.getSelectionModel().isSelectionEmpty()) {
                this.panel.mapDeleteButton.setEnabled(false);
                this.panel.mapUpButton.setEnabled(false);
                this.panel.mapDownButton.setEnabled(false);
                this.panel.ruleTable.setModel(new DefaultTableModel());
                this.panel.ruleInsertButton.setEnabled(false);
            } else {
                this.panel.mapDeleteButton.setEnabled(true);
                int selrow = this.panel.mapTable.getSelectedRow();
                int rows = this.panel.mapTable.getRowCount();
                if (selrow > 0) {
                    this.panel.mapUpButton.setEnabled(true);
                } else {
                    this.panel.mapUpButton.setEnabled(false);
                }
                if (selrow < rows - 1) {
                    this.panel.mapDownButton.setEnabled(true);
                } else {
                    this.panel.mapDownButton.setEnabled(false);
                }
                MapRule maprule = this.editableSRX.getMappingRules().get(selrow);
                SegmentationRulesModel model = new SegmentationRulesModel(maprule.getRules());
                this.panel.ruleTable.setModel(model);
                model.addExceptionListener(ex -> this.panel.ruleErrorsLabel.setText(ex.getLocalizedMessage()));
                this.panel.ruleInsertButton.setEnabled(true);
            }
        });
        this.panel.ruleTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.panel.ruleErrorsLabel.setText("");
            if (this.panel.ruleTable.getSelectionModel().isSelectionEmpty()) {
                this.panel.ruleDeleteButton.setEnabled(false);
                this.panel.ruleUpButton.setEnabled(false);
                this.panel.ruleDownButton.setEnabled(false);
                this.panel.ruleFirstButton.setEnabled(false);
                this.panel.ruleBottomButton.setEnabled(false);
            } else {
                this.panel.ruleDeleteButton.setEnabled(true);
                int rules = this.panel.ruleTable.getRowCount();
                int rulerow = this.panel.ruleTable.getSelectedRow();
                if (rulerow > 0) {
                    this.panel.ruleUpButton.setEnabled(true);
                    this.panel.ruleFirstButton.setEnabled(true);
                } else {
                    this.panel.ruleUpButton.setEnabled(false);
                    this.panel.ruleFirstButton.setEnabled(false);
                }
                if (rulerow < rules - 1) {
                    this.panel.ruleDownButton.setEnabled(true);
                    this.panel.ruleBottomButton.setEnabled(true);
                } else {
                    this.panel.ruleDownButton.setEnabled(false);
                    this.panel.ruleBottomButton.setEnabled(false);
                }
            }
        });
        this.panel.projectSpecificCB.addActionListener(e -> {
            this.panel.ruleTable.clearSelection();
            this.panel.mapTable.clearSelection();
            this.updateEnabledness();
        });
        this.panel.ruleDownButton.addActionListener(e -> {
            this.commitTableEdits();
            SegmentationRulesModel model = (SegmentationRulesModel)this.panel.ruleTable.getModel();
            int selrow = this.panel.ruleTable.getSelectedRow();
            model.moveRowDown(selrow);
            this.panel.ruleTable.getSelectionModel().clearSelection();
            this.panel.ruleTable.getSelectionModel().addSelectionInterval(selrow + 1, selrow + 1);
        });
        this.panel.ruleUpButton.addActionListener(e -> {
            this.commitTableEdits();
            SegmentationRulesModel model = (SegmentationRulesModel)this.panel.ruleTable.getModel();
            int selrow = this.panel.ruleTable.getSelectedRow();
            model.moveRowUp(selrow);
            this.panel.ruleTable.getSelectionModel().clearSelection();
            this.panel.ruleTable.getSelectionModel().addSelectionInterval(selrow - 1, selrow - 1);
        });
        this.panel.ruleBottomButton.addActionListener(e -> {
            this.commitTableEdits();
            SegmentationRulesModel model = (SegmentationRulesModel)this.panel.ruleTable.getModel();
            int selrow = this.panel.ruleTable.getSelectedRow();
            model.moveRowToBottom(selrow);
            int rows = this.panel.ruleTable.getRowCount() - 1;
            this.panel.ruleTable.changeSelection(rows, 0, false, false);
            this.panel.ruleTable.changeSelection(rows, this.panel.ruleTable.getColumnCount() - 1, false, true);
        });
        this.panel.ruleFirstButton.addActionListener(e -> {
            this.commitTableEdits();
            SegmentationRulesModel model = (SegmentationRulesModel)this.panel.ruleTable.getModel();
            int selrow = this.panel.ruleTable.getSelectedRow();
            model.moveRowFirst(selrow);
            this.panel.ruleTable.changeSelection(0, 0, false, false);
            this.panel.ruleTable.changeSelection(0, this.panel.ruleTable.getColumnCount() - 1, false, true);
        });
        this.panel.ruleDeleteButton.addActionListener(e -> {
            this.commitTableEdits();
            SegmentationRulesModel model = (SegmentationRulesModel)this.panel.ruleTable.getModel();
            model.removeRow(this.panel.ruleTable.getSelectedRow());
        });
        this.panel.mapDownButton.addActionListener(e -> {
            this.commitTableEdits();
            MappingRulesModel model = (MappingRulesModel)this.panel.mapTable.getModel();
            int selrow = this.panel.mapTable.getSelectedRow();
            model.moveRowDown(selrow);
            this.panel.mapTable.getSelectionModel().clearSelection();
            this.panel.mapTable.getSelectionModel().addSelectionInterval(selrow + 1, selrow + 1);
        });
        this.panel.mapUpButton.addActionListener(e -> {
            this.commitTableEdits();
            MappingRulesModel model = (MappingRulesModel)this.panel.mapTable.getModel();
            int selrow = this.panel.mapTable.getSelectedRow();
            model.moveRowUp(selrow);
            this.panel.mapTable.getSelectionModel().clearSelection();
            this.panel.mapTable.getSelectionModel().addSelectionInterval(selrow - 1, selrow - 1);
        });
        this.panel.mapDeleteButton.addActionListener(e -> {
            this.commitTableEdits();
            MappingRulesModel model = (MappingRulesModel)this.panel.mapTable.getModel();
            String set = model.getValueAt(this.panel.mapTable.getSelectedRow(), 0).toString();
            String title = OStrings.getString("CONFIRM_DIALOG_TITLE");
            String message = StringUtil.format(OStrings.getString("SEG_CONFIRM_REMOVE_SENTSEG_SET"), set);
            if (JOptionPane.showConfirmDialog(this.panel, message, title, 0) == 0) {
                model.removeRow(this.panel.mapTable.getSelectedRow());
            }
        });
        this.panel.ruleInsertButton.addActionListener(e -> {
            this.commitTableEdits();
            SegmentationRulesModel model = (SegmentationRulesModel)this.panel.ruleTable.getModel();
            model.addRow();
            this.panel.ruleTable.changeSelection(this.panel.ruleTable.getRowCount() - 1, 0, false, false);
            this.panel.ruleTable.changeSelection(this.panel.ruleTable.getRowCount() - 1, this.panel.ruleTable.getColumnCount() - 1, false, true);
        });
        this.panel.mapInsertButton.addActionListener(e -> {
            this.commitTableEdits();
            MappingRulesModel model = (MappingRulesModel)this.panel.mapTable.getModel();
            model.addRow();
            this.panel.mapTable.changeSelection(this.panel.mapTable.getRowCount() - 1, 0, false, false);
            this.panel.mapTable.changeSelection(this.panel.mapTable.getRowCount() - 1, this.panel.mapTable.getColumnCount() - 1, false, true);
        });
        Dimension mapTableSize = this.panel.mapTable.getPreferredSize();
        this.panel.mapTable.setPreferredScrollableViewportSize(new Dimension(mapTableSize.width, this.panel.mapTable.getRowHeight() * 10));
        Dimension ruleTableSize = this.panel.ruleTable.getPreferredSize();
        this.panel.ruleTable.setPreferredScrollableViewportSize(new Dimension(ruleTableSize.width, this.panel.ruleTable.getRowHeight() * 10));
    }

    private void commitTableEdits() {
        if (this.panel.mapTable.getCellEditor() != null) {
            this.panel.mapTable.getCellEditor().stopCellEditing();
        }
        if (this.panel.ruleTable.getCellEditor() != null) {
            this.panel.ruleTable.getCellEditor().stopCellEditing();
        }
    }

    @Override
    protected void initFromPrefs() {
        this.panel.projectSpecificCB.setVisible(this.isProjectSpecific);
        this.panel.projectSpecificCB.setSelected(this.projectSRX != null);
        this.setEditableSRX(this.isProjectSpecific && this.projectSRX != null ? this.projectSRX : this.userSRX);
        this.updateEnabledness();
    }

    @Override
    public void restoreDefaults() {
        if (this.isEditable()) {
            this.commitTableEdits();
            this.setEditableSRX(this.defaultSRX);
            this.updateEnabledness();
        }
    }

    private boolean isEditable() {
        return !this.isProjectSpecific || this.panel.projectSpecificCB.isSelected();
    }

    private void updateEnabledness() {
        boolean enabled = this.isEditable();
        this.panel.mapTable.setEnabled(enabled);
        this.panel.mapTable.setFocusable(enabled);
        this.panel.mapInsertButton.setEnabled(enabled);
    }

    protected void setEditableSRX(SRX srx) {
        this.editableSRX = srx.copy();
        MappingRulesModel model = new MappingRulesModel(this.editableSRX);
        this.panel.mapTable.setModel(model);
        model.addExceptionListener(ex -> this.panel.mapErrorsLabel.setText(ex.getLocalizedMessage()));
        this.panel.ruleTable.setModel(new DefaultTableModel());
    }

    @Override
    public void persist() {
        this.commitTableEdits();
        if (!this.isProjectSpecific) {
            Core.setSegmenter(new Segmenter(this.editableSRX));
            Preferences.setSRX(this.editableSRX);
        }
    }

    public SRX getResult() {
        if (this.isEditable()) {
            return this.editableSRX;
        }
        return null;
    }
}

