/*
 * Decompiled with CFR 0.152.
 */
package net.briac.omegat.plugin.omt;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.briac.omegat.plugin.omt.ChooseOmtProject;
import net.briac.omegat.plugin.omt.DirectoryFilter;
import net.briac.omegat.plugin.omt.ProjectFileStorage;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.ProjectFactory;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.segmentation.Segmenter;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.main.IMainMenu;
import org.omegat.gui.main.IMainWindow;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.scripting.IScriptLogger;
import org.omegat.gui.scripting.ScriptItem;
import org.omegat.gui.scripting.ScriptRunner;
import org.omegat.util.FileUtil;
import org.omegat.util.Log;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.UIThreadsUtil;
import org.openide.awt.Mnemonics;

public class ManageOMTPackage {
    public static final String PLUGIN_VERSION = ManageOMTPackage.class.getPackage().getImplementationVersion();
    public static final String PROPERTY_POST_PACKAGE_SCRIPT = "post-package-script";
    public static final String OMT_EXTENSION = ".omt";
    public static final String IGNORE_FILE = ".empty";
    public static final String CONFIG_FILE = "omt-package-config.properties";
    public static final String PROPERTY_EXCLUDE = "exclude-pattern";
    public static final String DEFAULT_EXCLUDE = "\\.(zip|bak|omt|lck)$;\\.repositories";
    public static final String PROPERTY_OPEN_DIR = "open-directory-after-export";
    public static final String PROPERTY_GENERATE_TARGET = "generate-target-files";
    public static final String PROPERTY_PROMPT_DELETE_IMPORT = "prompt-remove-omt-after-import";
    protected static final Logger LOGGER = Logger.getLogger(ManageOMTPackage.class.getName());
    protected static final String OMT_PACKER_LOGNAME = "omt-packer.log";
    protected static final ResourceBundle res = ResourceBundle.getBundle("omt-package", Locale.getDefault());
    private static final ReentrantLock EXCLUSIVE_RUN_LOCK = new ReentrantLock();
    private static JMenuItem importOMT;
    private static JMenuItem exportOMT;
    private static JMenuItem exportDeleteOMT;
    private static boolean cliMode;
    private static Properties pluginProps;
    private static FileWriter fhandler;
    private static StackTraceElement[] runningStackTrace;

    public static void main(String[] args) throws Exception {
        File configFile = new File(StaticUtils.getConfigDir(), CONFIG_FILE);
        String projectDirectoryName = null;
        String omtFilename = null;
        cliMode = true;
        Options options = new Options();
        options.addOption(Option.builder("c").longOpt("config").argName("property-file").hasArg().desc("use given file for configuration (default: " + configFile + ")").type(String.class).build());
        options.addOption(Option.builder("v").longOpt("verbose").desc("be extra verbose").build());
        options.addOption(Option.builder("q").longOpt("quiet").desc("be extra quiet").build());
        options.addOption(Option.builder("h").longOpt("help").desc("print this message").build());
        if (args.length == 0) {
            ManageOMTPackage.printCliHelp(options);
        }
        DefaultParser parser = new DefaultParser();
        try {
            String[] remainder;
            CommandLine commandLine = parser.parse(options, args);
            if (commandLine.hasOption("config")) {
                configFile = new File(commandLine.getOptionValue("config"));
            }
            if (commandLine.hasOption("verbose")) {
                Log.setLevel((Level)Level.FINE);
                LOGGER.setLevel(Level.FINE);
            }
            if (commandLine.hasOption("quiet")) {
                Log.setLevel((Level)Level.OFF);
            }
            if (commandLine.hasOption("help")) {
                ManageOMTPackage.printCliHelp(options);
            }
            if ((remainder = commandLine.getArgs()) == null || remainder.length == 0) {
                ManageOMTPackage.printCliHelp(options);
            }
            projectDirectoryName = remainder[0];
            if (remainder.length == 2) {
                omtFilename = remainder[1];
            }
        }
        catch (ParseException exp) {
            System.err.println("Invalid command line: " + exp.getMessage());
            System.exit(3);
        }
        File projectDir = new File(projectDirectoryName);
        if (!(projectDir.exists() && projectDir.canRead() && projectDir.isDirectory())) {
            System.err.println("The omegat-project-directory must be a valid directory");
            System.exit(4);
        }
        File omtFile = null;
        omtFile = omtFilename != null ? new File(omtFilename) : new File(projectDir.getParentFile(), projectDir.getName() + OMT_EXTENSION);
        Log.log((String)res.getString("omt.menu.export"));
        ManageOMTPackage.loadPluginProps(configFile);
        Preferences.init();
        ProjectProperties props = org.omegat.util.ProjectFileStorage.loadProjectProperties((File)projectDir);
        ManageOMTPackage.createOmt(omtFile, props);
    }

    private static void printCliHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(150);
        formatter.printHelp("ManageOMTPackage [options] omegat-project-directory [omt-package-file]", options, false);
        System.exit(2);
    }

    public static void loadPlugins() {
        CoreEvents.registerProjectChangeListener(e -> ManageOMTPackage.onProjectStatusChanged(Core.getProject().isProjectLoaded()));
        CoreEvents.registerApplicationEventListener((IApplicationEventListener)new IApplicationEventListener(){

            public void onApplicationStartup() {
                IMainMenu menu = Core.getMainWindow().getMainMenu();
                JMenu projectMenu = menu.getProjectMenu();
                int startMenuIndex = projectMenu.getItemCount() - 6;
                importOMT = new JMenuItem();
                Mnemonics.setLocalizedText((AbstractButton)importOMT, (String)res.getString("omt.menu.import"));
                importOMT.addActionListener(e -> ManageOMTPackage.projectImportOMT());
                projectMenu.add((Component)new JPopupMenu.Separator(), startMenuIndex++);
                projectMenu.add((Component)importOMT, startMenuIndex++);
                exportOMT = new JMenuItem();
                Mnemonics.setLocalizedText((AbstractButton)exportOMT, (String)res.getString("omt.menu.export"));
                exportOMT.addActionListener(e -> ManageOMTPackage.projectExportOMT());
                projectMenu.add((Component)exportOMT, startMenuIndex++);
                exportDeleteOMT = new JMenuItem();
                Mnemonics.setLocalizedText((AbstractButton)exportDeleteOMT, (String)res.getString("omt.menu.export.delete"));
                exportDeleteOMT.addActionListener(e -> ManageOMTPackage.projectExportOMT(true));
                projectMenu.add((Component)exportDeleteOMT, startMenuIndex);
                ManageOMTPackage.onProjectStatusChanged(false);
            }

            public void onApplicationShutdown() {
            }
        });
    }

    public static void unloadPlugins() {
    }

    private static void onProjectStatusChanged(boolean isProjectLoaded) {
        if (exportOMT != null) {
            exportOMT.setEnabled(isProjectLoaded);
        }
        if (exportDeleteOMT != null) {
            exportDeleteOMT.setEnabled(isProjectLoaded);
        }
        if (importOMT != null) {
            importOMT.setEnabled(!isProjectLoaded);
        }
    }

    public static void projectImportOMT() {
        UIThreadsUtil.mustBeSwingThread();
        ManageOMTPackage.loadPluginProps();
        if (Core.getProject().isProjectLoaded()) {
            return;
        }
        ChooseOmtProject ndm = new ChooseOmtProject(res.getString("omt.chooser.import"));
        int ndmResult = ndm.showOpenDialog(Core.getMainWindow().getApplicationFrame());
        if (ndmResult != 0) {
            return;
        }
        final File omtFile = ndm.getSelectedFile();
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = Cursor.getPredefinedCursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                ManageOMTPackage.showStatusMessage(res.getString("omt.status.importing_omt"));
                File projectDir = ManageOMTPackage.extractFromOmt(omtFile);
                ProjectUICommands.projectOpen((File)projectDir);
                ManageOMTPackage.showStatusMessage(res.getString("omt.status.omt_imported"));
                mainWindow.setCursor(oldCursor);
                return null;
            }

            @Override
            protected void done() {
                try {
                    if (Boolean.parseBoolean(pluginProps.getProperty(ManageOMTPackage.PROPERTY_PROMPT_DELETE_IMPORT, "false"))) {
                        int deletePackage = JOptionPane.showConfirmDialog(Core.getMainWindow().getApplicationFrame(), res.getString("omt.dialog.delete_package"), res.getString("omt.dialog.delete_package.title"), 0, 3);
                        if (deletePackage == 0) {
                            Log.log((String)"Deleting imported package");
                            if (!omtFile.delete()) {
                                Log.log((String)String.format("Could not delete the file %s", omtFile.getAbsolutePath()));
                            }
                        } else {
                            Log.log((String)"Keeping imported package");
                        }
                    }
                    this.get();
                    SwingUtilities.invokeLater(() -> ((IEditor)Core.getEditor()).requestFocus());
                }
                catch (Exception ex) {
                    Log.logErrorRB((Throwable)ex, (String)"PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", (Object[])new Object[0]);
                    Core.getMainWindow().displayErrorRB((Throwable)ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
            }
        }.execute();
    }

    public static void projectExportOMT() {
        ManageOMTPackage.projectExportOMT(false);
    }

    public static void projectExportOMT(final boolean deleteProject) {
        UIThreadsUtil.mustBeSwingThread();
        ManageOMTPackage.loadPluginProps();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().commitAndLeave();
        ChooseOmtProject ndm = new ChooseOmtProject(res.getString("omt.chooser.export"));
        String zipName = Core.getProject().getProjectProperties().getProjectName() + OMT_EXTENSION;
        File defaultLocation = Core.getProject().getProjectProperties().getProjectRootDir();
        if (deleteProject) {
            defaultLocation = defaultLocation.getParentFile();
        }
        ndm.setSelectedFile(new File(defaultLocation, zipName));
        int ndmResult = ndm.showSaveDialog(Core.getMainWindow().getApplicationFrame());
        if (ndmResult != 0) {
            return;
        }
        final File omtFile = ndm.getSelectedFile().getName().toLowerCase(Locale.ENGLISH).endsWith(OMT_EXTENSION) ? ndm.getSelectedFile() : new File(ndm.getSelectedFile().getAbsolutePath() + OMT_EXTENSION);
        Log.log((String)String.format("Exporting OMT \"%s\"", omtFile.getAbsolutePath()));
        if (omtFile.exists()) {
            int overwritePackage = JOptionPane.showConfirmDialog(Core.getMainWindow().getApplicationFrame(), res.getString("omt.dialog.overwrite_package"), res.getString("omt.dialog.overwrite_package.title"), 0, 3);
            if (overwritePackage == 0) {
                Log.log((String)"Overwriting existing package");
            } else {
                Log.log((String)"Not overwriting existing package");
                return;
            }
        }
        final File projectDir = Core.getProject().getProjectProperties().getProjectRootDir();
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = Cursor.getPredefinedCursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                mainWindow.showStatusMessageRB("MW_STATUS_SAVING", new Object[0]);
                ManageOMTPackage.executeExclusively(true, () -> Core.getProject().saveProject(true));
                if (Boolean.parseBoolean(pluginProps.getProperty(ManageOMTPackage.PROPERTY_GENERATE_TARGET, "false"))) {
                    ManageOMTPackage.executeExclusively(true, () -> {
                        try {
                            Core.getProject().compileProject(".*");
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                        finally {
                            mainWindow.setCursor(oldCursor);
                        }
                    });
                }
                ManageOMTPackage.showStatusMessage(res.getString("omt.status.exporting_omt"));
                ManageOMTPackage.createOmt(omtFile, Core.getProject().getProjectProperties());
                if (deleteProject) {
                    ManageOMTPackage.executeExclusively(true, () -> {
                        ProjectFactory.closeProject();
                        Core.setFilterMaster((FilterMaster)new FilterMaster(Preferences.getFilters()));
                        Core.setSegmenter((Segmenter)new Segmenter(Preferences.getSRX()));
                    });
                }
                if (Boolean.parseBoolean(pluginProps.getProperty(ManageOMTPackage.PROPERTY_OPEN_DIR, "false"))) {
                    Desktop.getDesktop().open(omtFile.getParentFile());
                }
                ManageOMTPackage.showStatusMessage(res.getString("omt.status.omt_exported"));
                mainWindow.setCursor(oldCursor);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    if (deleteProject) {
                        ManageOMTPackage.showStatusMessage(res.getString("omt.status.delete_project"));
                        Log.log((String)"Deleting project directory...");
                        Path pathToBeDeleted = projectDir.toPath();
                        Files.walk(pathToBeDeleted, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                        if (Files.exists(pathToBeDeleted, new LinkOption[0])) {
                            Log.log((String)"Couldn't delete project directory...");
                        }
                    }
                    SwingUtilities.invokeLater(() -> ((IEditor)Core.getEditor()).requestFocus());
                }
                catch (Exception ex) {
                    Log.logErrorRB((Throwable)ex, (String)"PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", (Object[])new Object[0]);
                    Core.getMainWindow().displayErrorRB((Throwable)ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
            }
        }.execute();
    }

    private static void loadPluginProps() {
        ManageOMTPackage.loadPluginProps(new File(StaticUtils.getConfigDir(), CONFIG_FILE));
    }

    private static void loadPluginProps(File propFile) {
        Throwable throwable;
        FileInputStream inStream;
        pluginProps = new Properties();
        if (!propFile.exists()) {
            Log.logDebug((Logger)LOGGER, (String)"No app plugin properties [{0}], creating one...", (Object[])new Object[]{propFile.getAbsolutePath()});
            try {
                FileUtils.copyInputStreamToFile((InputStream)ManageOMTPackage.class.getResourceAsStream("/omt-package-config.properties"), (File)propFile);
            }
            catch (IOException e) {
                Log.log((Throwable)e);
                return;
            }
        }
        try {
            inStream = new FileInputStream(propFile);
            throwable = null;
            try {
                pluginProps.load(inStream);
                Log.logDebug((Logger)LOGGER, (String)"OMT App Plugin Properties", (Object[])new Object[0]);
                if (LOGGER.isLoggable(Level.FINE)) {
                    pluginProps.list(System.out);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inStream != null) {
                    if (throwable != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        inStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            Log.log((String)String.format("Could not load plugin property file \"%s\"", propFile.getAbsolutePath()));
        }
        if (Core.getProject() == null || !Core.getProject().isProjectLoaded()) {
            return;
        }
        propFile = new File(Core.getProject().getProjectProperties().getProjectRootDir(), CONFIG_FILE);
        if (propFile.exists()) {
            try {
                inStream = new FileInputStream(propFile);
                throwable = null;
                try {
                    pluginProps.load(inStream);
                    Log.logDebug((Logger)LOGGER, (String)"OMT Project Plugin Properties", (Object[])new Object[0]);
                    pluginProps.list(System.out);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (inStream != null) {
                        if (throwable != null) {
                            try {
                                inStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            inStream.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                Log.log((String)String.format("Could not load project plugin property file \"%s\"", propFile.getAbsolutePath()));
            }
        } else {
            Log.logDebug((Logger)LOGGER, (String)"No project plugin properties [{0}]", (Object[])new Object[]{propFile.getAbsolutePath()});
        }
    }

    public static File extractFromOmt(File omtFile) throws IOException {
        String omtName = omtFile.getName().replaceAll("\\.omt$", "");
        File projectDir = new File(omtFile.getParent(), "omegat.project");
        try (ZipFile zip = new ZipFile(omtFile);){
            ZipEntry e = zip.getEntry("omegat.project");
            if (e == null) {
                throw new IOException(res.getString("omt.invalid.package"));
            }
            Log.log((String)String.format("Checking for project file \"%s\": %s", projectDir.getAbsolutePath(), projectDir.exists()));
            if (projectDir.exists()) {
                Log.log((String)res.getString("omt.update.package"));
                projectDir = omtFile.getParentFile();
            } else {
                Log.log((String)res.getString("omt.new.package"));
                projectDir = new File(omtFile.getParentFile(), omtName);
                projectDir.mkdirs();
            }
            Enumeration<? extends ZipEntry> en = zip.entries();
            while (en.hasMoreElements()) {
                e = en.nextElement();
                File outFile = new File(projectDir, e.getName());
                if (outFile.getName().equals("project_save.tmx") && outFile.getParentFile().getName().equals("omegat") && outFile.exists()) {
                    int overwriteSave = JOptionPane.showConfirmDialog(Core.getMainWindow().getApplicationFrame(), res.getString("omt.dialog.overwrite_project_save"), res.getString("omt.dialog.overwrite_project_save.title"), 0, 3);
                    if (overwriteSave == 0) {
                        Log.log((String)"Overwriting project_save.tmx");
                        File f = new File(new File(projectDir, "omegat"), "project_save.tmx");
                        Log.log((String)String.format("Backuping project file \"%s\"", f.getAbsolutePath()));
                        FileUtil.backupFile((File)f);
                    } else {
                        Log.log((String)"Skipping project_save.tmx");
                        continue;
                    }
                }
                if (e.isDirectory()) {
                    outFile.mkdirs();
                    continue;
                }
                if (outFile.getName().equals(IGNORE_FILE)) {
                    outFile.getParentFile().mkdirs();
                    continue;
                }
                InputStream in = zip.getInputStream(e);
                Throwable throwable = null;
                try {
                    try {
                        FileUtils.copyInputStreamToFile((InputStream)in, (File)outFile);
                    }
                    catch (IOException ex) {
                        Log.log((String)String.format("Error unzipping file \"%s\": %s", outFile, ex.getMessage()));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        return projectDir;
    }

    public static void createOmt(File omtZip, ProjectProperties props) throws Exception {
        Path path = Paths.get(props.getProjectRootDir().getAbsolutePath(), new String[0]);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Path \"" + path + "\" must be a directory.");
        }
        List<String> listExcludes = Arrays.asList(pluginProps.getProperty(PROPERTY_EXCLUDE, DEFAULT_EXCLUDE).split(";"));
        DirectoryFilter filter = new DirectoryFilter(path, listExcludes);
        String logFile = props.getProjectInternal() + OMT_PACKER_LOGNAME;
        fhandler = new FileWriter(logFile, true);
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(omtZip));){
            String username = Preferences.getPreferenceDefault((String)"team_Author", (String)System.getProperty("user.name"));
            String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            ManageOMTPackage.omtPackLog("------------------------------------");
            ManageOMTPackage.omtPackLog(String.format("Packing timestamp: %s", timestamp));
            ManageOMTPackage.omtPackLog(String.format("OMT plugin version: %s", PLUGIN_VERSION));
            ManageOMTPackage.omtPackLog(String.format("User ID: \"%s\"", username));
            ManageOMTPackage.omtPackLog(String.format("Project name: [%s]", path));
            ManageOMTPackage.omtPackLog(String.format("Package name: [%s]", omtZip.getAbsolutePath()));
            int addedFiles = 0;
            try (ZipOutputStream out = new ZipOutputStream(bos);){
                addedFiles = ManageOMTPackage.addZipDir(out, null, path, props, filter);
                ManageOMTPackage.omtPackLog(String.format("Added %s files to the Zip.", addedFiles));
                fhandler.close();
                out.putNextEntry(new ZipEntry("omegat/omt-packer.log"));
                Files.copy(Paths.get(logFile, new String[0]), out);
                out.closeEntry();
            }
        }
        String postPackageScript = pluginProps.getProperty(PROPERTY_POST_PACKAGE_SCRIPT);
        if (postPackageScript != null) {
            ManageOMTPackage.runScript(new File(Preferences.getPreference((String)"scripts_dir"), postPackageScript));
        }
        if (cliMode) {
            Log.log((String)res.getString("omt.dialog.overwrite_package.created"));
            return;
        }
        JOptionPane.showMessageDialog(Core.getMainWindow().getApplicationFrame(), res.getString("omt.dialog.overwrite_package.created"), res.getString("omt.dialog.overwrite_package.created.title"), 1);
    }

    private static void runScript(File scriptFile) {
        if (scriptFile.isFile() && scriptFile.exists()) {
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            bindings.put("omtPackageFile", scriptFile);
            bindings.put("console", new IScriptLogger(){

                public void print(Object o) {
                    Log.log((String)o.toString());
                }

                public void println(Object o) {
                    Log.log((String)o.toString());
                }

                public void clear() {
                }
            });
            try {
                String result = ScriptRunner.executeScript((ScriptItem)new ScriptItem(scriptFile), bindings);
                Log.log((String)result);
            }
            catch (Exception ex) {
                Log.log((Throwable)ex);
            }
        } else {
            Log.log((String)String.format("No script file \"%s\".", scriptFile.getAbsolutePath()));
        }
    }

    private static final int addZipDir(ZipOutputStream out, Path root, Path dir, ProjectProperties props, DirectoryStream.Filter<Path> filter) throws IOException {
        int addedFiles = 0;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, filter);){
            for (Path child : stream) {
                Path entry;
                Path childPath = child.getFileName();
                if (Files.isDirectory(child, new LinkOption[0]) && new File(child.toFile(), "omegat.project").exists()) {
                    ManageOMTPackage.omtPackLog(String.format("The directory \"%s\" appears to be an OmegaT project, we'll skip it.", child.toFile().getAbsolutePath()));
                    continue;
                }
                if (root == null && childPath.endsWith("omegat.project")) {
                    File tmpProjectFile = File.createTempFile("omt", ".bak", props.getProjectRootDir());
                    try {
                        ProjectFileStorage.writeProjectFile(props, tmpProjectFile);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    ManageOMTPackage.omtPackLog(String.format("addZipDir\tproject\t[%s]", "omegat.project"));
                    out.putNextEntry(new ZipEntry("omegat.project"));
                    Files.copy(Paths.get(tmpProjectFile.getAbsolutePath(), new String[0]), out);
                    ++addedFiles;
                    out.closeEntry();
                    boolean isTmpDeleted = tmpProjectFile.delete();
                    if (isTmpDeleted) continue;
                    Log.log((String)String.format("Could not delete temporary file \"%s\". You can safely delete it.", tmpProjectFile.getAbsolutePath()));
                    continue;
                }
                Path path = entry = root == null ? childPath : Paths.get(root.toString(), childPath.toString());
                if (Files.isDirectory(child, new LinkOption[0])) {
                    boolean emptyDir;
                    boolean bl = emptyDir = child.toFile().listFiles().length == 0;
                    if (emptyDir) {
                        ManageOMTPackage.createEmptyFile(out, entry);
                    }
                    int added = ManageOMTPackage.addZipDir(out, entry, child, props, filter);
                    if (!emptyDir && added == 0) {
                        ManageOMTPackage.createEmptyFile(out, entry);
                    }
                    addedFiles += added;
                    continue;
                }
                ManageOMTPackage.omtPackLog(String.format("addZipDir\tfile\t[%s]", entry));
                out.putNextEntry(new ZipEntry(entry.toString().replace("\\", "/")));
                Files.copy(child, out);
                ++addedFiles;
                out.closeEntry();
            }
        }
        return addedFiles;
    }

    private static void createEmptyFile(ZipOutputStream out, Path entry) throws IOException {
        String emptyDirFile = entry.toString() + File.separatorChar + IGNORE_FILE;
        ManageOMTPackage.omtPackLog(String.format("createEmptyFile\t[%s]", emptyDirFile));
        out.putNextEntry(new ZipEntry(emptyDirFile.replace("\\", "/")));
        out.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeExclusively(boolean waitForUnlock, RunnableWithException run) throws Exception {
        if (!EXCLUSIVE_RUN_LOCK.tryLock(waitForUnlock ? 180000L : 1L, TimeUnit.MILLISECONDS)) {
            TimeoutException ex = new TimeoutException("Timeout waiting for previous exclusive execution");
            Exception cause = new Exception("Previous exclusive execution");
            if (runningStackTrace != null) {
                cause.setStackTrace(runningStackTrace);
                ex.initCause(cause);
            }
            throw ex;
        }
        try {
            runningStackTrace = new Exception().getStackTrace();
            run.run();
        }
        finally {
            runningStackTrace = null;
            EXCLUSIVE_RUN_LOCK.unlock();
        }
    }

    protected static void omtPackLog(String msg) throws IOException {
        Log.logDebug((Logger)LOGGER, (String)msg, (Object[])new Object[0]);
        fhandler.write(msg + "\n");
    }

    private static void showStatusMessage(String msg) {
        Core.getMainWindow().showStatusMessageRB("app-version-template-pretty", new Object[]{msg, ""});
    }

    static {
        cliMode = false;
        pluginProps = new Properties();
    }

    public static interface RunnableWithException {
        public void run() throws Exception;
    }
}

