/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.tm;

import java.util.List;
import java.util.Properties;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.external.IWritableExternalMemory;
import org.omegat.util.Language;
import org.silvestrislab.cyclotis.omegat.HttpCyclotisTMX;
import org.silvestrislab.cyclotis.omegat.http.HttpOutputFormat;
import org.silvestrislab.cyclotis.omegat.tm.PropertiesStore;
import org.silvestrislab.cyclotis.omegat.tm.SaveConditions;

public class HttpMemory
extends HttpCyclotisTMX<PrepareTMXEntry>
implements IWritableExternalMemory {
    protected static final String LINE_FORMAT = "otadcupnN";
    private SaveConditions conditions;
    public PropertiesStore store;

    public HttpMemory(Properties propList) {
        super(propList);
        this.store = new PropertiesStore(this, propList);
        if (propList.getProperty("update") != null) {
            String updateString = propList.getProperty("update");
            this.conditions = !updateString.equalsIgnoreCase("false") ? SaveConditions.forProperty(updateString) : null;
        } else if (propList.getProperty("table.exclude") != null) {
            this.urlFind = this.urlFind + "?exclude=" + propList.getProperty("table.exclude");
            this.conditions = null;
        } else {
            this.conditions = null;
        }
        System.out.println(this.getMemoryName() + (this.conditions == null ? " update = false" : " update condition = " + this.conditions));
    }

    public List<PrepareTMXEntry> findMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception {
        this.logMessage("search", "Searching for <" + this.digest(text) + "> '" + text + "'");
        return this.httpGetAll("fuzzy", LINE_FORMAT, this.reduceWords(text));
    }

    @Override
    public PrepareTMXEntry analyzeLine(HttpOutputFormat fmt, Object args) {
        return fmt.buildTmxEntry(this, args);
    }

    public boolean isWriteMode() {
        return this.conditions != null;
    }

    public boolean mustWrite(PrepareTMXEntry entryContents, SourceTextEntry entrySource) {
        return this.conditions.mustWrite(this, entryContents, entrySource);
    }

    public void registerTranslation(Language sLang, Language tLang, PrepareTMXEntry entryContents, SourceTextEntry entrySource) throws Exception {
        entryContents.otherProperties = this.store.toDatabase(entryContents, entrySource);
        this.registerTranslation(entryContents);
    }
}

