/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.tm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.external.IWritableExternalMemory;
import org.omegat.util.Language;
import org.omegat.util.Preferences;
import org.omegat.util.TMXProp;
import org.silvestrislab.cyclotis.omegat.PostgresqlCyclotisTMX;
import org.silvestrislab.cyclotis.omegat.tm.PropertiesStore;
import org.silvestrislab.cyclotis.omegat.tm.SaveConditions;

public class PostgresqlMemory
extends PostgresqlCyclotisTMX<PrepareTMXEntry>
implements IWritableExternalMemory {
    private SaveConditions conditions;
    private PropertiesStore store;
    private String exclude = "";

    public PostgresqlMemory(Properties propList) throws SQLException, ClassNotFoundException {
        super(propList);
        this.store = new PropertiesStore(this, propList);
        if (propList.getProperty("update") != null) {
            String updateString = propList.getProperty("update");
            if (!updateString.equalsIgnoreCase("false")) {
                String author;
                this.conditions = SaveConditions.forProperty(updateString);
                String table = propList.getProperty("table");
                if (table == null) {
                    table = "MEM";
                }
                if ((author = propList.getProperty("author")) == null) {
                    author = Preferences.getPreferenceDefault((String)"team_Author", (String)System.getProperty("user.name"));
                }
                this.pInsert = this.getInsertStatement();
                this.pInsert.setString(3, author);
            } else {
                this.conditions = null;
            }
        } else if (propList.getProperty("table.exclude") != null) {
            ResultSet set;
            this.tableWrite = propList.getProperty("table.exclude");
            this.conditions = null;
            if (this.mem_id instanceof Integer) {
                set = this.getInfoResultSet("MEM_ID");
                if (set.next()) {
                    this.exclude = " and MEM_ID != " + set.getInt(1);
                }
                set.close();
            }
            if (this.mem_id instanceof Long) {
                set = this.getInfoResultSet("MEM_CODE");
                if (set.next()) {
                    this.exclude = " and MEM_CODE != " + set.getLong(1);
                }
                set.close();
            }
            if (this.mem_id instanceof String) {
                set = this.getInfoResultSet("MEM_PATH");
                if (set.next()) {
                    this.exclude = " and MEM_PATH != '" + set.getString(1) + "'";
                }
                set.close();
            }
        } else {
            this.conditions = null;
        }
        System.out.println(this.getMemoryName() + (this.conditions == null ? " update = false" : " update condition = " + this.conditions));
    }

    @Override
    protected String selectCondition() {
        return "src % ?" + this.exclude;
    }

    protected final PreparedStatement selectStatement(String table) throws SQLException {
        this.logMessage("sql", "Select statement = select * from " + table + " where src % ?");
        return this.connection.prepareStatement("select * from " + table + " where src % ?");
    }

    public List<PrepareTMXEntry> findMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception {
        this.logMessage("search", "Searching for <" + this.digest(text) + "> '" + text + "'");
        this.getSelectStatement().setString(1, this.reduceWords(text));
        return this.retreiveQuery(this.getSelectStatement());
    }

    @Override
    protected PrepareTMXEntry buildEntry(ResultSet set) throws SQLException {
        PrepareTMXEntry entry = new PrepareTMXEntry();
        entry.source = this.reformatText(set.getString("SRC"), true);
        entry.translation = this.reformatText(set.getString("TRA"), true);
        try {
            entry.creator = set.getString("AUTHOR");
            entry.creationDate = set.getTimestamp("DATE").getTime();
            entry.changer = set.getString("CHANGER");
            entry.changeDate = set.getTimestamp("CHANGEDATE").getTime();
            entry.note = set.getString("NOTE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.col_props != null) {
            List<TMXProp> read = this.col_props.read(set.getObject("PROPS"));
            try {
                read.add(new TMXProp("db.table.name", set.getString("MEM_NAME")));
            }
            catch (Exception e1) {
                read.add(new TMXProp("db.table.name", this.tableRead));
            }
            entry.otherProperties = this.store.fromDatabase(read, entry);
        } else {
            entry.otherProperties = this.store.fromDatabase(null, entry);
        }
        this.logEntry("search-results", entry, true);
        return entry;
    }

    public boolean isWriteMode() {
        return this.conditions != null;
    }

    @Override
    protected List<String> insertFields() {
        ArrayList<String> res = new ArrayList<String>(4);
        res.add("SRC");
        res.add("TRA");
        res.add("AUTHOR");
        if (this.col_props != null) {
            res.add("PROPS");
        }
        if (this.hasNote) {
            res.add("NOTE");
        }
        if (this.mem_id != null) {
            if (this.mem_id instanceof Integer) {
                res.add("MEM_ID");
            } else if (this.mem_id instanceof Long) {
                res.add("MEM_CODE");
            } else if (this.mem_id instanceof String) {
                res.add("MEM_PATH");
            }
        }
        return res;
    }

    public boolean mustWrite(PrepareTMXEntry entryContents, SourceTextEntry entrySource) {
        return this.conditions.mustWrite(this, entryContents, entrySource);
    }

    public void registerTranslation(Language sLang, Language tLang, PrepareTMXEntry entryContents, SourceTextEntry entrySource) throws Exception {
        if (this.col_props != null) {
            this.getInsertStatement().setObject(4, this.col_props.write(this.store.toDatabase(entryContents, entrySource)));
        }
        if (this.hasNote) {
            int idx;
            int n = idx = this.col_props == null ? 4 : 5;
            if (entryContents.note == null) {
                this.getInsertStatement().setNull(idx, 12);
            } else {
                this.getInsertStatement().setString(idx, entryContents.note);
            }
        }
        this.registerTranslation(entryContents);
    }
}

