/*
 * Decompiled with CFR 0.152.
 */
package org.omegat;

import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.omegat.CLIParameters;
import org.omegat.MainClassLoader;
import org.omegat.convert.ConvertConfigs;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.NotLoadedProject;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.RealProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.statistics.CalcStandardStatistics;
import org.omegat.core.statistics.StatsResult;
import org.omegat.core.tagvalidation.ErrorReport;
import org.omegat.core.team2.TeamTool;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.scripting.ConsoleBindings;
import org.omegat.gui.scripting.ScriptItem;
import org.omegat.gui.scripting.ScriptRunner;
import org.omegat.util.FileUtil;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Platform;
import org.omegat.util.Preferences;
import org.omegat.util.ProjectFileStorage;
import org.omegat.util.RuntimePreferences;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXWriter2;
import org.omegat.util.gui.OSXIntegration;

public final class Main {
    protected static File projectLocation = null;
    protected static String remoteProject = null;
    protected static final Map<String, String> PARAMS = new TreeMap<String, String>();
    protected static CLIParameters.RUN_MODE runMode = CLIParameters.RUN_MODE.GUI;

    private Main() {
    }

    public static void main(String[] args) {
        int result;
        String configDir;
        if (args.length > 0 && ("-h".equals(args[0]) || "--help".equals(args[0]))) {
            System.out.println(StringUtil.format(OStrings.getString("COMMAND_LINE_HELP"), OStrings.getNameAndVersion()));
            System.exit(0);
        }
        if (args.length > 0 && "team".equals(args[0])) {
            TeamTool.main(Arrays.copyOfRange(args, 1, args.length));
        }
        System.setProperty("jna.encoding", Charset.defaultCharset().name());
        PARAMS.putAll(CLIParameters.parseArgs(args));
        String projectDir = PARAMS.get("project");
        if (projectDir != null) {
            projectLocation = new File(FileUtil.expandTildeHomeDir(projectDir));
        }
        remoteProject = PARAMS.get("remote-project");
        Main.applyConfigFile(PARAMS.get("config-file"));
        runMode = CLIParameters.RUN_MODE.parse(PARAMS.get("mode"));
        String resourceBundle = PARAMS.get("resource-bundle");
        if (resourceBundle != null) {
            OStrings.loadBundle(FileUtil.expandTildeHomeDir(resourceBundle));
        }
        if ((configDir = PARAMS.get("config-dir")) != null) {
            RuntimePreferences.setConfigDir(FileUtil.expandTildeHomeDir(configDir));
        }
        if (PARAMS.containsKey("quiet")) {
            RuntimePreferences.setQuietMode(true);
        }
        if (PARAMS.containsKey("disable-project-locking")) {
            RuntimePreferences.setProjectLockingEnabled(false);
        }
        if (PARAMS.containsKey("disable-location-save")) {
            RuntimePreferences.setLocationSaveEnabled(false);
        }
        Log.log("\n===================================================================\n" + OStrings.getNameAndVersion() + " (" + new Date() + ")  Locale " + Locale.getDefault());
        Log.logRB("LOG_STARTUP_INFO", System.getProperty("java.vendor"), System.getProperty("java.version"), System.getProperty("java.home"));
        System.setProperty("http.agent", OStrings.getDisplayNameAndVersion());
        ConvertConfigs.convert();
        Preferences.init();
        PluginUtils.loadPlugins(PARAMS);
        FilterMaster.setFilterClasses(PluginUtils.getFilterClasses());
        Preferences.initFilters();
        Preferences.initSegmentation();
        try {
            switch (runMode) {
                case GUI: {
                    result = Main.runGUI();
                    break;
                }
                case CONSOLE_TRANSLATE: {
                    result = Main.runConsoleTranslate();
                    PluginUtils.unloadPlugins();
                    break;
                }
                case CONSOLE_CREATEPSEUDOTRANSLATETMX: {
                    result = Main.runCreatePseudoTranslateTMX();
                    PluginUtils.unloadPlugins();
                    break;
                }
                case CONSOLE_ALIGN: {
                    result = Main.runConsoleAlign();
                    PluginUtils.unloadPlugins();
                    break;
                }
                case CONSOLE_STATS: {
                    result = Main.runConsoleStats();
                    PluginUtils.unloadPlugins();
                    break;
                }
                default: {
                    result = 1;
                    break;
                }
            }
        }
        catch (Throwable ex) {
            Log.log(ex);
            Main.showError(ex);
            result = 1;
        }
        if (result != 0) {
            System.exit(result);
        }
    }

    public static void restartGUI(String projectDir) {
        Log.log("===         Restart OmegaT           ===");
        String javaBin = String.join((CharSequence)File.separator, System.getProperty("java.home"), "bin", "java");
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaBin);
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        command.addAll(runtimeMxBean.getInputArguments());
        command.add("-cp");
        command.add(runtimeMxBean.getClassPath());
        command.add(Main.class.getName());
        command.addAll(CLIParameters.unparseArgs(PARAMS));
        if (projectDir != null) {
            command.add(projectDir);
        }
        ProcessBuilder builder = new ProcessBuilder(command);
        try {
            builder.start();
            System.exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void applyConfigFile(String path) {
        if (path == null) {
            return;
        }
        File configFile = new File(FileUtil.expandTildeHomeDir(path));
        if (!configFile.exists()) {
            return;
        }
        System.out.println("Reading config from " + path);
        try (FileInputStream in = new FileInputStream(configFile);){
            PropertyResourceBundle config = new PropertyResourceBundle(in);
            for (String key : config.keySet()) {
                String value = config.getString(key);
                System.setProperty(key, value);
                PARAMS.put(key, value);
                System.out.println("Read from config: " + key + "=" + value);
            }
            if (config.containsKey("user.language")) {
                String userLanguage = config.getString("user.language");
                Locale userLocale = config.containsKey("user.country") ? new Locale(userLanguage, config.getString("user.country")) : new Locale(userLanguage);
                Locale.setDefault(userLocale);
            }
        }
        catch (FileNotFoundException exception) {
            System.err.println("Config file not found: " + path);
        }
        catch (IOException exception) {
            System.err.println("Error while reading config file: " + path);
        }
    }

    protected static int runGUI() {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        MainClassLoader mainClassLoader = cl instanceof MainClassLoader ? (MainClassLoader)cl : new MainClassLoader(cl);
        PluginUtils.getThemePluginJars().forEach(mainClassLoader::add);
        UIManager.put("ClassLoader", mainClassLoader);
        if (Platform.isMacOSX()) {
            OSXIntegration.init();
        }
        Log.log("Docking Framework version: " + DockingDesktop.getDockingFrameworkVersion());
        Log.log("");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Class<?> cls = toolkit.getClass();
        try {
            if (cls.getName().equals("sun.awt.X11.XToolkit")) {
                Field field = cls.getDeclaredField("awtAppClassName");
                field.setAccessible(true);
                field.set(toolkit, "OmegaT");
            }
        }
        catch (Exception field) {
            // empty catch block
        }
        System.setProperty("swing.aatext", "true");
        try {
            Core.initializeGUI(mainClassLoader, PARAMS);
        }
        catch (Throwable ex) {
            Log.log(ex);
            Main.showError(ex);
            return 1;
        }
        if (!Core.getPluginsLoadingErrors().isEmpty()) {
            String err = String.join((CharSequence)"\n", Core.getPluginsLoadingErrors());
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), err, OStrings.getString("STARTUP_ERRORBOX_TITLE"), 0);
        }
        CoreEvents.fireApplicationStartup();
        SwingUtilities.invokeLater(() -> {
            Core.getMainWindow().getApplicationFrame().setVisible(true);
            if (remoteProject != null) {
                ProjectUICommands.projectRemote(remoteProject);
            } else if (projectLocation != null) {
                ProjectUICommands.projectOpen(projectLocation);
            }
        });
        return 0;
    }

    protected static int runConsoleTranslate() throws Exception {
        Log.log("Console translation mode");
        Log.log("");
        System.out.println(OStrings.getString("CONSOLE_INITIALIZING"));
        Core.initializeConsole(PARAMS);
        RealProject p = Main.selectProjectConsoleMode(true);
        Main.validateTagsConsoleMode();
        System.out.println(OStrings.getString("CONSOLE_TRANSLATING"));
        String sourceMask = PARAMS.get("source-pattern");
        if (sourceMask != null) {
            p.compileProject(sourceMask, false);
        } else {
            p.compileProject(".*", false);
        }
        Main.executeConsoleScript(IProjectEventListener.PROJECT_CHANGE_TYPE.COMPILE);
        p.closeProject();
        Main.executeConsoleScript(IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE);
        System.out.println(OStrings.getString("CONSOLE_FINISHED"));
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runConsoleStats() throws Exception {
        Log.log("Console project stats mode");
        Log.log("");
        Core.initializeConsole(PARAMS);
        RealProject p = Main.selectProjectConsoleMode(true);
        StatsResult projectStats = CalcStandardStatistics.buildProjectStats(p);
        if (!PARAMS.containsKey("output-file")) {
            System.out.println(projectStats.getTextData());
            p.closeProject();
            return 0;
        }
        String outputFilename = PARAMS.get("output-file");
        String statsMode = PARAMS.containsKey("stats-type") ? PARAMS.get("stats-type") : (outputFilename.endsWith(".json") || outputFilename.endsWith(".JSON") ? "JSON" : (outputFilename.endsWith(".xml") || outputFilename.endsWith(".XML") ? "XML" : (outputFilename.endsWith(".txt") || outputFilename.endsWith(".TXT") ? "TXT" : "XML")));
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(Paths.get(FileUtil.expandTildeHomeDir(outputFilename), new String[0]), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE), StandardCharsets.UTF_8);){
            if ("TXT".equalsIgnoreCase(statsMode) || "text".equalsIgnoreCase(statsMode)) {
                writer.write(projectStats.getTextData());
            } else if ("JSON".equalsIgnoreCase(statsMode)) {
                writer.write(projectStats.getJsonData());
            } else if ("XML".equalsIgnoreCase(statsMode)) {
                writer.write(projectStats.getXmlData());
            } else {
                Log.log("Specified UNKNOWN file type for statistics. aborted.");
            }
        }
        catch (NoSuchFileException nsfe) {
            Log.log("Got directory/file open error. Does specified directory exist?");
            int n = 1;
            return n;
        }
        finally {
            p.closeProject();
        }
        return 0;
    }

    private static void validateTagsConsoleMode() {
        CLIParameters.TAG_VALIDATION_MODE mode = CLIParameters.TAG_VALIDATION_MODE.parse(PARAMS.get("tag-validation"));
        switch (mode) {
            case ABORT: {
                System.out.println(OStrings.getString("CONSOLE_VALIDATING_TAGS"));
                List<ErrorReport> stes = Core.getTagValidation().listInvalidTags();
                if (stes.isEmpty()) break;
                Core.getTagValidation().logTagValidationErrors(stes);
                System.out.println(OStrings.getString("CONSOLE_TAGVALIDATION_FAIL"));
                System.out.println(OStrings.getString("CONSOLE_TAGVALIDATION_ABORT"));
                System.exit(1);
                break;
            }
            case WARN: {
                System.out.println(OStrings.getString("CONSOLE_VALIDATING_TAGS"));
                List<ErrorReport> stes = Core.getTagValidation().listInvalidTags();
                if (stes.isEmpty()) break;
                Core.getTagValidation().logTagValidationErrors(stes);
                System.out.println(OStrings.getString("CONSOLE_TAGVALIDATION_FAIL"));
                break;
            }
        }
    }

    protected static int runCreatePseudoTranslateTMX() throws Exception {
        Log.log("Console pseudo-translate mode");
        Log.log("");
        System.out.println(OStrings.getString("CONSOLE_INITIALIZING"));
        Core.initializeConsole(PARAMS);
        RealProject p = Main.selectProjectConsoleMode(true);
        Main.validateTagsConsoleMode();
        System.out.println(OStrings.getString("CONSOLE_CREATE_PSEUDOTMX"));
        ProjectProperties config = p.getProjectProperties();
        List<SourceTextEntry> entries = p.getAllEntries();
        String pseudoTranslateTMXFilename = PARAMS.get("pseudotranslatetmx");
        CLIParameters.PSEUDO_TRANSLATE_TYPE pseudoTranslateType = CLIParameters.PSEUDO_TRANSLATE_TYPE.parse(PARAMS.get("pseudotranslatetype"));
        String fname = !StringUtil.isEmpty(pseudoTranslateTMXFilename) ? (!pseudoTranslateTMXFilename.endsWith(".tmx") ? pseudoTranslateTMXFilename + "." + ".tmx" : pseudoTranslateTMXFilename) : "";
        try (TMXWriter2 wr = new TMXWriter2(new File(fname), config.getSourceLanguage(), config.getTargetLanguage(), config.isSentenceSegmentingEnabled(), false, false);){
            for (SourceTextEntry ste : entries) {
                switch (pseudoTranslateType) {
                    case EQUAL: {
                        wr.writeEntry(ste.getSrcText(), ste.getSrcText(), null, null, 0L, null, 0L, null);
                        break;
                    }
                    case EMPTY: {
                        wr.writeEntry(ste.getSrcText(), "", null, null, 0L, null, 0L, null);
                    }
                }
            }
        }
        catch (IOException e) {
            Log.logErrorRB("CT_ERROR_CREATING_TMX", new Object[0]);
            Log.log(e);
            throw new IOException(OStrings.getString("CT_ERROR_CREATING_TMX") + "\n" + e.getMessage());
        }
        p.closeProject();
        System.out.println(OStrings.getString("CONSOLE_FINISHED"));
        return 0;
    }

    public static int runConsoleAlign() throws Exception {
        Log.log("Console alignment mode");
        Log.log("");
        if (projectLocation == null) {
            System.out.println(OStrings.getString("PP_ERROR_UNABLE_TO_READ_PROJECT_FILE"));
            return 1;
        }
        String dir = PARAMS.get("alignDir");
        if (dir == null) {
            System.out.println(OStrings.getString("CONSOLE_TRANSLATED_FILES_LOC_UNDEFINED"));
            return 1;
        }
        System.out.println(OStrings.getString("CONSOLE_INITIALIZING"));
        Core.initializeConsole(PARAMS);
        RealProject p = Main.selectProjectConsoleMode(true);
        Main.validateTagsConsoleMode();
        System.out.println(StringUtil.format(OStrings.getString("CONSOLE_ALIGN_AGAINST"), dir));
        String tmxFile = p.getProjectProperties().getProjectInternal() + "align.tmx";
        ProjectProperties config = p.getProjectProperties();
        boolean alt = !config.isSupportDefaultTranslations();
        try (TMXWriter2 wr = new TMXWriter2(new File(tmxFile), config.getSourceLanguage(), config.getTargetLanguage(), config.isSentenceSegmentingEnabled(), alt, alt);){
            wr.writeEntries(p.align(config, new File(FileUtil.expandTildeHomeDir(dir))), alt);
        }
        p.closeProject();
        System.out.println(OStrings.getString("CONSOLE_FINISHED"));
        return 0;
    }

    private static RealProject selectProjectConsoleMode(boolean loadProject) {
        System.out.println(OStrings.getString("CONSOLE_LOADING_PROJECT"));
        ProjectProperties projectProperties = null;
        try {
            projectProperties = ProjectFileStorage.loadProjectProperties(projectLocation);
            projectProperties.verifyProject();
        }
        catch (Exception ex) {
            Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
            System.out.println(OStrings.getString("PP_ERROR_UNABLE_TO_READ_PROJECT_FILE"));
            System.exit(1);
        }
        RealProject p = new RealProject(projectProperties);
        Core.setProject(p);
        if (loadProject) {
            p.loadProject(true);
            if (!p.isProjectLoaded()) {
                Core.setProject(new NotLoadedProject());
            } else {
                Main.executeConsoleScript(IProjectEventListener.PROJECT_CHANGE_TYPE.LOAD);
            }
        }
        return p;
    }

    private static void executeConsoleScript(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        if (PARAMS.containsKey("script")) {
            File script = new File(PARAMS.get("script").toString());
            Log.log(OStrings.getString("CONSOLE_EXECUTE_SCRIPT", new Object[]{script, eventType}));
            if (script.isFile()) {
                HashMap<String, Object> binding = new HashMap<String, Object>();
                binding.put("eventType", (Object)eventType);
                ConsoleBindings consoleBindigs = new ConsoleBindings();
                binding.put("console", consoleBindigs);
                binding.put("glossary", consoleBindigs);
                binding.put("editor", consoleBindigs);
                try {
                    String result = ScriptRunner.executeScript(new ScriptItem(script), binding);
                    Log.log(result);
                }
                catch (Exception ex) {
                    Log.log(ex);
                }
            } else {
                Log.log(OStrings.getString("SCW_SCRIPT_LOAD_ERROR", "the script is not a file"));
            }
        }
    }

    public static void showError(Throwable ex) {
        String msg = StringUtil.isEmpty(ex.getMessage()) ? ex.getClass().getName() : ex.getMessage();
        switch (runMode) {
            case GUI: {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), msg, OStrings.getString("STARTUP_ERRORBOX_TITLE"), 0);
                break;
            }
            default: {
                System.err.println(MessageFormat.format(OStrings.getString("CONSOLE_ERROR"), msg));
            }
        }
    }
}

