/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.html2;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import org.htmlparser.Attribute;
import org.htmlparser.Node;
import org.htmlparser.Remark;
import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.visitors.NodeVisitor;
import org.omegat.core.Core;
import org.omegat.filters2.html2.HTMLFilter2;
import org.omegat.filters2.html2.HTMLOptions;
import org.omegat.util.HTMLUtils;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.StringUtil;

public class FilterVisitor
extends NodeVisitor {
    protected HTMLFilter2 filter;
    private BufferedWriter writer;
    private HTMLOptions options;
    protected boolean recurseSelf = true;
    protected boolean recurseChildren = true;
    protected boolean isTextUpForCollection = false;
    protected boolean betweenPreformattingTags = false;
    protected List<Node> precedingNodes;
    protected List<Node> translatableNodes;
    protected List<Node> followingNodes;
    protected List<Node> sTags;
    protected List<Integer> sTagNumbers;
    protected List<String> sShortcuts;
    int sNumShortcuts;
    boolean firstcall = true;

    public FilterVisitor(HTMLFilter2 htmlfilter, BufferedWriter bufwriter, HTMLOptions opts) {
        this.filter = htmlfilter;
        this.options = opts != null ? opts : new HTMLOptions(new TreeMap<String, String>());
        this.writer = bufwriter;
    }

    public boolean shouldRecurseSelf() {
        return this.recurseSelf;
    }

    public boolean shouldRecurseChildren() {
        return this.recurseChildren;
    }

    public void visitTag(Tag tag) {
        if (this.isProtectedTag(tag)) {
            if (this.isTextUpForCollection) {
                this.endup();
            } else {
                this.writeOutPrecedingNodes();
            }
            this.writeout(tag.toHtml());
            if (this.hasAnEndTag(tag)) {
                this.recurseSelf = true;
                this.recurseChildren = false;
            }
        } else {
            if (this.isParagraphTag(tag)) {
                this.handleParagraphTag();
            }
            if (this.isPreformattingTag(tag)) {
                this.betweenPreformattingTags = true;
            }
            this.maybeTranslateAttribute(tag, "abbr");
            this.maybeTranslateAttribute(tag, "alt");
            this.maybeTranslateAttribute(tag, "dir");
            if (this.options.getTranslateHref()) {
                this.maybeTranslateAttribute(tag, "href");
            }
            if (this.options.getTranslateHreflang()) {
                this.maybeTranslateAttribute(tag, "hreflang");
            }
            if (this.options.getTranslateLang()) {
                this.maybeTranslateAttribute(tag, "lang");
                this.maybeTranslateAttribute(tag, "xml:lang");
            }
            this.maybeTranslateAttribute(tag, "label");
            if ("IMG".equals(tag.getTagName()) && this.options.getTranslateSrc()) {
                this.maybeTranslateAttribute(tag, "src");
            }
            this.maybeTranslateAttribute(tag, "summary");
            this.maybeTranslateAttribute(tag, "title");
            if ("INPUT".equals(tag.getTagName())) {
                if (this.options.getTranslateValue() || this.options.getTranslateButtonValue() && ("submit".equalsIgnoreCase(tag.getAttribute("type")) || "button".equalsIgnoreCase(tag.getAttribute("type")) || "reset".equalsIgnoreCase(tag.getAttribute("type")))) {
                    this.maybeTranslateAttribute(tag, "value");
                }
                this.maybeTranslateAttribute(tag, "placeholder");
            }
            if ("META".equals(tag.getTagName())) {
                Vector tagAttributes = tag.getAttributesEx();
                Iterator i = tagAttributes.iterator();
                boolean doSkipMetaTag = false;
                while (i.hasNext() && !doSkipMetaTag) {
                    Attribute attribute = (Attribute)i.next();
                    String name = attribute.getName();
                    String value = attribute.getValue();
                    if (name == null || value == null) continue;
                    doSkipMetaTag = this.filter.checkDoSkipMetaTag(name, value);
                }
                if (!doSkipMetaTag) {
                    this.maybeTranslateAttribute(tag, "content");
                }
            }
            this.queuePrefix(tag);
        }
    }

    private boolean hasAnEndTag(Tag tag) {
        return tag.getEndTag() != null;
    }

    private void handleParagraphTag() {
        this.recurseChildren = true;
        if (this.isTextUpForCollection) {
            this.endup();
        }
    }

    protected void maybeTranslateAttribute(Tag tag, String key) {
        String attr = tag.getAttribute(key);
        if (attr != null) {
            String comment = OStrings.getString("HTMLFILTER_TAG") + " " + tag.getTagName() + " " + OStrings.getString("HTMLFILTER_ATTRIBUTE") + " " + key;
            String trans = this.filter.privateProcessEntry(HTMLUtils.entitiesToChars(attr), comment);
            tag.setAttribute(key, HTMLUtils.charsToEntities(trans, this.filter.getTargetEncoding(), this.sShortcuts));
        }
    }

    public void visitStringNode(Text string) {
        this.recurseSelf = true;
        this.recurseChildren = true;
        String textAsCleanedString = HTMLUtils.entitiesToChars(string.getText()).replace('\u00a0', ' ');
        if (this.hasMoreThanJustWhitepaces(textAsCleanedString)) {
            if (this.firstcall && PatternConsts.XML_HEADER.matcher(textAsCleanedString.trim()).matches()) {
                this.writeout(string.toHtml());
                return;
            }
            this.isTextUpForCollection = true;
            this.firstcall = false;
        } else if (this.betweenPreformattingTags) {
            this.isTextUpForCollection = true;
        }
        if (this.isTextUpForCollection) {
            this.queueTranslatable(string);
        } else {
            this.queuePrefix(string);
        }
    }

    public void visitRemarkNode(Remark remark) {
        if (this.shouldKeepComments()) {
            this.recurseSelf = true;
            this.recurseChildren = true;
            if (this.betweenPreformattingTags) {
                this.isTextUpForCollection = true;
            }
            if (this.isTextUpForCollection) {
                this.queueTranslatable(remark);
            } else {
                this.queuePrefix(remark);
            }
        }
    }

    private boolean shouldKeepComments() {
        return !this.options.getRemoveComments();
    }

    public void visitEndTag(Tag tag) {
        this.recurseSelf = true;
        this.recurseChildren = true;
        if (this.isParagraphTag(tag) && this.isTextUpForCollection) {
            this.endup();
        }
        if (this.isPreformattingTag(tag)) {
            this.betweenPreformattingTags = false;
        }
        this.queuePrefix(tag);
    }

    public void beginParsing() {
        this.cleanup();
    }

    public void finishedParsing() {
        if (this.isTextUpForCollection) {
            this.endup();
        } else {
            this.writeOutPrecedingNodes();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isParagraphTag(Tag tag) {
        String tagname = tag.getTagName();
        String[] blockElementTags = new String[]{"ADDRESS", "ARTICLE", "ASIDE", "BLOCKQUOTE", "BODY", "CANVAS", "CENTER", "DD", "DIV", "DL", "DT", "FIELDSET", "FIGCAPTION", "FIGURE", "FOOTER", "FORM", "H1", "H2", "H3", "H4", "H5", "H6", "HEADER", "HR", "LABEL", "LEGEND", "LI", "MAIN", "NAV", "NOSCRIPT", "OL", "OPTION", "P", "PRE", "SECTION", "SELECT", "TABLE", "TD", "TEXTAREA", "TFOOT", "TH", "TITLE", "TR", "UL", "VIDEO"};
        String[] parentElementTags = new String[]{"HEAD", "HTML"};
        if (tagname.equals("BR")) {
            if (this.options.getParagraphOnBr()) return true;
        }
        if (Arrays.stream(parentElementTags).anyMatch(tagname::equals)) return true;
        if (!Arrays.stream(blockElementTags).anyMatch(tagname::equals)) return false;
        return true;
    }

    private boolean isProtectedTag(Tag tag) {
        boolean keepIntact;
        String tagname = tag.getTagName();
        String[] noEditTags = new String[]{"!DOCTYPE", "STYLE", "SCRIPT", "OBJECT", "EMBED"};
        boolean bl = keepIntact = Arrays.stream(noEditTags).anyMatch(tagname::equals) || tagname.equals("META") && "content-type".equalsIgnoreCase(tag.getAttribute("http-equiv"));
        if (!keepIntact) {
            keepIntact = this.hasSpecialAttributes(tag);
        }
        return keepIntact;
    }

    private boolean hasSpecialAttributes(Tag tag) {
        boolean attributeIsOnIgnoreTagsList = false;
        Vector tagAttributes = tag.getAttributesEx();
        Iterator i = tagAttributes.iterator();
        while (i.hasNext() && !attributeIsOnIgnoreTagsList) {
            Attribute attribute = (Attribute)i.next();
            String name = attribute.getName();
            String value = attribute.getValue();
            if (name == null || value == null) continue;
            attributeIsOnIgnoreTagsList = this.filter.checkIgnoreTags(name, value);
        }
        return attributeIsOnIgnoreTagsList;
    }

    private boolean isPreformattingTag(Tag tag) {
        String tagname = tag.getTagName();
        return tagname.equals("PRE") || tagname.equals("TEXTAREA");
    }

    private void writeout(String something) {
        try {
            this.writer.write(something);
        }
        catch (IOException ioe) {
            Log.log(ioe);
        }
    }

    protected void endup() {
        String translation;
        String uncompressed;
        int lastTagKeptInFollowing;
        int firstTagToIncludeFromPreceding;
        ArrayList<Node> allNodesInParagraph = new ArrayList<Node>();
        allNodesInParagraph.addAll(this.precedingNodes);
        allNodesInParagraph.addAll(this.translatableNodes);
        allNodesInParagraph.addAll(this.followingNodes);
        int lastPrecedingNodePosition = this.precedingNodes.size() - 1;
        int lastTranslatableNodePosition = lastPrecedingNodePosition + this.translatableNodes.size();
        int lastFollowingPosition = allNodesInParagraph.size() - 1;
        for (firstTagToIncludeFromPreceding = 0; firstTagToIncludeFromPreceding <= lastPrecedingNodePosition; ++firstTagToIncludeFromPreceding) {
            Node startNode = (Node)allNodesInParagraph.get(firstTagToIncludeFromPreceding);
            if (!(startNode instanceof Tag)) continue;
            Tag openingTag = (Tag)startNode;
            int recursion = 1;
            boolean found = false;
            for (int i = firstTagToIncludeFromPreceding + 1; i <= lastTranslatableNodePosition; ++i) {
                Tag candidateTag;
                Node candidateNode = (Node)allNodesInParagraph.get(i);
                if (!(candidateNode instanceof Tag) || !(candidateTag = (Tag)candidateNode).getTagName().equals(openingTag.getTagName())) continue;
                if (candidateTag.isEndTag()) {
                    if (--recursion != 0) continue;
                    if (i <= lastPrecedingNodePosition) break;
                    found = true;
                    break;
                }
                ++recursion;
            }
            if (found) break;
        }
        for (lastTagKeptInFollowing = lastFollowingPosition; lastTagKeptInFollowing > lastTranslatableNodePosition; --lastTagKeptInFollowing) {
            Node endNode = (Node)allNodesInParagraph.get(lastTagKeptInFollowing);
            if (!(endNode instanceof Tag)) continue;
            Tag closingTag = (Tag)endNode;
            int recursion = 1;
            boolean found = false;
            for (int i = lastTagKeptInFollowing - 1; i > lastPrecedingNodePosition; --i) {
                Tag candidateTag;
                Node candidateNode = (Node)allNodesInParagraph.get(i);
                if (!(candidateNode instanceof Tag) || !(candidateTag = (Tag)candidateNode).getTagName().equals(closingTag.getTagName())) continue;
                if (candidateTag.isEndTag()) {
                    ++recursion;
                    continue;
                }
                if (--recursion != 0) continue;
                if (i > lastTranslatableNodePosition) break;
                found = true;
                break;
            }
            if (found) break;
        }
        boolean changed = true;
        block4: while (changed) {
            Node node;
            int i;
            boolean removeSpacesAround;
            changed = false;
            boolean removeTags = Core.getFilterMaster().getConfig().isRemoveTags();
            if (!removeTags) {
                int i2;
                for (i2 = 0; i2 < firstTagToIncludeFromPreceding; ++i2) {
                    Node node2 = (Node)allNodesInParagraph.get(i2);
                    if (!(node2 instanceof Tag)) continue;
                    firstTagToIncludeFromPreceding = i2;
                    changed = true;
                    break;
                }
                for (i2 = lastFollowingPosition; i2 > lastTagKeptInFollowing; --i2) {
                    Node node3 = (Node)allNodesInParagraph.get(i2);
                    if (!(node3 instanceof Tag)) continue;
                    lastTagKeptInFollowing = i2;
                    changed = true;
                    break;
                }
            }
            if (removeSpacesAround = Core.getFilterMaster().getConfig().isRemoveSpacesNonseg()) continue;
            for (i = 0; i < firstTagToIncludeFromPreceding; ++i) {
                node = (Node)allNodesInParagraph.get(i);
                if (!(node instanceof TextNode)) continue;
                firstTagToIncludeFromPreceding = i;
                changed = true;
                break;
            }
            for (i = allNodesInParagraph.size() - 1; i > lastTagKeptInFollowing; --i) {
                node = (Node)allNodesInParagraph.get(i);
                if (!(node instanceof TextNode)) continue;
                lastTagKeptInFollowing = i;
                changed = true;
                continue block4;
            }
        }
        for (int i = 0; i < firstTagToIncludeFromPreceding; ++i) {
            Node node = (Node)allNodesInParagraph.get(i);
            if (node instanceof Tag) {
                this.writeout("<" + node.getText() + ">");
                continue;
            }
            if (node instanceof Remark) {
                this.writeout(node.toHtml());
                continue;
            }
            this.writeout(this.compressWhitespace(node.getText()));
        }
        StringBuilder paragraph = new StringBuilder();
        for (int i = firstTagToIncludeFromPreceding; i <= lastTagKeptInFollowing; ++i) {
            Node node = (Node)allNodesInParagraph.get(i);
            if (node instanceof Tag) {
                this.assignShortcut((Tag)node, paragraph);
                continue;
            }
            if (node instanceof Remark) {
                this.assignShortcut((Remark)node, paragraph);
                continue;
            }
            paragraph.append(HTMLUtils.entitiesToChars(node.toHtml()));
        }
        String compressed = uncompressed = paragraph.toString();
        String spacePrefix = "";
        String spacePostfix = "";
        if (!this.betweenPreformattingTags) {
            spacePrefix = HTMLUtils.getSpacePrefix(uncompressed, this.options.getCompressWhitespace());
            spacePostfix = HTMLUtils.getSpacePostfix(uncompressed, this.options.getCompressWhitespace());
            compressed = Core.getFilterMaster().getConfig().isRemoveSpacesNonseg() ? StringUtil.compressSpaces(uncompressed) : uncompressed;
        }
        if (compressed.equals(translation = this.filter.privateProcessEntry(compressed, null)) && !this.options.getCompressWhitespace()) {
            translation = uncompressed;
            spacePrefix = "";
            spacePostfix = "";
        }
        translation = HTMLUtils.charsToEntities(translation, this.filter.getTargetEncoding(), this.sShortcuts);
        translation = this.revertShortcut(translation);
        this.writeout(spacePrefix);
        this.writeout(translation);
        this.writeout(spacePostfix);
        for (int i = lastTagKeptInFollowing + 1; i < allNodesInParagraph.size(); ++i) {
            Node node = (Node)allNodesInParagraph.get(i);
            if (node instanceof Tag) {
                this.writeout("<" + node.getText() + ">");
                continue;
            }
            if (node instanceof Remark) {
                this.writeout(node.toHtml());
                continue;
            }
            this.writeout(this.compressWhitespace(node.getText()));
        }
        this.cleanup();
    }

    private void cleanup() {
        this.isTextUpForCollection = false;
        this.recurseSelf = true;
        this.recurseChildren = true;
        this.precedingNodes = new ArrayList<Node>();
        this.translatableNodes = new ArrayList<Node>();
        this.followingNodes = new ArrayList<Node>();
        this.sTags = new ArrayList<Node>();
        this.sTagNumbers = new ArrayList<Integer>();
        this.sShortcuts = new ArrayList<String>();
        this.sNumShortcuts = 0;
    }

    private void assignShortcut(Tag tag, StringBuilder paragraph) {
        StringBuilder result = new StringBuilder();
        result.append('<');
        int n = -1;
        if (tag.isEndTag()) {
            result.append('/');
            int recursion = 1;
            for (int i = this.sTags.size() - 1; i >= 0; --i) {
                Tag othertag;
                if (!(this.sTags.get(i) instanceof Tag) || !(othertag = (Tag)this.sTags.get(i)).getTagName().equals(tag.getTagName())) continue;
                if (othertag.isEndTag()) {
                    ++recursion;
                    continue;
                }
                if (--recursion != 0) continue;
                n = this.sTagNumbers.get(i);
                break;
            }
            if (n < 0) {
                n = this.sNumShortcuts++;
            }
        } else {
            n = this.sNumShortcuts++;
        }
        if ("BR".equals(tag.getTagName())) {
            result.append("br");
        } else {
            result.appendCodePoint(Character.toLowerCase(tag.getTagName().codePointAt(0)));
        }
        result.append(n);
        if (tag.isEmptyXmlTag()) {
            result.append('/');
        }
        result.append('>');
        String shortcut = result.toString();
        this.sTags.add((Node)tag);
        this.sTagNumbers.add(n);
        this.sShortcuts.add(shortcut);
        paragraph.append(shortcut);
    }

    private void assignShortcut(Remark remark, StringBuilder paragraph) {
        StringBuilder result = new StringBuilder();
        int n = this.sNumShortcuts++;
        result.append("<c");
        result.append(n);
        result.append("/>");
        String shortcut = result.toString();
        this.sTags.add((Node)remark);
        this.sTagNumbers.add(n);
        this.sShortcuts.add(shortcut);
        paragraph.append(shortcut);
    }

    private String revertShortcut(String str) {
        block4: for (int i = 0; i < this.sShortcuts.size(); ++i) {
            String shortcut = this.sShortcuts.get(i);
            int pos = -1;
            while ((pos = str.indexOf(shortcut, pos + 1)) >= 0) {
                if (this.sTags.get(i) instanceof Tag) {
                    Tag tag = (Tag)this.sTags.get(i);
                    try {
                        str = str.substring(0, pos) + "<" + tag.getText() + ">" + str.substring(pos + shortcut.length());
                        continue;
                    }
                    catch (StringIndexOutOfBoundsException sioobe) {
                        continue block4;
                    }
                }
                if (!(this.sTags.get(i) instanceof Remark)) continue;
                Remark comment = (Remark)this.sTags.get(i);
                try {
                    str = str.substring(0, pos) + comment.toHtml() + str.substring(pos + shortcut.length());
                }
                catch (StringIndexOutOfBoundsException sioobe) {
                    continue block4;
                }
            }
        }
        return str;
    }

    private void queueTranslatable(Text txt) {
        if (this.hasMoreThanJustWhitepaces(txt.toHtml()) || this.betweenPreformattingTags) {
            this.translatableNodes.addAll(this.followingNodes);
            this.followingNodes.clear();
            this.translatableNodes.add((Node)txt);
        } else {
            this.followingNodes.add((Node)txt);
        }
    }

    private boolean hasMoreThanJustWhitepaces(String string) {
        return !string.trim().isEmpty();
    }

    private void queueTranslatable(Remark remark) {
        if (this.betweenPreformattingTags) {
            this.translatableNodes.addAll(this.followingNodes);
            this.followingNodes.clear();
            this.translatableNodes.add((Node)remark);
        } else {
            this.followingNodes.add((Node)remark);
        }
    }

    private void queueTranslatable(Tag tag) {
        this.followingNodes.add((Node)tag);
    }

    protected void queuePrefix(Tag tag) {
        if (this.isTextUpForCollection) {
            this.queueTranslatable(tag);
        } else if (this.isParagraphTag(tag)) {
            this.writeOutPrecedingNodes();
            this.writeout("<" + tag.getText() + ">");
        } else {
            this.precedingNodes.add((Node)tag);
        }
    }

    private void queuePrefix(Text txt) {
        this.precedingNodes.add((Node)txt);
    }

    private void queuePrefix(Remark remark) {
        this.precedingNodes.add((Node)remark);
    }

    private void writeOutPrecedingNodes() {
        for (Node node : this.precedingNodes) {
            if (node instanceof Tag) {
                this.writeout("<" + node.getText() + ">");
                continue;
            }
            if (node instanceof Remark) {
                this.writeout(node.toHtml());
                continue;
            }
            this.writeout(this.compressWhitespace(node.getText()));
        }
        this.precedingNodes.clear();
    }

    private String compressWhitespace(String input) {
        if (this.options.getCompressWhitespace()) {
            Matcher whitespaceMatch = PatternConsts.SPACE_TAB.matcher(input);
            return whitespaceMatch.replaceAll(" ");
        }
        return input;
    }
}

