/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.align;

import gen.core.filters.Filters;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.concurrent.CancellationException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.commons.io.FilenameUtils;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.segmentation.SRX;
import org.omegat.core.segmentation.Segmenter;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.gui.align.AlignMenuFrame;
import org.omegat.gui.align.AlignPanel;
import org.omegat.gui.align.Aligner;
import org.omegat.gui.align.EditingPanelController;
import org.omegat.gui.align.MutableBead;
import org.omegat.gui.align.PatternPanelController;
import org.omegat.gui.align.SplittingPanelController;
import org.omegat.gui.align.Util;
import org.omegat.gui.filters2.FiltersCustomizer;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.segmentation.SegmentationCustomizer;
import org.omegat.util.Java8Compat;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.DelegatingComboBoxRenderer;
import org.omegat.util.gui.RoundedCornerBorder;
import org.omegat.util.gui.Styles;

public class AlignPanelController {
    private final Aligner aligner;
    private final String defaultSaveDir;
    private boolean modified = false;
    private SRX customizedSRX;
    private Filters customizedFilters;
    private SwingWorker<?, ?> loader;
    private boolean doHighlight = true;
    private Pattern highlightPattern = Pattern.compile(Preferences.getPreferenceDefault("aligner_highlight_pattern", "\\d+"));
    private int ppRow = -1;
    private int ppCol = -1;
    private AlignPanel panel;
    private AlignMenuFrame frame;
    private Phase phase = Phase.ALIGN;
    static final Border FOCUS_BORDER = new MatteBorder(1, 1, 1, 1, new Color(7778280));
    private static final DataFlavor ARRAY2DFLAVOR = new DataFlavor(int[][].class, "2D int array");

    public AlignPanelController(Aligner aligner, String defaultSaveDir) {
        this.aligner = aligner;
        this.defaultSaveDir = defaultSaveDir;
    }

    public void show(Component parent) {
        this.frame = new AlignMenuFrame();
        this.frame.setTitle(OStrings.getString("ALIGNER_PANEL"));
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AlignPanelController.this.closeFrame(AlignPanelController.this.frame);
            }
        });
        this.panel = new AlignPanel();
        ActionListener comparisonListener = e -> {
            Aligner.ComparisonMode newValue = (Aligner.ComparisonMode)((Object)((Object)((JComboBox)e.getSource()).getSelectedItem()));
            if (newValue != this.aligner.comparisonMode && this.confirmReset(this.frame)) {
                this.aligner.comparisonMode = newValue;
                this.reloadBeads();
            } else {
                this.panel.comparisonComboBox.setSelectedItem((Object)this.aligner.comparisonMode);
            }
        };
        this.panel.comparisonComboBox.addActionListener(comparisonListener);
        this.panel.comparisonComboBox.setRenderer(new EnumRenderer("ALIGNER_ENUM_COMPARISON_MODE_"));
        ActionListener algorithmListener = e -> {
            Aligner.AlgorithmClass newValue = (Aligner.AlgorithmClass)((Object)((Object)((JComboBox)e.getSource()).getSelectedItem()));
            if (newValue != this.aligner.algorithmClass && this.confirmReset(this.frame)) {
                this.aligner.algorithmClass = newValue;
                this.reloadBeads();
            } else {
                this.panel.algorithmComboBox.setSelectedItem((Object)this.aligner.algorithmClass);
            }
        };
        this.panel.algorithmComboBox.addActionListener(algorithmListener);
        this.panel.algorithmComboBox.setRenderer(new EnumRenderer("ALIGNER_ENUM_ALGORITHM_CLASS_"));
        ActionListener calculatorListener = e -> {
            Aligner.CalculatorType newValue = (Aligner.CalculatorType)((Object)((Object)((JComboBox)e.getSource()).getSelectedItem()));
            if (newValue != this.aligner.calculatorType && this.confirmReset(this.frame)) {
                this.aligner.calculatorType = newValue;
                this.reloadBeads();
            } else {
                this.panel.calculatorComboBox.setSelectedItem((Object)this.aligner.calculatorType);
            }
        };
        this.panel.calculatorComboBox.addActionListener(calculatorListener);
        this.panel.calculatorComboBox.setRenderer(new EnumRenderer("ALIGNER_ENUM_CALCULATOR_TYPE_"));
        ActionListener counterListener = e -> {
            Aligner.CounterType newValue = (Aligner.CounterType)((Object)((Object)((JComboBox)e.getSource()).getSelectedItem()));
            if (newValue != this.aligner.counterType && this.confirmReset(this.frame)) {
                this.aligner.counterType = newValue;
                this.reloadBeads();
            } else {
                this.panel.counterComboBox.setSelectedItem((Object)this.aligner.counterType);
            }
        };
        this.panel.counterComboBox.addActionListener(counterListener);
        this.panel.counterComboBox.setRenderer(new EnumRenderer("ALIGNER_ENUM_COUNTER_TYPE_"));
        ActionListener segmentingListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean newValue = ((AbstractButton)e.getSource()).isSelected();
                if (newValue != ((AlignPanelController)AlignPanelController.this).aligner.segment && AlignPanelController.this.confirmReset(AlignPanelController.this.frame)) {
                    ((AlignPanelController)AlignPanelController.this).aligner.segment = newValue;
                    AlignPanelController.this.reloadBeads();
                } else {
                    ((AlignPanelController)AlignPanelController.this).panel.segmentingCheckBox.setSelected(((AlignPanelController)AlignPanelController.this).aligner.segment);
                    ((AlignPanelController)AlignPanelController.this).frame.segmentingItem.setSelected(((AlignPanelController)AlignPanelController.this).aligner.segment);
                }
            }
        };
        this.panel.segmentingCheckBox.addActionListener(segmentingListener);
        this.frame.segmentingItem.addActionListener(segmentingListener);
        ActionListener segmentingRulesListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegmentationCustomizer customizer;
                if (AlignPanelController.this.confirmReset(AlignPanelController.this.frame) && (customizer = new SegmentationCustomizer(false, SRX.getDefault(), Core.getSegmenter().getSRX(), null)).show(AlignPanelController.this.frame)) {
                    AlignPanelController.this.customizedSRX = customizer.getResult();
                    Core.setSegmenter(new Segmenter(AlignPanelController.this.customizedSRX));
                    AlignPanelController.this.reloadBeads();
                }
            }
        };
        this.panel.segmentingRulesButton.addActionListener(segmentingRulesListener);
        this.frame.segmentingRulesItem.addActionListener(segmentingRulesListener);
        ActionListener filterSettingsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FiltersCustomizer customizer;
                if (AlignPanelController.this.confirmReset(AlignPanelController.this.frame) && (customizer = new FiltersCustomizer(false, FilterMaster.createDefaultFiltersConfig(), Core.getFilterMaster().getConfig(), null)).show(AlignPanelController.this.frame)) {
                    AlignPanelController.this.customizedFilters = customizer.getResult();
                    Core.setFilterMaster(new FilterMaster(AlignPanelController.this.customizedFilters));
                    AlignPanelController.this.aligner.clearLoaded();
                    AlignPanelController.this.reloadBeads();
                }
            }
        };
        this.panel.fileFilterSettingsButton.addActionListener(filterSettingsListener);
        this.frame.fileFilterSettingsItem.addActionListener(filterSettingsListener);
        MultilineCellRenderer renderer = new MultilineCellRenderer();
        this.panel.table.setDefaultRenderer(Object.class, renderer);
        this.panel.table.setDefaultRenderer(Boolean.class, renderer);
        this.panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AlignPanelController.resizeRows(((AlignPanelController)AlignPanelController.this).panel.table);
            }
        });
        ActionListener oneAdjustListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = ((AlignPanelController)AlignPanelController.this).panel.table.getSelectedRows();
                int col = ((AlignPanelController)AlignPanelController.this).panel.table.getSelectedColumn();
                boolean up = e.getSource().equals(((AlignPanelController)AlignPanelController.this).panel.moveUpButton) || e.getSource().equals(((AlignPanelController)AlignPanelController.this).frame.moveUpItem);
                BeadTableModel model = (BeadTableModel)((AlignPanelController)AlignPanelController.this).panel.table.getModel();
                if ((e.getModifiers() & Java8Compat.getMenuShortcutKeyMaskEx()) != 0) {
                    int trgRow = up ? model.prevBeadFromRow(rows[0]) : model.nextBeadFromRow(rows[rows.length - 1]);
                    AlignPanelController.this.moveRows(rows, col, trgRow);
                } else {
                    int offset = up ? -1 : 1;
                    AlignPanelController.this.slideRows(rows, col, offset);
                }
            }
        };
        this.panel.moveUpButton.addActionListener(oneAdjustListener);
        this.frame.moveUpItem.addActionListener(oneAdjustListener);
        this.panel.moveDownButton.addActionListener(oneAdjustListener);
        this.frame.moveDownItem.addActionListener(oneAdjustListener);
        ActionListener mergeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int beads;
                int[] rows = ((AlignPanelController)AlignPanelController.this).panel.table.getSelectedRows();
                int col = ((AlignPanelController)AlignPanelController.this).panel.table.getSelectedColumn();
                BeadTableModel model = (BeadTableModel)((AlignPanelController)AlignPanelController.this).panel.table.getModel();
                if (rows.length == 1) {
                    rows = new int[]{rows[0], model.nextNonEmptyCell(rows[0], col)};
                }
                if ((beads = model.beadsInRowSpan(rows)) >= 1) {
                    if (beads == 1) {
                        AlignPanelController.this.mergeRows(rows, col);
                    } else {
                        AlignPanelController.this.moveRows(rows, col, rows[0]);
                    }
                }
            }
        };
        this.panel.mergeButton.addActionListener(mergeListener);
        this.frame.mergeItem.addActionListener(mergeListener);
        ActionListener splitListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = ((AlignPanelController)AlignPanelController.this).panel.table.getSelectedRows();
                int col = ((AlignPanelController)AlignPanelController.this).panel.table.getSelectedColumn();
                BeadTableModel model = (BeadTableModel)((AlignPanelController)AlignPanelController.this).panel.table.getModel();
                int beads = model.beadsInRowSpan(rows);
                if (beads == 1) {
                    if (rows.length == 1) {
                        AlignPanelController.this.splitRow(rows[0], col);
                    } else {
                        AlignPanelController.this.splitBead(rows, col);
                    }
                }
            }
        };
        this.panel.splitButton.addActionListener(splitListener);
        this.frame.splitItem.addActionListener(splitListener);
        ActionListener editListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int row = ((AlignPanelController)AlignPanelController.this).panel.table.getSelectedRow();
                int col = ((AlignPanelController)AlignPanelController.this).panel.table.getSelectedColumn();
                AlignPanelController.this.editRow(row, col);
            }
        };
        this.panel.editButton.addActionListener(editListener);
        this.frame.editItem.addActionListener(editListener);
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AlignPanelController.this.updateCommandAvailability(AlignPanelController.this.panel, AlignPanelController.this.frame);
            }
        };
        this.panel.table.getColumnModel().getSelectionModel().addListSelectionListener(selectionListener);
        this.panel.table.getSelectionModel().addListSelectionListener(selectionListener);
        ActionListener saveListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block4: {
                    JFileChooser chooser;
                    File file;
                    if (!AlignPanelController.this.confirmSaveTMX(AlignPanelController.this.panel)) {
                        return;
                    }
                    do {
                        chooser = new JFileChooser();
                        chooser.setSelectedFile(new File(AlignPanelController.this.defaultSaveDir, AlignPanelController.this.getOutFileName()));
                        chooser.setDialogTitle(OStrings.getString("ALIGNER_PANEL_DIALOG_SAVE"));
                        if (0 != chooser.showSaveDialog(AlignPanelController.this.frame)) break block4;
                    } while ((file = chooser.getSelectedFile()).isFile() && 0 != JOptionPane.showConfirmDialog(AlignPanelController.this.frame, StringUtil.format(OStrings.getString("ALIGNER_PANEL_DIALOG_OVERWRITE"), file.getName()), OStrings.getString("ALIGNER_DIALOG_WARNING_TITLE"), 2));
                    List<MutableBead> beads = ((BeadTableModel)((AlignPanelController)AlignPanelController.this).panel.table.getModel()).getData();
                    try {
                        AlignPanelController.this.aligner.writePairsToTMX(file, MutableBead.beadsToEntries(((AlignPanelController)AlignPanelController.this).aligner.srcLang, ((AlignPanelController)AlignPanelController.this).aligner.trgLang, beads));
                        AlignPanelController.this.modified = false;
                    }
                    catch (Exception ex) {
                        Log.log(ex);
                        JOptionPane.showMessageDialog(AlignPanelController.this.frame, OStrings.getString("ALIGNER_PANEL_SAVE_ERROR"), OStrings.getString("ERROR_TITLE"), 0);
                    }
                }
            }
        };
        this.panel.saveButton.addActionListener(saveListener);
        this.frame.saveItem.addActionListener(saveListener);
        ActionListener resetListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AlignPanelController.this.confirmReset(AlignPanelController.this.frame)) {
                    if (AlignPanelController.this.phase == Phase.ALIGN) {
                        AlignPanelController.this.aligner.restoreDefaults();
                    }
                    AlignPanelController.this.reloadBeads();
                }
            }
        };
        this.panel.resetButton.addActionListener(resetListener);
        this.frame.resetItem.addActionListener(resetListener);
        ActionListener reloadListener = e -> {
            if (this.confirmReset(this.frame)) {
                this.aligner.clearLoaded();
                this.reloadBeads();
            }
        };
        this.frame.reloadItem.addActionListener(reloadListener);
        ActionListener removeTagsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean newValue = ((AbstractButton)e.getSource()).isSelected();
                if (newValue != ((AlignPanelController)AlignPanelController.this).aligner.removeTags && AlignPanelController.this.confirmReset(AlignPanelController.this.frame)) {
                    ((AlignPanelController)AlignPanelController.this).aligner.removeTags = newValue;
                    AlignPanelController.this.aligner.clearLoaded();
                    AlignPanelController.this.reloadBeads();
                } else {
                    ((AlignPanelController)AlignPanelController.this).panel.removeTagsCheckBox.setSelected(((AlignPanelController)AlignPanelController.this).aligner.removeTags);
                    ((AlignPanelController)AlignPanelController.this).frame.removeTagsItem.setSelected(((AlignPanelController)AlignPanelController.this).aligner.removeTags);
                }
            }
        };
        this.panel.removeTagsCheckBox.addActionListener(removeTagsListener);
        this.frame.removeTagsItem.addActionListener(removeTagsListener);
        this.panel.continueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignPanelController.this.phase = Phase.EDIT;
                AlignPanelController.this.updatePanel();
            }
        });
        ActionListener highlightListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignPanelController.this.doHighlight = ((AbstractButton)e.getSource()).isSelected();
                AlignPanelController.this.updateHighlight();
            }
        };
        this.panel.highlightCheckBox.addActionListener(highlightListener);
        this.frame.highlightItem.addActionListener(highlightListener);
        ActionListener highlightPatternListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternPanelController patternEditor = new PatternPanelController(AlignPanelController.this.highlightPattern);
                AlignPanelController.this.highlightPattern = patternEditor.show(AlignPanelController.this.frame);
                Preferences.setPreference("aligner_highlight_pattern", AlignPanelController.this.highlightPattern.pattern());
                AlignPanelController.this.updateHighlight();
            }
        };
        this.panel.highlightPatternButton.addActionListener(highlightPatternListener);
        this.frame.highlightPatternItem.addActionListener(highlightPatternListener);
        this.frame.markAcceptedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignPanelController.this.setStatus(MutableBead.Status.ACCEPTED, ((AlignPanelController)AlignPanelController.this).panel.table.getSelectedRows());
            }
        });
        this.frame.markNeedsReviewItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignPanelController.this.setStatus(MutableBead.Status.NEEDS_REVIEW, ((AlignPanelController)AlignPanelController.this).panel.table.getSelectedRows());
            }
        });
        this.frame.clearMarkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignPanelController.this.setStatus(MutableBead.Status.DEFAULT, ((AlignPanelController)AlignPanelController.this).panel.table.getSelectedRows());
            }
        });
        this.frame.toggleSelectedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignPanelController.this.toggleEnabled(((AlignPanelController)AlignPanelController.this).panel.table.getSelectedRows());
            }
        });
        this.frame.closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignPanelController.this.closeFrame(AlignPanelController.this.frame);
            }
        });
        this.frame.keepAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignPanelController.this.toggleAllEnabled(true);
            }
        });
        this.frame.keepNoneItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignPanelController.this.toggleAllEnabled(false);
            }
        });
        this.frame.realignPendingItem.addActionListener(e -> this.realignPending());
        this.frame.pinpointAlignStartItem.addActionListener(e -> {
            this.phase = Phase.PINPOINT;
            this.ppRow = this.panel.table.getSelectedRow();
            this.ppCol = this.panel.table.getSelectedColumn();
            this.panel.table.clearSelection();
            this.updatePanel();
        });
        this.frame.pinpointAlignEndItem.addActionListener(e -> this.pinpointAlign(this.panel.table.getSelectedRow(), this.panel.table.getSelectedColumn()));
        this.frame.pinpointAlignCancelItem.addActionListener(e -> {
            this.phase = Phase.EDIT;
            this.ppRow = -1;
            this.ppCol = -1;
            this.panel.table.repaint();
            this.updatePanel();
        });
        this.panel.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AlignPanelController.this.phase == Phase.PINPOINT) {
                    JTable table = (JTable)e.getSource();
                    int row = table.rowAtPoint(e.getPoint());
                    int col = table.columnAtPoint(e.getPoint());
                    AlignPanelController.this.pinpointAlign(row, col);
                }
            }
        });
        this.frame.resetItem.setAccelerator(KeyStroke.getKeyStroke(82, Java8Compat.getMenuShortcutKeyMaskEx() | 0x40));
        this.frame.realignPendingItem.setAccelerator(KeyStroke.getKeyStroke(82, Java8Compat.getMenuShortcutKeyMaskEx()));
        this.frame.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, Java8Compat.getMenuShortcutKeyMaskEx()));
        this.frame.closeItem.setAccelerator(KeyStroke.getKeyStroke(87, Java8Compat.getMenuShortcutKeyMaskEx()));
        AlignPanelController.setKeyboardShortcut(this.panel.table, "selectNextRow", 'n');
        AlignPanelController.setKeyboardShortcut(this.panel.table, "selectNextRowExtendSelection", 'N');
        AlignPanelController.setKeyboardShortcut(this.panel.table, "selectPreviousRow", 'p');
        AlignPanelController.setKeyboardShortcut(this.panel.table, "selectPreviousRowExtendSelection", 'P');
        AlignPanelController.setKeyboardShortcut(this.panel.table, "selectNextColumn", 'f');
        AlignPanelController.setKeyboardShortcut(this.panel.table, "selectNextColumnExtendSelection", 'F');
        AlignPanelController.setKeyboardShortcut(this.panel.table, "selectPreviousColumn", 'b');
        AlignPanelController.setKeyboardShortcut(this.panel.table, "selectPreviousColumnExtendSelection", 'B');
        this.panel.table.setTransferHandler(new AlignTransferHandler());
        this.panel.table.addPropertyChangeListener("dropLocation", new DropLocationListener());
        this.panel.table.setFont(Core.getMainWindow().getApplicationFont());
        CoreEvents.registerFontChangedEventListener(this.panel.table::setFont);
        this.updateHighlight();
        this.updatePanel();
        this.reloadBeads();
        this.frame.add(this.panel);
        this.frame.pack();
        this.frame.setMinimumSize(this.frame.getSize());
        this.frame.setLocationRelativeTo(parent);
        this.frame.setVisible(true);
    }

    private static void setKeyboardShortcut(JComponent comp, Object actionName, char stroke) {
        comp.getInputMap(2).put(KeyStroke.getKeyStroke(stroke), actionName);
    }

    private static void resizeRows(JTable table) {
        for (int row = 0; row < table.getRowCount(); ++row) {
            int max = 0;
            for (int col = 1; col < table.getColumnCount(); ++col) {
                int colWidth = table.getColumnModel().getColumn(col).getWidth();
                TableCellRenderer cellRenderer = table.getCellRenderer(row, col);
                Component c = table.prepareRenderer(cellRenderer, row, col);
                c.setBounds(0, 0, colWidth, Integer.MAX_VALUE);
                int height = c.getPreferredSize().height;
                max = Math.max(max, height);
            }
            table.setRowHeight(row, max);
        }
    }

    private void slideRows(int[] rows, int col, int offset) {
        this.modified = true;
        Rectangle initialRect = this.panel.table.getVisibleRect();
        this.panel.table.clearSelection();
        BeadTableModel model = (BeadTableModel)this.panel.table.getModel();
        List<Integer> realRows = model.realCellsInRowSpan(col, rows);
        int[] resultRows = model.slide(realRows, col, offset);
        int selStart = resultRows[0];
        int selEnd = resultRows[1];
        if (selStart != selEnd) {
            while (offset < 0 && !model.canMove(selStart, col, true)) {
                ++selStart;
            }
            while (offset > 0 && !model.canMove(selEnd, col, false)) {
                --selEnd;
            }
        }
        this.panel.table.changeSelection(selStart, col, false, false);
        this.panel.table.changeSelection(selEnd, col, false, true);
        this.ensureSelectionVisible(initialRect);
    }

    private void moveRows(int[] rows, int col, int trgRow) {
        this.modified = true;
        Rectangle initialRect = this.panel.table.getVisibleRect();
        this.panel.table.clearSelection();
        BeadTableModel model = (BeadTableModel)this.panel.table.getModel();
        List<Integer> realRows = model.realCellsInRowSpan(col, rows);
        int[] resultRows = model.move(realRows, col, trgRow);
        this.panel.table.changeSelection(resultRows[0], col, false, false);
        this.panel.table.changeSelection(resultRows[1], col, false, true);
        this.ensureSelectionVisible(initialRect);
    }

    private void mergeRows(int[] rows, int col) {
        this.modified = true;
        Rectangle initialRect = this.panel.table.getVisibleRect();
        this.panel.table.clearSelection();
        BeadTableModel model = (BeadTableModel)this.panel.table.getModel();
        List<Integer> realRows = model.realCellsInRowSpan(col, rows);
        int resultRow = model.mergeRows(realRows, col);
        this.panel.table.changeSelection(resultRow, col, false, false);
        this.ensureSelectionVisible(initialRect);
    }

    private void splitRow(int row, int col) {
        String reference;
        BeadTableModel model = (BeadTableModel)this.panel.table.getModel();
        if (!model.isEditableColumn(col)) {
            throw new IllegalArgumentException();
        }
        String text = this.panel.table.getValueAt(row, col).toString();
        SplittingPanelController splitter = new SplittingPanelController(text, reference = (String)this.panel.table.getValueAt(row, col == 1 ? 2 : 1));
        String[] split = splitter.show(SwingUtilities.getWindowAncestor(this.panel.table));
        if (split.length == 1) {
            return;
        }
        this.modified = true;
        Rectangle initialRect = this.panel.table.getVisibleRect();
        this.panel.table.clearSelection();
        int[] resultRows = model.splitRow(row, col, split);
        this.panel.table.changeSelection(resultRows[0], col, false, false);
        this.panel.table.changeSelection(resultRows[resultRows.length - 1], col, false, true);
        this.ensureSelectionVisible(initialRect);
    }

    private void splitBead(int[] rows, int col) {
        this.modified = true;
        this.panel.table.clearSelection();
        BeadTableModel model = (BeadTableModel)this.panel.table.getModel();
        Rectangle initialRect = this.panel.table.getVisibleRect();
        model.splitBead(rows);
        this.panel.table.changeSelection(rows[0], col, false, false);
        this.panel.table.changeSelection(rows[rows.length - 1], col, false, true);
        this.ensureSelectionVisible(initialRect);
    }

    private void editRow(int row, int col) {
        String text = this.panel.table.getValueAt(row, col).toString();
        EditingPanelController splitter = new EditingPanelController(text);
        String newText = splitter.show(SwingUtilities.getWindowAncestor(this.panel.table));
        if (newText == null || text.equals(newText)) {
            return;
        }
        this.modified = true;
        Rectangle initialRect = this.panel.table.getVisibleRect();
        this.panel.table.clearSelection();
        BeadTableModel model = (BeadTableModel)this.panel.table.getModel();
        model.editRow(row, col, newText);
        this.panel.table.changeSelection(row, col, false, false);
        this.ensureSelectionVisible(initialRect);
    }

    private void realignPending() {
        BeadTableModel model = (BeadTableModel)this.panel.table.getModel();
        List<MutableBead> data = model.getData();
        ArrayList<MutableBead> toAlign = new ArrayList<MutableBead>();
        ArrayList<MutableBead> result = new ArrayList<MutableBead>(data.size());
        for (MutableBead bead : data) {
            if (bead.status == MutableBead.Status.ACCEPTED) {
                if (!toAlign.isEmpty()) {
                    result.addAll(this.aligner.doAlign(toAlign));
                    toAlign.clear();
                }
                result.add(bead);
                continue;
            }
            toAlign.add(bead);
        }
        if (!toAlign.isEmpty()) {
            result.addAll(this.aligner.doAlign(toAlign));
        }
        this.modified = true;
        model.replaceData(result);
        this.panel.table.repaint();
        AlignPanelController.resizeRows(this.panel.table);
    }

    private void pinpointAlign(int row, int col) {
        if (row == this.ppRow || col == this.ppCol) {
            return;
        }
        this.modified = true;
        Rectangle initialRect = this.panel.table.getVisibleRect();
        BeadTableModel model = (BeadTableModel)this.panel.table.getModel();
        IntStream.of(this.ppRow, row).forEach(i -> {
            List<Integer> rowspan = model.getRowExtentsForBeadAtRow(i);
            if (rowspan.size() > 1) {
                model.splitBead(rowspan.stream().mapToInt(Integer::intValue).toArray());
            }
        });
        int relocateCol = this.ppRow < row ? this.ppCol : col;
        ArrayList<String> toRelocate = new ArrayList<String>();
        for (int i2 = Math.min(this.ppRow, row); i2 <= Math.max(this.ppRow, row); ++i2) {
            String line = model.removeLine(i2, relocateCol);
            if (line == null) continue;
            toRelocate.add(line);
        }
        int resultRow = model.insertLines(toRelocate, Math.max(this.ppRow, row), relocateCol);
        model.setStatusAtRow(resultRow, MutableBead.Status.ACCEPTED);
        this.panel.table.changeSelection(resultRow, this.ppCol, false, false);
        this.panel.table.changeSelection(resultRow, col, false, true);
        this.ppRow = -1;
        this.ppCol = -1;
        this.phase = Phase.EDIT;
        this.ensureSelectionVisible(initialRect);
        this.updatePanel();
    }

    private void toggleEnabled(int ... rows) {
        if (rows.length == 0) {
            return;
        }
        this.modified = true;
        BeadTableModel model = (BeadTableModel)this.panel.table.getModel();
        model.toggleBeadsAtRows(rows);
        this.panel.table.repaint();
    }

    private void toggleAllEnabled(boolean value) {
        this.modified = true;
        BeadTableModel model = (BeadTableModel)this.panel.table.getModel();
        model.toggleAllBeads(value);
        this.panel.table.repaint();
    }

    private void setStatus(MutableBead.Status status, int ... rows) {
        if (rows.length == 0) {
            return;
        }
        this.modified = true;
        BeadTableModel model = (BeadTableModel)this.panel.table.getModel();
        for (int row : rows) {
            model.setStatusAtRow(row, status);
        }
        int nextBeadRow = model.nextBeadFromRow(rows[rows.length - 1]);
        if (nextBeadRow != -1) {
            int[] cols = this.panel.table.getSelectedColumns();
            this.panel.table.changeSelection(nextBeadRow, cols[0], false, false);
            this.panel.table.changeSelection(nextBeadRow, cols[cols.length - 1], false, true);
            this.ensureSelectionVisible(this.panel.table.getVisibleRect());
        }
    }

    private void ensureSelectionVisible(Rectangle initialView) {
        this.panel.table.repaint();
        AlignPanelController.resizeRows(this.panel.table);
        int[] rows = this.panel.table.getSelectedRows();
        int[] cols = this.panel.table.getSelectedColumns();
        Rectangle selectionRect = this.panel.table.getCellRect(rows[0], cols[0], true).union(this.panel.table.getCellRect(rows[rows.length - 1], cols[cols.length - 1], true));
        this.panel.table.scrollRectToVisible(initialView);
        this.panel.table.scrollRectToVisible(selectionRect);
    }

    private boolean confirmReset(Component comp) {
        if (!this.modified) {
            return true;
        }
        return 0 == JOptionPane.showConfirmDialog(comp, OStrings.getString("ALIGNER_PANEL_RESET_WARNING_MESSAGE"), OStrings.getString("ALIGNER_DIALOG_WARNING_TITLE"), 2);
    }

    private void reloadBeads() {
        if (this.loader != null) {
            this.loader.cancel(true);
        }
        this.phase = Phase.ALIGN;
        this.panel.progressBar.setVisible(true);
        this.panel.continueButton.setEnabled(false);
        this.panel.controlsPanel.setVisible(false);
        this.loader = new SwingWorker<List<MutableBead>, Object>(){

            @Override
            protected List<MutableBead> doInBackground() throws Exception {
                return AlignPanelController.this.aligner.alignImpl().filter(o -> !this.isCancelled()).map(MutableBead::new).collect(Collectors.toList());
            }

            @Override
            protected void done() {
                List beads = null;
                try {
                    beads = (List)this.get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (Exception e) {
                    Log.log(e);
                    JOptionPane.showMessageDialog(AlignPanelController.this.panel, OStrings.getString("ALIGNER_ERROR_LOADING"), OStrings.getString("ERROR_TITLE"), 0);
                }
                ((AlignPanelController)AlignPanelController.this).panel.continueButton.setEnabled(true);
                ((AlignPanelController)AlignPanelController.this).panel.progressBar.setVisible(false);
                ((AlignPanelController)AlignPanelController.this).panel.comparisonComboBox.setModel(new DefaultComboBoxModel<Aligner.ComparisonMode>(((AlignPanelController)AlignPanelController.this).aligner.allowedModes.toArray(new Aligner.ComparisonMode[0])));
                String distanceValue = null;
                if (beads != null) {
                    double avgDist = MutableBead.calculateAvgDist(beads);
                    distanceValue = StringUtil.format(OStrings.getString("ALIGNER_PANEL_LABEL_AVGSCORE"), avgDist == 9.223372036854776E18 ? "-" : String.format("%.3f", avgDist));
                    ((AlignPanelController)AlignPanelController.this).panel.table.setModel(new BeadTableModel(beads));
                    for (int i = 0; i < 1; ++i) {
                        TableColumn col = ((AlignPanelController)AlignPanelController.this).panel.table.getColumnModel().getColumn(i);
                        col.setMaxWidth(col.getWidth());
                    }
                    AlignPanelController.this.modified = false;
                }
                ((AlignPanelController)AlignPanelController.this).panel.averageDistanceLabel.setText(distanceValue);
                AlignPanelController.this.updatePanel();
            }
        };
        this.loader.execute();
    }

    private void updatePanel() {
        this.panel.comparisonComboBox.setSelectedItem((Object)this.aligner.comparisonMode);
        this.panel.algorithmComboBox.setSelectedItem((Object)this.aligner.algorithmClass);
        this.panel.calculatorComboBox.setSelectedItem((Object)this.aligner.calculatorType);
        this.panel.counterComboBox.setSelectedItem((Object)this.aligner.counterType);
        this.panel.segmentingCheckBox.setSelected(this.aligner.segment);
        this.frame.segmentingItem.setSelected(this.aligner.segment);
        this.panel.segmentingRulesButton.setEnabled(this.aligner.segment);
        this.frame.segmentingRulesItem.setEnabled(this.aligner.segment);
        this.panel.removeTagsCheckBox.setSelected(this.aligner.removeTags);
        this.frame.removeTagsItem.setSelected(this.aligner.removeTags);
        this.panel.advancedPanel.setVisible(this.phase == Phase.ALIGN);
        this.panel.segmentationControlsPanel.setVisible(this.phase == Phase.ALIGN);
        this.panel.filteringControlsPanel.setVisible(this.phase == Phase.ALIGN);
        this.panel.continueButton.setVisible(this.phase == Phase.ALIGN);
        this.panel.controlsPanel.setVisible(this.phase != Phase.ALIGN);
        this.panel.controlsPanel.setEnabled(this.phase == Phase.EDIT);
        this.panel.saveButton.setVisible(this.phase != Phase.ALIGN);
        this.panel.saveButton.setEnabled(this.phase == Phase.EDIT);
        String instructions = null;
        switch (this.phase) {
            case ALIGN: {
                instructions = OStrings.getString("ALIGNER_PANEL_ALIGN_PHASE_HELP");
                break;
            }
            case EDIT: {
                instructions = OStrings.getString("ALIGNER_PANEL_EDIT_PHASE_HELP");
                break;
            }
            case PINPOINT: {
                instructions = OStrings.getString("ALIGNER_PANEL_PINPOINT_PHASE_HELP");
            }
        }
        this.panel.instructionsLabel.setText(instructions);
        this.frame.editMenu.setEnabled(this.phase != Phase.ALIGN);
        for (Component c : this.frame.editMenu.getComponents()) {
            c.setEnabled(this.phase == Phase.EDIT);
        }
        this.frame.optionsMenu.setEnabled(this.phase == Phase.ALIGN);
        this.frame.saveItem.setEnabled(this.phase == Phase.EDIT);
        this.panel.table.setCursor(Cursor.getPredefinedCursor(this.phase == Phase.PINPOINT ? 1 : 0));
        this.frame.pinpointAlignStartItem.setVisible(this.phase != Phase.PINPOINT);
        this.frame.pinpointAlignEndItem.setVisible(this.phase == Phase.PINPOINT);
        this.frame.pinpointAlignCancelItem.setVisible(this.phase == Phase.PINPOINT);
        this.frame.pinpointAlignCancelItem.setEnabled(this.phase == Phase.PINPOINT);
        JButton defaultButton = this.phase == Phase.ALIGN ? this.panel.continueButton : (this.phase == Phase.EDIT ? this.panel.saveButton : null);
        this.frame.getRootPane().setDefaultButton(defaultButton);
        this.updateCommandAvailability(this.panel, this.frame);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AlignPanelController.resizeRows(((AlignPanelController)AlignPanelController.this).panel.table);
            }
        });
    }

    private void updateHighlight() {
        this.panel.highlightCheckBox.setSelected(this.doHighlight);
        this.frame.highlightItem.setSelected(this.doHighlight);
        this.panel.highlightPatternButton.setEnabled(this.doHighlight);
        this.frame.highlightPatternItem.setEnabled(this.doHighlight);
        this.panel.table.repaint();
    }

    private void updateCommandAvailability(AlignPanel panel, AlignMenuFrame frame) {
        if (!(panel.table.getModel() instanceof BeadTableModel)) {
            return;
        }
        int[] rows = panel.table.getSelectedRows();
        int[] cols = panel.table.getSelectedColumns();
        int col = cols.length > 0 ? cols[0] : -1;
        BeadTableModel model = (BeadTableModel)panel.table.getModel();
        List<Integer> realRows = model.realCellsInRowSpan(col, rows);
        boolean enabled = this.phase == Phase.EDIT && !realRows.isEmpty() && cols.length == 1 && model.isEditableColumn(col);
        boolean canUp = enabled && model.canMove(realRows.get(0), col, true);
        boolean canDown = enabled && model.canMove(realRows.get(realRows.size() - 1), col, false);
        int beads = model.beadsInRowSpan(rows);
        boolean canSplit = realRows.size() == 1 && rows.length == 1 || !realRows.isEmpty() && beads == 1;
        boolean canMerge = realRows.size() > 1 || realRows.size() == 1 && rows.length == 1 && realRows.get(0) < panel.table.getRowCount() - 1;
        boolean canEdit = realRows.size() == 1;
        panel.moveDownButton.setEnabled(enabled && canDown);
        frame.moveDownItem.setEnabled(enabled && canDown);
        panel.moveUpButton.setEnabled(enabled && canUp);
        frame.moveUpItem.setEnabled(enabled && canUp);
        panel.splitButton.setEnabled(enabled && canSplit);
        frame.splitItem.setEnabled(enabled && canSplit);
        panel.mergeButton.setEnabled(enabled && canMerge);
        frame.mergeItem.setEnabled(enabled && canMerge);
        panel.editButton.setEnabled(enabled && canEdit);
        frame.editItem.setEnabled(enabled && canEdit);
        frame.pinpointAlignStartItem.setEnabled(enabled && rows.length == 1);
        frame.pinpointAlignEndItem.setEnabled(this.phase == Phase.PINPOINT && rows.length == 1 && cols.length == 1 && realRows.size() == 1 && realRows.get(0) != this.ppRow && col != this.ppCol && model.isEditableColumn(col));
    }

    private String getOutFileName() {
        String trg;
        String src = FilenameUtils.getBaseName((String)this.aligner.srcFile);
        if (src.equals(trg = FilenameUtils.getBaseName((String)this.aligner.trgFile))) {
            return src + "_" + this.aligner.srcLang.getLanguage() + "_" + this.aligner.trgLang.getLanguage() + ".tmx";
        }
        return src + "_" + trg + ".tmx";
    }

    private void closeFrame(JFrame frame) {
        if (this.confirmReset(frame)) {
            frame.setVisible(false);
            this.confirmSaveSRX(frame);
            this.confirmSaveFilters(frame);
            frame.dispose();
        }
    }

    private void confirmSaveSRX(Component comp) {
        if (Core.getMainWindow() == null || this.customizedSRX == null) {
            return;
        }
        if (0 == JOptionPane.showConfirmDialog(comp, OStrings.getString("ALIGNER_DIALOG_SEGMENTATION_CONFIRM_MESSAGE"), OStrings.getString("ALIGNER_DIALOG_CONFIRM_TITLE"), 2)) {
            if (Core.getProject().isProjectLoaded() && Core.getProject().getProjectProperties().getProjectSRX() != null) {
                Core.getProject().getProjectProperties().setProjectSRX(this.customizedSRX);
                try {
                    Core.getProject().saveProjectProperties();
                }
                catch (Exception ex) {
                    Log.log(ex);
                    JOptionPane.showMessageDialog(comp, OStrings.getString("CT_ERROR_SAVING_PROJ"), OStrings.getString("ERROR_TITLE"), 0);
                }
                ProjectUICommands.promptReload();
            } else {
                Preferences.setSRX(this.customizedSRX);
            }
        }
    }

    private void confirmSaveFilters(Component comp) {
        if (Core.getMainWindow() == null || this.customizedFilters == null) {
            return;
        }
        if (0 == JOptionPane.showConfirmDialog(comp, OStrings.getString("ALIGNER_DIALOG_FILTERS_CONFIRM_MESSAGE"), OStrings.getString("ALIGNER_DIALOG_CONFIRM_TITLE"), 2)) {
            if (Core.getProject().isProjectLoaded() && Core.getProject().getProjectProperties().getProjectFilters() != null) {
                Core.getProject().getProjectProperties().setProjectFilters(this.customizedFilters);
                try {
                    Core.getProject().saveProjectProperties();
                }
                catch (Exception ex) {
                    Log.log(ex);
                    JOptionPane.showMessageDialog(comp, OStrings.getString("CT_ERROR_SAVING_PROJ"), OStrings.getString("ERROR_TITLE"), 0);
                }
                ProjectUICommands.promptReload();
            } else {
                Preferences.setFilters(this.customizedFilters);
            }
        }
    }

    private boolean confirmSaveTMX(AlignPanel panel) {
        BeadTableModel model = (BeadTableModel)panel.table.getModel();
        boolean needsReview = false;
        for (MutableBead bead : model.getData()) {
            if (bead.status != MutableBead.Status.NEEDS_REVIEW) continue;
            needsReview = true;
            break;
        }
        if (needsReview) {
            return 0 == JOptionPane.showConfirmDialog(panel, OStrings.getString("ALIGNER_DIALOG_NEEDSREVIEW_CONFIRM_MESSAGE"), OStrings.getString("ALIGNER_DIALOG_CONFIRM_TITLE"), 2);
        }
        return true;
    }

    static class EnumRenderer<T extends Enum<?>>
    extends DelegatingComboBoxRenderer<T, String> {
        private final String keyPrefix;

        EnumRenderer(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        @Override
        protected String getDisplayText(T value) {
            if (value == null) {
                return null;
            }
            try {
                return OStrings.getString(this.keyPrefix + ((Enum)value).name());
            }
            catch (MissingResourceException ex) {
                return ((Enum)value).name();
            }
        }
    }

    static class DropLocationListener
    implements PropertyChangeListener {
        private static final int ERASE_MARGIN = 5;
        private static final int INSET_MARGIN = 3;
        private static final Border BORDER = new RoundedCornerBorder(8, Color.BLUE, 4, 2);

        DropLocationListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Rectangle rect;
            JTable.DropLocation newVal;
            JTable.DropLocation oldVal = (JTable.DropLocation)evt.getOldValue();
            if (this.equals(oldVal, newVal = (JTable.DropLocation)evt.getNewValue())) {
                return;
            }
            final JTable table = (JTable)evt.getSource();
            if (oldVal != null) {
                rect = this.rectForTarget(table, oldVal);
                rect.grow(5, 5);
                table.paintImmediately(rect);
            }
            if (newVal != null) {
                rect = this.rectForTarget(table, newVal);
                rect.grow(3, 3);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BORDER.paintBorder(table, table.getGraphics(), rect.x, rect.y, rect.width, rect.height);
                    }
                });
            }
        }

        private boolean equals(JTable.DropLocation oldVal, JTable.DropLocation newVal) {
            if (oldVal == newVal) {
                return true;
            }
            if (oldVal == null || newVal == null) {
                return false;
            }
            return oldVal.getColumn() == newVal.getColumn() && oldVal.getRow() == newVal.getRow();
        }

        private Rectangle rectForTarget(JTable table, JTable.DropLocation loc) {
            BeadTableModel model = (BeadTableModel)table.getModel();
            List<Integer> rows = model.getRowExtentsForBeadAtRow(loc.getRow());
            return table.getCellRect(rows.get(0), 1, true).union(table.getCellRect(rows.get(rows.size() - 1), 2, true));
        }
    }

    static class TableSelection
    implements Transferable {
        private static final DataFlavor[] FLAVORS = new DataFlavor[]{AlignPanelController.access$3100()};
        private final int[] rows;
        private final int[] cols;

        TableSelection(int[] rows, int[] cols) {
            this.rows = rows;
            this.cols = cols;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return ARRAY2DFLAVOR.equals(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return FLAVORS;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (ARRAY2DFLAVOR.equals(flavor)) {
                return new int[][]{this.rows, this.cols};
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    class AlignTransferHandler
    extends TransferHandler {
        AlignTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (!(c instanceof JTable)) {
                return null;
            }
            JTable table = (JTable)c;
            return new TableSelection(table.getSelectedRows(), table.getSelectedColumns());
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (AlignPanelController.this.phase != Phase.EDIT) {
                return false;
            }
            if (!support.isDataFlavorSupported(ARRAY2DFLAVOR)) {
                return false;
            }
            try {
                List<Integer> realRows;
                int col;
                Object o = support.getTransferable().getTransferData(ARRAY2DFLAVOR);
                int[][] sel = (int[][])o;
                int[] rows = sel[0];
                if (rows.length < 1) {
                    return false;
                }
                int[] cols = sel[1];
                if (cols.length != 1) {
                    return false;
                }
                JTable table = (JTable)support.getComponent();
                BeadTableModel model = (BeadTableModel)table.getModel();
                if (!model.isEditableColumn(col = cols[0])) {
                    return false;
                }
                JTable.DropLocation dloc = (JTable.DropLocation)support.getDropLocation();
                if (dloc.getColumn() != col) {
                    return false;
                }
                int trgRow = dloc.getRow();
                if (trgRow < (realRows = model.realCellsInRowSpan(col, rows)).get(0)) {
                    return model.canMoveTo(trgRow, realRows.get(0), col, true);
                }
                if (trgRow > realRows.get(realRows.size() - 1)) {
                    return model.canMoveTo(trgRow, realRows.get(realRows.size() - 1), col, false);
                }
            }
            catch (Exception e) {
                Log.log(e);
            }
            return false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            try {
                Object o = support.getTransferable().getTransferData(ARRAY2DFLAVOR);
                int[][] sel = (int[][])o;
                int[] rows = sel[0];
                int[] cols = sel[1];
                int col = cols[0];
                JTable.DropLocation dloc = (JTable.DropLocation)support.getDropLocation();
                int trgRow = dloc.getRow();
                AlignPanelController.this.moveRows(rows, col, trgRow);
                return true;
            }
            catch (Exception e) {
                Log.log(e);
                return false;
            }
        }
    }

    class BeadTableModel
    extends AbstractTableModel {
        static final int COL_CHECKBOX = 0;
        static final int COL_SRC = 1;
        static final int COL_TRG = 2;
        private final List<MutableBead> data;
        List<Float> rowToDistance;
        List<MutableBead> rowToBead;
        List<String> rowToSourceLine;
        List<String> rowToTargetLine;

        BeadTableModel(List<MutableBead> data) {
            this.data = data;
            this.makeCache();
        }

        private void makeCache() {
            for (int i = 0; i < this.data.size(); ++i) {
                MutableBead bead = this.data.get(i);
                if (bead.isEmpty()) {
                    this.data.remove(i--);
                    continue;
                }
                while (bead.sourceLines.size() > 1 && bead.targetLines.size() > 1) {
                    bead = this.splitBeadByCount(bead, 1);
                    this.data.add(++i, bead);
                }
            }
            ArrayList<Float> rowToDistance = new ArrayList<Float>();
            ArrayList<MutableBead> rowToBead = new ArrayList<MutableBead>();
            ArrayList<String> rowToSourceLine = new ArrayList<String>();
            ArrayList<String> rowToTargetLine = new ArrayList<String>();
            for (MutableBead bead : this.data) {
                int beadRows = Math.max(bead.sourceLines.size(), bead.targetLines.size());
                for (int i = 0; i < beadRows; ++i) {
                    rowToDistance.add(Float.valueOf(bead.score));
                    rowToBead.add(bead);
                    rowToSourceLine.add(i < bead.sourceLines.size() ? bead.sourceLines.get(i) : null);
                    rowToTargetLine.add(i < bead.targetLines.size() ? bead.targetLines.get(i) : null);
                }
            }
            this.rowToDistance = rowToDistance;
            this.rowToBead = rowToBead;
            this.rowToSourceLine = rowToSourceLine;
            this.rowToTargetLine = rowToTargetLine;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return AlignPanelController.this.phase == Phase.EDIT && column == 0 && this.getValueAt(row, column) != null;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.rowToBead.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case -3: {
                    return Integer.class;
                }
                case -2: {
                    return Integer.class;
                }
                case -1: {
                    return Integer.class;
                }
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case -3: {
                    return OStrings.getString("ALIGNER_PANEL_TABLE_COL_ROW");
                }
                case -2: {
                    return OStrings.getString("ALIGNER_PANEL_TABLE_COL_DISTANCE");
                }
                case -1: {
                    return "";
                }
                case 0: {
                    return OStrings.getString("ALIGNER_PANEL_TABLE_COL_KEEP");
                }
                case 1: {
                    return OStrings.getString("ALIGNER_PANEL_TABLE_COL_SOURCE");
                }
                case 2: {
                    return OStrings.getString("ALIGNER_PANEL_TABLE_COL_TARGET");
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case -3: {
                    return row;
                }
                case -2: {
                    MutableBead bead = this.rowToBead.get(row);
                    if (row > 0 && bead == this.rowToBead.get(row - 1)) {
                        return null;
                    }
                    return this.rowToDistance.get(row);
                }
                case -1: {
                    MutableBead bead = this.rowToBead.get(row);
                    if (row > 0 && bead == this.rowToBead.get(row - 1)) {
                        return null;
                    }
                    return this.data.indexOf(bead) + 1;
                }
                case 0: {
                    MutableBead bead = this.rowToBead.get(row);
                    if (row > 0 && bead == this.rowToBead.get(row - 1)) {
                        return null;
                    }
                    return bead.enabled;
                }
                case 1: {
                    return this.rowToSourceLine.get(row);
                }
                case 2: {
                    return this.rowToTargetLine.get(row);
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex != 0) {
                throw new IllegalArgumentException();
            }
            if (!(aValue instanceof Boolean)) {
                throw new IllegalArgumentException();
            }
            this.rowToBead.get((int)rowIndex).enabled = (Boolean)aValue;
        }

        int[] move(List<Integer> rows, int col, int trgRow) {
            MutableBead trgBead;
            if (!this.isEditableColumn(col)) {
                throw new IllegalArgumentException();
            }
            Collections.sort(rows);
            ArrayList<String> selected = new ArrayList<String>(rows.size());
            List<String> lines = col == 1 ? this.rowToSourceLine : this.rowToTargetLine;
            int origRowCount = this.getRowCount();
            if (trgRow < 0) {
                trgBead = new MutableBead();
                this.data.add(0, trgBead);
            } else if (trgRow > this.rowToBead.size() - 1) {
                trgBead = new MutableBead();
                this.data.add(trgBead);
            } else {
                trgBead = this.rowToBead.get(trgRow);
            }
            List<String> trgLines = col == 1 ? trgBead.sourceLines : trgBead.targetLines;
            for (int row : rows) {
                String line = lines.get(row);
                if (line == null) {
                    throw new IllegalArgumentException();
                }
                selected.add(line);
                MutableBead bead = this.rowToBead.get(row);
                if (bead == trgBead) continue;
                Util.removeByIdentity(col == 1 ? bead.sourceLines : bead.targetLines, line);
                int insertIndex = trgRow > row ? 0 : trgLines.size();
                trgLines.add(insertIndex, line);
            }
            trgBead.status = MutableBead.Status.DEFAULT;
            this.makeCache();
            if (origRowCount != this.getRowCount()) {
                this.fireTableDataChanged();
            }
            lines = col == 1 ? this.rowToSourceLine : this.rowToTargetLine;
            return new int[]{Util.indexByIdentity(lines, (String)selected.get(0)), Util.indexByIdentity(lines, (String)selected.get(selected.size() - 1))};
        }

        private MutableBead splitBead(MutableBead bead) {
            if (bead.isBalanced()) {
                return bead;
            }
            int index = this.data.indexOf(bead);
            bead = this.splitBeadByCount(bead, Math.min(bead.sourceLines.size(), bead.targetLines.size()));
            this.data.add(index + 1, bead);
            return bead;
        }

        private MutableBead splitBeadByCount(MutableBead bead, int count) {
            ArrayList<String> splitSrc = new ArrayList<String>(bead.sourceLines);
            bead.sourceLines.clear();
            ArrayList<String> splitTrg = new ArrayList<String>(bead.targetLines);
            bead.targetLines.clear();
            bead.status = MutableBead.Status.DEFAULT;
            for (int i = 0; i < count; ++i) {
                if (!splitSrc.isEmpty()) {
                    bead.sourceLines.add((String)splitSrc.remove(0));
                }
                if (splitTrg.isEmpty()) continue;
                bead.targetLines.add((String)splitTrg.remove(0));
            }
            return new MutableBead(splitSrc, splitTrg);
        }

        int getBeadNumberForRow(int row) {
            return this.data.indexOf(this.rowToBead.get(row));
        }

        MutableBead.Status getStatusForRow(int row) {
            return this.rowToBead.get((int)row).status;
        }

        boolean canMove(int row, int col, boolean up) {
            if (!this.isEditableColumn(col)) {
                return false;
            }
            MutableBead bead = this.rowToBead.get(row);
            if (row == 0 && up || row == this.rowToBead.size() - 1 && !up) {
                return !(col == 1 ? bead.targetLines : bead.sourceLines).isEmpty();
            }
            List<String> lines = col == 1 ? bead.sourceLines : bead.targetLines;
            String line = (col == 1 ? this.rowToSourceLine : this.rowToTargetLine).get(row);
            int index = Util.indexByIdentity(lines, line);
            return up ? index == 0 : index == lines.size() - 1;
        }

        boolean canMoveTo(int trgRow, int row, int col, boolean up) {
            MutableBead trgBead;
            MutableBead srcBead;
            if (!this.canMove(row, col, up) || trgRow == row) {
                return false;
            }
            if (trgRow >= 0 && trgRow < this.rowToBead.size() && (srcBead = this.rowToBead.get(row)) == (trgBead = this.rowToBead.get(trgRow))) {
                return false;
            }
            int inc = up ? -1 : 1;
            for (int r = row + inc; r != trgRow && r >= 0 && r < this.rowToSourceLine.size(); r += inc) {
                String line = (col == 1 ? this.rowToSourceLine : this.rowToTargetLine).get(r);
                if (line == null) continue;
                return false;
            }
            return true;
        }

        List<MutableBead> getData() {
            return Collections.unmodifiableList(this.data);
        }

        List<Integer> getRowExtentsForBeadAtRow(int row) {
            MutableBead bead = this.rowToBead.get(row);
            ArrayList<Integer> result = new ArrayList<Integer>();
            int firstIndex = this.rowToBead.indexOf(bead);
            if (firstIndex == -1) {
                throw new IllegalArgumentException();
            }
            for (int i = firstIndex; i < this.rowToBead.size() && this.rowToBead.get(i) == bead; ++i) {
                result.add(i);
            }
            return result;
        }

        boolean isEditableColumn(int col) {
            return col == 1 || col == 2;
        }

        List<Integer> realCellsInRowSpan(int col, int ... rows) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (int row : rows) {
                if (this.getValueAt(row, col) == null) continue;
                result.add(row);
            }
            return result;
        }

        int prevBeadFromRow(int row) {
            return this.nextBeadFromRowByOffset(row, -1);
        }

        int nextBeadFromRow(int row) {
            return this.nextBeadFromRowByOffset(row, 1);
        }

        private int nextBeadFromRowByOffset(int row, int offset) {
            MutableBead bead = this.rowToBead.get(row);
            for (int i = row + offset; i < this.getRowCount(); i += offset) {
                if (this.rowToBead.get(i) == bead) continue;
                return i;
            }
            return -1;
        }

        int mergeRows(List<Integer> rows, int col) {
            if (!this.isEditableColumn(col)) {
                throw new IllegalArgumentException();
            }
            int origRowCount = this.getRowCount();
            ArrayList<String> toCombine = new ArrayList<String>();
            List<String> lines = col == 1 ? this.rowToSourceLine : this.rowToTargetLine;
            toCombine.add(lines.get(rows.get(0)));
            for (int i = 1; i < rows.size(); ++i) {
                int row = rows.get(i);
                String line = lines.get(row);
                toCombine.add(line);
                MutableBead bead = this.rowToBead.get(row);
                Util.removeByIdentity(col == 1 ? bead.sourceLines : bead.targetLines, line);
                bead.status = MutableBead.Status.DEFAULT;
            }
            MutableBead trgBead = this.rowToBead.get(rows.get(0));
            List<String> trgLines = col == 1 ? trgBead.sourceLines : trgBead.targetLines;
            Language lang = col == 1 ? ((AlignPanelController)AlignPanelController.this).aligner.srcLang : ((AlignPanelController)AlignPanelController.this).aligner.trgLang;
            String combined = Util.join(lang, toCombine);
            trgLines.set(Util.indexByIdentity(trgLines, (String)toCombine.get(0)), combined);
            trgBead.status = MutableBead.Status.DEFAULT;
            this.makeCache();
            if (origRowCount != this.getRowCount()) {
                this.fireTableDataChanged();
            }
            lines = col == 1 ? this.rowToSourceLine : this.rowToTargetLine;
            return Util.indexByIdentity(lines, combined);
        }

        int[] splitRow(int row, int col, String[] split) {
            if (!this.isEditableColumn(col)) {
                throw new IllegalArgumentException();
            }
            int origRowCount = this.getRowCount();
            MutableBead trgBead = this.rowToBead.get(row);
            List<String> trgLines = col == 1 ? trgBead.sourceLines : trgBead.targetLines;
            String line = (col == 1 ? this.rowToSourceLine : this.rowToTargetLine).get(row);
            int insertAt = Util.indexByIdentity(trgLines, line);
            trgLines.set(insertAt++, split[0]);
            for (int i = 1; i < split.length; ++i) {
                trgLines.add(insertAt++, split[i]);
            }
            trgBead.status = MutableBead.Status.DEFAULT;
            this.makeCache();
            if (origRowCount != this.getRowCount()) {
                this.fireTableDataChanged();
            }
            List<String> lines = col == 1 ? this.rowToSourceLine : this.rowToTargetLine;
            return new int[]{Util.indexByIdentity(lines, split[0]), Util.indexByIdentity(lines, split[split.length - 1])};
        }

        void editRow(int row, int col, String newVal) {
            if (!this.isEditableColumn(col)) {
                throw new IllegalArgumentException();
            }
            MutableBead trgBead = this.rowToBead.get(row);
            List<String> trgLines = col == 1 ? trgBead.sourceLines : trgBead.targetLines;
            String line = (col == 1 ? this.rowToSourceLine : this.rowToTargetLine).get(row);
            int insertAt = Util.indexByIdentity(trgLines, line);
            trgLines.set(insertAt, newVal);
            this.makeCache();
        }

        int[] slide(List<Integer> rows, int col, int offset) {
            if (offset == 0) {
                return new int[0];
            }
            if (!this.isEditableColumn(col)) {
                throw new IllegalArgumentException();
            }
            Collections.sort(rows);
            if (offset > 0) {
                Collections.reverse(rows);
            }
            int origRowCount = this.getRowCount();
            ArrayList<String> selected = new ArrayList<String>(rows.size());
            Iterator<Integer> iterator = rows.iterator();
            while (iterator.hasNext()) {
                MutableBead trgBead;
                int row;
                List<String> lines = col == 1 ? this.rowToSourceLine : this.rowToTargetLine;
                String line = lines.get(row = iterator.next().intValue());
                if (line == null) {
                    throw new IllegalArgumentException();
                }
                selected.add(line);
                MutableBead bead = this.rowToBead.get(row);
                int trgRow = row + offset;
                if (trgRow < 0) {
                    trgBead = new MutableBead();
                    this.data.add(0, trgBead);
                } else if (trgRow > this.rowToBead.size() - 1) {
                    trgBead = new MutableBead();
                    this.data.add(trgBead);
                } else {
                    trgBead = this.rowToBead.get(trgRow);
                }
                if (trgBead == bead) {
                    if (lines.get(trgRow) != null) continue;
                    trgBead = this.splitBead(trgBead);
                }
                Util.removeByIdentity(col == 1 ? bead.sourceLines : bead.targetLines, line);
                bead.status = MutableBead.Status.DEFAULT;
                List<String> trgLines = col == 1 ? trgBead.sourceLines : trgBead.targetLines;
                int insertIndex = trgRow > row ? 0 : trgLines.size();
                trgLines.add(insertIndex, line);
                trgBead.status = MutableBead.Status.DEFAULT;
            }
            this.makeCache();
            if (origRowCount != this.getRowCount()) {
                this.fireTableDataChanged();
            }
            List<String> lines = col == 1 ? this.rowToSourceLine : this.rowToTargetLine;
            int[] resultRows = new int[]{Util.indexByIdentity(lines, (String)selected.get(0)), Util.indexByIdentity(lines, (String)selected.get(selected.size() - 1))};
            Arrays.sort(resultRows);
            return resultRows;
        }

        int beadsInRowSpan(int ... rows) {
            ArrayList<MutableBead> beads = new ArrayList<MutableBead>();
            for (int row : rows) {
                MutableBead bead = this.rowToBead.get(row);
                if (beads.contains(bead)) continue;
                beads.add(bead);
            }
            return beads.size();
        }

        void splitBead(int[] rows) {
            int origRowCount = this.getRowCount();
            MutableBead bead = this.rowToBead.get(rows[0]);
            int beadIndex = this.data.indexOf(bead);
            for (int row : rows) {
                int index;
                String line = this.rowToSourceLine.get(row);
                List<String> indexFrom = bead.sourceLines;
                if (line == null) {
                    line = this.rowToTargetLine.get(row);
                    indexFrom = bead.targetLines;
                }
                if ((index = Util.indexByIdentity(indexFrom, line)) == -1) {
                    throw new IllegalArgumentException();
                }
                if (index <= 0) continue;
                bead = this.splitBeadByCount(bead, index);
                this.data.add(++beadIndex, bead);
            }
            this.makeCache();
            if (origRowCount != this.getRowCount()) {
                this.fireTableDataChanged();
            }
        }

        void toggleBeadsAtRows(int ... rows) {
            ArrayList<MutableBead> beads = new ArrayList<MutableBead>(rows.length);
            for (int row : rows) {
                MutableBead bead = this.rowToBead.get(row);
                if (beads.contains(bead)) continue;
                bead.enabled = !bead.enabled;
                beads.add(bead);
            }
        }

        void toggleAllBeads(boolean value) {
            for (MutableBead bead : this.data) {
                bead.enabled = value;
            }
        }

        void setStatusAtRow(int row, MutableBead.Status status) {
            MutableBead bead = this.rowToBead.get(row);
            bead.status = status;
        }

        int nextNonEmptyCell(int row, int col) {
            if (!this.isEditableColumn(col)) {
                throw new IllegalArgumentException();
            }
            List<String> lines = col == 1 ? this.rowToSourceLine : this.rowToTargetLine;
            for (int i = row + 1; i < lines.size(); ++i) {
                if (lines.get(i) == null) continue;
                return i;
            }
            return -1;
        }

        void replaceData(List<MutableBead> newData) {
            this.data.clear();
            this.data.addAll(newData);
            this.makeCache();
            this.fireTableDataChanged();
        }

        String removeLine(int row, int col) {
            if (!this.isEditableColumn(col)) {
                throw new IllegalArgumentException();
            }
            MutableBead bead = this.rowToBead.get(row);
            List<String> lines = col == 1 ? this.rowToSourceLine : this.rowToTargetLine;
            String line = lines.get(row);
            Util.removeByIdentity(col == 1 ? bead.sourceLines : bead.targetLines, line);
            bead.status = MutableBead.Status.DEFAULT;
            return line;
        }

        int insertLines(List<String> lines, int row, int col) {
            if (!this.isEditableColumn(col)) {
                throw new IllegalArgumentException();
            }
            int origRowCount = this.getRowCount();
            MutableBead bead = this.rowToBead.get(row);
            (col == 1 ? bead.sourceLines : bead.targetLines).add(lines.get(0));
            bead.status = MutableBead.Status.DEFAULT;
            int beadInsertIndex = this.data.indexOf(bead) + 1;
            ArrayList<MutableBead> newBeads = new ArrayList<MutableBead>();
            for (int i = 1; i < lines.size(); ++i) {
                MutableBead newBead = new MutableBead();
                (col == 1 ? newBead.sourceLines : newBead.targetLines).add(lines.get(i));
                newBeads.add(newBead);
            }
            this.data.addAll(beadInsertIndex, newBeads);
            this.makeCache();
            if (origRowCount != this.getRowCount()) {
                this.fireTableDataChanged();
            }
            return Util.indexByIdentity(col == 1 ? this.rowToSourceLine : this.rowToTargetLine, lines.get(0));
        }
    }

    class MultilineCellRenderer
    implements TableCellRenderer {
        private final JTextPane textArea = new JTextPane();
        private final Border noFocusBorder = new EmptyBorder(FOCUS_BORDER.getBorderInsets(this.textArea));
        private final JCheckBox checkBox = new JCheckBox();
        private final AttributeSet highlight;

        MultilineCellRenderer() {
            this.textArea.setOpaque(true);
            this.checkBox.setHorizontalAlignment(0);
            this.checkBox.setBorderPainted(true);
            SimpleAttributeSet sas = new SimpleAttributeSet();
            StyleConstants.setBackground(sas, Styles.EditorColor.COLOR_ALIGNER_HIGHLIGHT.getColor());
            this.highlight = sas;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Boolean) {
                this.doStyling(this.checkBox, table, isSelected, hasFocus, row, column);
                this.checkBox.setSelected((Boolean)value);
                return this.checkBox;
            }
            this.doStyling(this.textArea, table, isSelected, hasFocus, row, column);
            this.textArea.setText(null);
            if (value != null) {
                String text = value.toString();
                this.textArea.setText(text);
                this.doHighlighting(text);
            }
            return this.textArea;
        }

        private void doStyling(JComponent comp, JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                comp.setBackground(table.getSelectionBackground());
                comp.setForeground(table.getSelectionForeground());
            } else {
                MutableBead.Status status = ((BeadTableModel)table.getModel()).getStatusForRow(row);
                if (column == 0 && status != MutableBead.Status.DEFAULT) {
                    switch (status) {
                        case ACCEPTED: {
                            comp.setBackground(Styles.EditorColor.COLOR_ALIGNER_ACCEPTED.getColor());
                            break;
                        }
                        case NEEDS_REVIEW: {
                            comp.setBackground(Styles.EditorColor.COLOR_ALIGNER_NEEDSREVIEW.getColor());
                            break;
                        }
                    }
                } else if (row == AlignPanelController.this.ppRow && column == AlignPanelController.this.ppCol) {
                    comp.setBackground(Color.GREEN);
                } else {
                    comp.setBackground(this.getBeadNumber(table, row) % 2 == 0 ? table.getBackground() : Styles.EditorColor.COLOR_ALIGNER_TABLE_ROW_HIGHLIGHT.getColor());
                    comp.setForeground(table.getForeground());
                }
            }
            EmptyBorder marginBorder = new EmptyBorder(1, column == 0 ? 5 : 1, 1, column == table.getColumnCount() - 1 ? 5 : 1);
            if (hasFocus) {
                comp.setBorder(new CompoundBorder(marginBorder, FOCUS_BORDER));
            } else {
                comp.setBorder(new CompoundBorder(marginBorder, this.noFocusBorder));
            }
            comp.setFont(table.getFont());
        }

        private int getBeadNumber(JTable table, int row) {
            return ((BeadTableModel)table.getModel()).getBeadNumberForRow(row);
        }

        void doHighlighting(String text) {
            StyledDocument doc = this.textArea.getStyledDocument();
            doc.setCharacterAttributes(0, text.length(), new SimpleAttributeSet(), true);
            if (!AlignPanelController.this.doHighlight || AlignPanelController.this.highlightPattern == null) {
                return;
            }
            Matcher m = AlignPanelController.this.highlightPattern.matcher(text);
            while (m.find()) {
                doc.setCharacterAttributes(m.start(), m.end() - m.start(), this.highlight, true);
            }
        }
    }

    private static enum Phase {
        ALIGN,
        EDIT,
        PINPOINT;

    }
}

