/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import gen.core.project.RepositoryDefinition;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.concurrent.CancellationException;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.omegat.core.Core;
import org.omegat.core.team2.RemoteRepositoryFactory;
import org.omegat.gui.dialogs.NewProjectFileChooser;
import org.omegat.gui.dialogs.NewTeamProject;
import org.omegat.gui.main.IMainWindow;
import org.omegat.util.HttpConnectionUtils;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.ProjectFileStorage;
import org.omegat.util.StringUtil;

public class NewTeamProjectController {
    private final IMainWindow mw;
    private NewTeamProject dialog;
    private RepoTypeWorker repoTypeWorker = null;
    private String repoType;
    private boolean ok;

    public NewTeamProjectController(IMainWindow mainWindow) {
        this.mw = mainWindow;
    }

    public File show() {
        this.ok = false;
        this.initComponents();
        if (!this.ok) {
            Core.getMainWindow().showStatusMessageRB("TEAM_CANCELLED", new Object[0]);
            return null;
        }
        return new File(this.getSaveLocation());
    }

    public RepositoryDefinition getRepo() {
        RepositoryDefinition repo = new RepositoryDefinition();
        repo.setType(this.getRepoType());
        repo.setUrl(this.getRepoUrl());
        if (this.isCustomBranch()) {
            repo.setBranch(this.getBranchName());
        }
        return repo;
    }

    private void initComponents() {
        this.dialog = new NewTeamProject(this.mw.getApplicationFrame());
        this.dialog.defaultBranchRB.setSelected(true);
        this.dialog.txtBranchName.setEnabled(false);
        this.dialog.defaultBranchRB.addActionListener(this::branchRBActionPerformed);
        this.dialog.customBranchRB.addActionListener(this::branchRBActionPerformed);
        this.dialog.customBranchRB.setEnabled(false);
        this.dialog.btnOk.addActionListener(this::btnOkActionPerformed);
        this.dialog.btnCancel.addActionListener(this::btnCancelActionPerformed);
        this.dialog.btnDirectory.addActionListener(this::btnDirectoryActionPerformed);
        this.dialog.txtRepositoryOrProjectFileURL.addActionListener(this::txtProjectFileURLActionPerformed);
        this.dialog.txtRepositoryOrProjectFileURL.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                NewTeamProjectController.this.txtProjectFileURLFocusLost(evt);
            }
        });
        this.dialog.txtRepositoryOrProjectFileURL.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewTeamProjectController.this.clearRepo();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewTeamProjectController.this.clearRepo();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewTeamProjectController.this.clearRepo();
            }
        });
        this.dialog.txtRepositoryOrProjectFileURL.addActionListener(e -> this.dialog.btnOk.doClick());
        this.dialog.txtDirectory.addActionListener(this::txtDirectoryActionPerformed);
        this.dialog.txtBranchName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                NewTeamProjectController.this.txtBranchNameFocusLost(evt);
            }
        });
        this.dialog.txtDirectory.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                NewTeamProjectController.this.txtDirectoryFocusLost(evt);
            }
        });
        this.dialog.txtDirectory.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewTeamProjectController.this.updateDialog();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewTeamProjectController.this.updateDialog();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewTeamProjectController.this.updateDialog();
            }
        });
        this.dialog.txtDirectory.addActionListener(e -> this.dialog.btnOk.doClick());
        this.dialog.setVisible(true);
    }

    public String getRepoType() {
        return this.repoType;
    }

    public String getRepoUrl() {
        String url = this.dialog.txtRepositoryOrProjectFileURL.getText().trim();
        if (url.startsWith("git!")) {
            return url.substring("git!".length());
        }
        if (url.startsWith("svn!")) {
            return url.substring("svn!".length());
        }
        return url;
    }

    public String getSaveLocation() {
        return this.dialog.txtDirectory.getText().trim();
    }

    public boolean isCustomBranch() {
        return this.dialog.customBranchRB.isSelected();
    }

    public String getBranchName() {
        return this.dialog.txtBranchName.getText();
    }

    private synchronized void detectRepoOrFile() {
        if (this.repoType != null || this.isDetectingRepo()) {
            return;
        }
        String url = this.dialog.txtRepositoryOrProjectFileURL.getText().trim();
        if (StringUtil.isEmpty(url)) {
            return;
        }
        if (url.startsWith("git!")) {
            this.dialog.detectedRepoOrProjectFileLabel.setText(OStrings.getString("TEAM_DETECTED_REPO_GIT"));
            this.repoType = "git";
            this.suggestLocalFolder();
        } else if (url.startsWith("svn!")) {
            this.dialog.detectedRepoOrProjectFileLabel.setText(OStrings.getString("TEAM_DETECTED_REPO_SVN"));
            this.repoType = "svn";
            this.suggestLocalFolder();
        } else {
            this.dialog.detectedRepoOrProjectFileLabel.setText(OStrings.getString("TEAM_DETECTING_REPO_OR_PROJECT_FILE"));
            this.repoTypeWorker = new RepoTypeWorker(url);
            this.repoTypeWorker.execute();
        }
    }

    private synchronized boolean isDetectingRepo() {
        return this.repoTypeWorker != null && !this.repoTypeWorker.isDone();
    }

    private static String getMessageForRepoType(String type) {
        if ("svn".equals(type)) {
            return OStrings.getString("TEAM_DETECTED_REPO_SVN");
        }
        if ("git".equals(type)) {
            return OStrings.getString("TEAM_DETECTED_REPO_GIT");
        }
        if ("project-file".equals(type)) {
            return OStrings.getString("TEAM_DETECTED_PROJECT_FILE");
        }
        return OStrings.getString("TEAM_DETECTED_REPO_UNKNOWN");
    }

    private void suggestLocalFolder() {
        if (!this.getSaveLocation().isEmpty()) {
            return;
        }
        String url = this.dialog.txtRepositoryOrProjectFileURL.getText().trim();
        String strippedUrl = StringUtil.stripFromEnd(url, ".git", "/", "trunk", "/", "svn");
        String dir = Preferences.getPreferenceDefault("current_folder", System.getProperty("user.home"));
        File suggestion = new File(dir, new File(strippedUrl).getName()).getAbsoluteFile();
        this.dialog.txtDirectory.setText(NewTeamProjectController.ensureUniquePath(suggestion).getPath());
    }

    private static File ensureUniquePath(File path) {
        File result = path;
        int suff = 2;
        while (result.exists()) {
            result = new File(path.getPath() + suff);
            if (++suff <= 1000) continue;
            break;
        }
        return result;
    }

    private void clearRepo() {
        this.repoType = null;
        this.dialog.detectedRepoOrProjectFileLabel.setText(" ");
        if (this.repoTypeWorker != null) {
            this.repoTypeWorker.cancel(true);
        }
        this.updateDialog();
    }

    void updateDialog() {
        String dir = this.getSaveLocation();
        boolean dirOK = !dir.isEmpty() && !new File(dir).exists();
        boolean typeDetected = this.repoType != null;
        boolean branchSpecified = !StringUtil.isEmpty(this.getBranchName()) || !this.isCustomBranch();
        this.dialog.btnOk.setEnabled(dirOK && typeDetected && branchSpecified);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        if (this.repoTypeWorker != null) {
            this.repoTypeWorker.cancel(true);
        }
        this.ok = false;
        this.dialog.dispose();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.ok = true;
        this.dialog.dispose();
    }

    private void btnDirectoryActionPerformed(ActionEvent evt) {
        int ndcResult;
        NewProjectFileChooser ndc = new NewProjectFileChooser();
        String saveDir = this.getSaveLocation();
        if (!saveDir.isEmpty()) {
            ndc.setSelectedFile(new File(saveDir));
        }
        if ((ndcResult = ndc.showSaveDialog(this.dialog)) == 0) {
            this.dialog.txtDirectory.setText(ndc.getSelectedFile().getPath());
        }
        this.updateDialog();
    }

    private void txtProjectFileURLActionPerformed(ActionEvent evt) {
        this.detectRepoOrFile();
    }

    private void txtProjectFileURLFocusLost(FocusEvent evt) {
        this.detectRepoOrFile();
    }

    private void txtDirectoryFocusLost(FocusEvent evt) {
        this.updateDialog();
    }

    private void txtDirectoryActionPerformed(ActionEvent evt) {
        this.updateDialog();
    }

    private void txtBranchNameFocusLost(FocusEvent evt) {
        this.updateDialog();
    }

    private void branchRBActionPerformed(ActionEvent evt) {
        this.dialog.txtBranchName.setEnabled(this.dialog.customBranchRB.isSelected());
        this.updateDialog();
    }

    private class RepoTypeWorker
    extends SwingWorker<String, Void> {
        private final String url;

        RepoTypeWorker(String url) {
            this.url = url;
        }

        @Override
        protected String doInBackground() throws Exception {
            if ((this.url.startsWith("http://") || this.url.startsWith("https://")) && this.url.endsWith("/omegat.project")) {
                return this.detectProjectFile();
            }
            return RemoteRepositoryFactory.detectRepositoryType(this.url);
        }

        protected String detectProjectFile() throws Exception {
            byte[] file = HttpConnectionUtils.getURLasByteArray(this.url);
            ProjectFileStorage.parseProjectFile(file);
            return "project-file";
        }

        @Override
        protected void done() {
            String resultText;
            String type;
            try {
                type = (String)this.get();
                resultText = NewTeamProjectController.getMessageForRepoType(type);
            }
            catch (CancellationException ex) {
                type = null;
                resultText = " ";
            }
            catch (Throwable ex) {
                type = null;
                resultText = OStrings.getString("TEAM_ERROR_DETECTING_PROJECT_FILE");
                Log.logErrorRB(ex, "TEAM_ERROR_DETECTING_PROJECT_FILE", new Object[0]);
            }
            ((NewTeamProjectController)NewTeamProjectController.this).dialog.detectedRepoOrProjectFileLabel.setText(resultText);
            if (type != null) {
                NewTeamProjectController.this.suggestLocalFolder();
            }
            NewTeamProjectController.this.repoType = type;
            ((NewTeamProjectController)NewTeamProjectController.this).dialog.customBranchRB.setEnabled(NewTeamProjectController.this.repoType != null && NewTeamProjectController.this.repoType.equals("git"));
            NewTeamProjectController.this.updateDialog();
        }
    }
}

