/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.issues;

import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import org.omegat.gui.issues.IIssueProvider;
import org.omegat.gui.issues.IssueProviders;
import org.omegat.gui.issues.IssueProvidersSelectorPanel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.StaticUIUtils;

public class IssueProvidersSelectorController {
    private final Map<String, JCheckBox> providerSettings = new HashMap<String, JCheckBox>();
    private boolean userDidConfirm;

    public boolean show(Window parent) {
        final JDialog dialog = new JDialog(parent, OStrings.getString("ISSUE_PROVIDERS_SELECTOR_TITLE"));
        dialog.setModal(true);
        dialog.setDefaultCloseOperation(2);
        StaticUIUtils.setEscapeClosable(dialog);
        StaticUIUtils.setWindowIcon(dialog);
        IssueProvidersSelectorPanel panel = new IssueProvidersSelectorPanel();
        dialog.getRootPane().setDefaultButton(panel.okButton);
        dialog.getContentPane().add(panel);
        JCheckBox tagsCB = new JCheckBox(OStrings.getString("ISSUES_TAGS_PROVIDER_NAME"));
        tagsCB.setSelected(true);
        tagsCB.setEnabled(false);
        panel.providersPanel.add(tagsCB);
        Set<String> disabledIds = IssueProviders.getDisabledProviderIds();
        for (IIssueProvider provider : IssueProviders.getIssueProviders()) {
            JCheckBox cb = new JCheckBox(provider.getName());
            this.providerSettings.put(provider.getId(), cb);
            cb.setSelected(!disabledIds.contains(provider.getId()));
            panel.providersPanel.add(cb);
        }
        panel.dontAskCheckBox.setSelected(Preferences.isPreference("issue_providers_dont_ask"));
        panel.okButton.addActionListener(ev -> {
            this.userDidConfirm = true;
            List<String> toEnable = this.providerSettings.entrySet().stream().filter(e -> ((JCheckBox)e.getValue()).isSelected()).map(Map.Entry::getKey).collect(Collectors.toList());
            List<String> toDisable = this.providerSettings.entrySet().stream().filter(e -> !((JCheckBox)e.getValue()).isSelected()).map(Map.Entry::getKey).collect(Collectors.toList());
            IssueProviders.setProviders(toEnable, toDisable);
            Preferences.setPreference("issue_providers_dont_ask", panel.dontAskCheckBox.isSelected());
            StaticUIUtils.closeWindowByEvent(dialog);
        });
        panel.cancelButton.addActionListener(e -> {
            this.userDidConfirm = false;
            StaticUIUtils.closeWindowByEvent(dialog);
        });
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                dialog.pack();
            }
        });
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return this.userDidConfirm;
    }
}

