/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.tagvalidation;

import java.util.List;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.tagvalidation.ErrorReport;
import org.omegat.util.TagUtil;

public final class TagRepair {
    private TagRepair() {
    }

    public static void fixTag(SourceTextEntry ste, TagUtil.Tag tag, ErrorReport.TagError error, StringBuilder translation, String source) {
        switch (error) {
            case DUPLICATE: 
            case ORDER: 
            case MALFORMED: {
                List<TagUtil.Tag> tags = TagUtil.buildTagList(source, ste.getProtectedParts());
                TagRepair.fixMalformed(tags, translation, tag);
                break;
            }
            case MISSING: {
                List<TagUtil.Tag> tags = TagUtil.buildTagList(source, ste.getProtectedParts());
                TagRepair.fixMissing(tags, translation, tag);
                break;
            }
            case EXTRANEOUS: {
                TagRepair.fixExtraneous(translation, tag);
                break;
            }
            case ORPHANED: {
                break;
            }
            case WHITESPACE: {
                TagRepair.fixWhitespace(translation, source);
                break;
            }
        }
    }

    protected static void fixWhitespace(StringBuilder translation, String source) {
        if (source.startsWith("\n") && translation.charAt(0) != '\n') {
            translation.insert(0, '\n');
        } else if (!source.startsWith("\n") && translation.charAt(0) == '\n') {
            translation.deleteCharAt(0);
        }
        if (source.endsWith("\n") && translation.charAt(translation.length() - 1) != '\n') {
            translation.append('\n');
        } else if (!source.endsWith("\n") && translation.charAt(translation.length() - 1) == '\n') {
            translation.deleteCharAt(translation.length() - 1);
        }
    }

    protected static void fixMalformed(List<TagUtil.Tag> tags, StringBuilder text, TagUtil.Tag tag) {
        TagRepair.fixExtraneous(text, tag);
        TagRepair.fixMissing(tags, text, tag);
    }

    protected static void fixMissing(List<TagUtil.Tag> tags, StringBuilder text, TagUtil.Tag tag) {
        TagUtil.Tag next;
        int index = TagRepair.getTagIndex(tags, tag);
        TagUtil.Tag prev = index > 0 ? tags.get(index - 1) : null;
        TagUtil.Tag tag2 = next = index + 1 < tags.size() ? tags.get(index + 1) : null;
        if (prev != null && text.indexOf(prev.tag) > -1) {
            text.insert(text.indexOf(prev.tag) + prev.tag.length(), tag.tag);
        } else if (next != null && text.indexOf(next.tag) > -1) {
            text.insert(text.indexOf(next.tag), tag.tag);
        } else {
            text.append(tag.tag);
        }
    }

    protected static void fixExtraneous(StringBuilder text, TagUtil.Tag tag) {
        int tagEnd = tag.pos + tag.tag.length();
        if (tag.pos > 0 && tagEnd < text.length() && text.substring(tag.pos, tagEnd).equals(tag.tag)) {
            text.delete(tag.pos, tagEnd);
        } else {
            int i = text.indexOf(tag.tag);
            if (i != -1) {
                text.delete(i, i + tag.tag.length());
            }
        }
    }

    private static int getTagIndex(List<TagUtil.Tag> tags, TagUtil.Tag tag) {
        for (int i = 0; i < tags.size(); ++i) {
            TagUtil.Tag t = tags.get(i);
            if (!t.tag.equals(tag.tag)) continue;
            return i;
        }
        return -1;
    }
}

