/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.align;

import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.loomchild.maligna.calculator.Calculator;
import net.loomchild.maligna.calculator.length.NormalDistributionCalculator;
import net.loomchild.maligna.calculator.length.PoissonDistributionCalculator;
import net.loomchild.maligna.calculator.length.counter.CharCounter;
import net.loomchild.maligna.calculator.length.counter.Counter;
import net.loomchild.maligna.calculator.length.counter.SplitCounter;
import net.loomchild.maligna.coretypes.Alignment;
import net.loomchild.maligna.coretypes.CategoryDefaults;
import net.loomchild.maligna.filter.aligner.align.AlignAlgorithm;
import net.loomchild.maligna.filter.aligner.align.hmm.fb.ForwardBackwardAlgorithm;
import net.loomchild.maligna.filter.aligner.align.hmm.viterbi.ViterbiAlgorithm;
import net.loomchild.maligna.matrix.FullMatrixFactory;
import net.loomchild.maligna.matrix.MatrixFactory;
import org.omegat.core.Core;
import org.omegat.core.data.ParseEntry;
import org.omegat.core.data.ProtectedPart;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.IParseCallback;
import org.omegat.gui.align.MutableBead;
import org.omegat.gui.align.Util;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXWriter2;

public class Aligner {
    final String srcFile;
    final Language srcLang;
    final String trgFile;
    final Language trgLang;
    boolean segment = true;
    boolean removeTags = false;
    ComparisonMode comparisonMode;
    AlgorithmClass algorithmClass;
    CalculatorType calculatorType;
    CounterType counterType;
    private List<String> srcRaw;
    private List<String> trgRaw;
    private List<Map.Entry<String, String>> idPairs;
    List<ComparisonMode> allowedModes;

    public Aligner(String srcFile, Language srcLang, String trgFile, Language trgLang) {
        this.srcFile = srcFile;
        this.srcLang = srcLang;
        this.trgFile = trgFile;
        this.trgLang = trgLang;
        this.restoreDefaults();
    }

    void loadFiles() throws Exception {
        Map.Entry<List<String>, List<String>> srcResult = this.parseFile(this.srcFile);
        this.srcRaw = srcResult.getValue();
        Map.Entry<List<String>, List<String>> trgResult = this.parseFile(this.trgFile);
        this.trgRaw = trgResult.getValue();
        ArrayList<ComparisonMode> allowed = new ArrayList<ComparisonMode>();
        allowed.add(ComparisonMode.HEAPWISE);
        if (this.srcRaw.size() == this.trgRaw.size()) {
            allowed.add(ComparisonMode.PARSEWISE);
        }
        List<String> srcIds = srcResult.getKey();
        List<String> trgIds = trgResult.getKey();
        if (srcIds.size() == this.srcRaw.size() && trgIds.size() == this.trgRaw.size()) {
            allowed.add(ComparisonMode.ID);
            this.comparisonMode = ComparisonMode.ID;
            HashMap trgMap = new HashMap();
            IntStream.range(0, this.trgRaw.size()).forEach(i -> trgMap.put((String)trgIds.get(i), this.trgRaw.get(i)));
            this.idPairs = IntStream.range(0, this.srcRaw.size()).mapToObj(i -> {
                String src = this.srcRaw.get(i);
                String trg = (String)trgMap.get(srcIds.get(i));
                if (src != null && trg != null) {
                    return new AbstractMap.SimpleImmutableEntry<String, String>(src, trg);
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        } else {
            this.idPairs = Collections.emptyList();
        }
        this.allowedModes = Collections.unmodifiableList(allowed);
    }

    void clearLoaded() {
        this.srcRaw = null;
        this.trgRaw = null;
        this.idPairs = null;
    }

    void restoreDefaults() {
        this.comparisonMode = ComparisonMode.HEAPWISE;
        this.algorithmClass = AlgorithmClass.VITERBI;
        this.calculatorType = CalculatorType.NORMAL;
        this.counterType = !this.srcLang.isSpaceDelimited() || !this.trgLang.isSpaceDelimited() ? CounterType.CHAR : CounterType.WORD;
    }

    private Map.Entry<List<String>, List<String>> parseFile(String file) throws Exception {
        final ArrayList ids = new ArrayList();
        final ArrayList rawSegs = new ArrayList();
        Core.getFilterMaster().loadFile(file, new FilterContext(this.srcLang, this.trgLang, true).setRemoveAllTags(this.removeTags), new IParseCallback(){

            @Override
            public void linkPrevNextSegments() {
            }

            @Override
            public void addEntry(String id, String source, String translation, boolean isFuzzy, String comment, IFilter filter) {
                this.process(source, id);
            }

            @Override
            public void addEntry(String id, String source, String translation, boolean isFuzzy, String comment, String path, IFilter filter, List<ProtectedPart> protectedParts) {
                this.process(source, id != null ? id : (path != null ? path : null));
            }

            @Override
            public void addEntryWithProperties(String id, String source, String translation, boolean isFuzzy, String[] props, String path, IFilter filter, List<ProtectedPart> protectedParts) {
                this.process(source, id != null ? id : (path != null ? path : null));
            }

            private void process(String text, String id) {
                boolean removeSpaces = Core.getFilterMaster().getConfig().isRemoveSpacesNonseg();
                if (!(text = StringUtil.normalizeUnicode(ParseEntry.stripSomeChars(text, new ParseEntry.ParseEntryResult(), Aligner.this.removeTags, removeSpaces))).trim().isEmpty()) {
                    if (id != null) {
                        ids.add(id);
                    }
                    rawSegs.add(text);
                }
            }
        });
        return new AbstractMap.SimpleImmutableEntry<List<String>, List<String>>(ids, rawSegs);
    }

    private List<String> segmentAll(Language language, List<String> rawTexts) {
        return rawTexts.stream().flatMap(text -> Core.getSegmenter().segment(language, (String)text, null, null).stream()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private Stream<Alignment> alignParsewiseNotSegmented() {
        if (!this.allowedModes.contains((Object)ComparisonMode.PARSEWISE)) {
            throw new UnsupportedOperationException();
        }
        return IntStream.range(0, this.srcRaw.size()).mapToObj(i -> new Alignment(Arrays.asList(this.srcRaw.get(i)), Arrays.asList(this.trgRaw.get(i))));
    }

    private Stream<Alignment> alignParsewiseSegmented() {
        if (!this.allowedModes.contains((Object)ComparisonMode.PARSEWISE)) {
            throw new UnsupportedOperationException();
        }
        return IntStream.range(0, this.srcRaw.size()).mapToObj(i -> {
            List<String> source = Core.getSegmenter().segment(this.srcLang, this.srcRaw.get(i), null, null).stream().filter(s -> !s.isEmpty()).collect(Collectors.toList());
            List<String> target = Core.getSegmenter().segment(this.trgLang, this.trgRaw.get(i), null, null).stream().filter(s -> !s.isEmpty()).collect(Collectors.toList());
            return Aligner.doAlign(this.algorithmClass, this.calculatorType, this.counterType, source, target);
        }).flatMap(Collection::stream);
    }

    private Stream<Alignment> alignByIdNotSegmented() {
        if (!this.allowedModes.contains((Object)ComparisonMode.ID)) {
            throw new UnsupportedOperationException();
        }
        return this.idPairs.stream().map(e -> new Alignment(Arrays.asList((String)e.getKey()), Arrays.asList((String)e.getValue())));
    }

    private Stream<Alignment> alignByIdSegmented() {
        if (!this.allowedModes.contains((Object)ComparisonMode.ID)) {
            throw new UnsupportedOperationException();
        }
        return this.idPairs.stream().map(e -> {
            List<String> source = Core.getSegmenter().segment(this.srcLang, (String)e.getKey(), null, null).stream().filter(s -> !s.isEmpty()).collect(Collectors.toList());
            List<String> target = Core.getSegmenter().segment(this.trgLang, (String)e.getValue(), null, null).stream().filter(s -> !s.isEmpty()).collect(Collectors.toList());
            return Aligner.doAlign(this.algorithmClass, this.calculatorType, this.counterType, source, target);
        }).flatMap(Collection::stream);
    }

    private Stream<Alignment> alignHeapwise(boolean doSegmenting) {
        List<String> srcSegs = doSegmenting ? this.segmentAll(this.srcLang, this.srcRaw) : this.srcRaw;
        List<String> trgSegs = doSegmenting ? this.segmentAll(this.trgLang, this.trgRaw) : this.trgRaw;
        return Aligner.doAlign(this.algorithmClass, this.calculatorType, this.counterType, srcSegs, trgSegs).stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePairsToTMX(File outFile, List<Map.Entry<String, String>> pairs) throws Exception {
        TMXWriter2 writer = null;
        String creator = OStrings.getApplicationName() + " Aligner";
        long time = System.currentTimeMillis();
        try {
            writer = new TMXWriter2(outFile, this.srcLang, this.trgLang, true, true, false);
            for (Map.Entry<String, String> e : pairs) {
                writer.writeEntry(e.getKey(), e.getValue(), null, creator, time, null, 0L, null);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception ex) {
                    Log.log(ex);
                }
            }
        }
    }

    Stream<Alignment> alignImpl() throws Exception {
        if (this.srcRaw == null || this.trgRaw == null) {
            this.loadFiles();
        }
        switch (this.comparisonMode) {
            case PARSEWISE: {
                return this.segment ? this.alignParsewiseSegmented() : this.alignParsewiseNotSegmented();
            }
            case HEAPWISE: {
                return this.alignHeapwise(this.segment);
            }
            case ID: {
                return this.segment ? this.alignByIdSegmented() : this.alignByIdNotSegmented();
            }
        }
        throw new UnsupportedOperationException("Unknown comparison mode: " + this.comparisonMode);
    }

    public List<Map.Entry<String, String>> align() throws Exception {
        return this.alignImpl().map(bead -> {
            String srcOut = Util.join(this.srcLang, bead.getSourceSegmentList());
            String trgOut = Util.join(this.trgLang, bead.getTargetSegmentList());
            return new AbstractMap.SimpleImmutableEntry<String, String>(srcOut, trgOut);
        }).collect(Collectors.toList());
    }

    private static Calculator getCalculator(CalculatorType calculatorType, CounterType counterType, List<Alignment> aligns) {
        Counter counter = Aligner.getCounter(counterType);
        switch (calculatorType) {
            case NORMAL: {
                return new NormalDistributionCalculator(counter);
            }
            case POISSON: {
                return new PoissonDistributionCalculator(counter, aligns);
            }
        }
        throw new UnsupportedOperationException("Unsupported calculator type: " + calculatorType);
    }

    private static Counter getCounter(CounterType counterType) {
        switch (counterType) {
            case CHAR: {
                return new CharCounter();
            }
            case WORD: {
                return new SplitCounter();
            }
        }
        throw new UnsupportedOperationException("Unsupported counter type: " + counterType);
    }

    private static AlignAlgorithm getAlgorithm(AlgorithmClass algorithmClass, Calculator calculator) {
        FullMatrixFactory matrixFactory = new FullMatrixFactory();
        Map map = CategoryDefaults.BEST_CATEGORY_MAP;
        switch (algorithmClass) {
            case VITERBI: {
                return new ViterbiAlgorithm(calculator, map, (MatrixFactory)matrixFactory);
            }
            case FB: {
                return new ForwardBackwardAlgorithm(calculator, map, (MatrixFactory)matrixFactory);
            }
        }
        throw new UnsupportedOperationException("Unsupported algorithm class: " + algorithmClass);
    }

    private static List<Alignment> doAlign(AlgorithmClass algorithmClass, CalculatorType calculatorType, CounterType counterType, List<String> source, List<String> target) {
        List<Alignment> aligns = Arrays.asList(new Alignment(source, target));
        Calculator calculator = Aligner.getCalculator(calculatorType, counterType, aligns);
        AlignAlgorithm algorithm = Aligner.getAlgorithm(algorithmClass, calculator);
        net.loomchild.maligna.filter.aligner.Aligner filter = new net.loomchild.maligna.filter.aligner.Aligner(algorithm);
        return filter.apply(aligns);
    }

    List<MutableBead> doAlign(List<MutableBead> beads) {
        ArrayList<String> source = new ArrayList<String>();
        ArrayList<String> target = new ArrayList<String>();
        for (MutableBead bead : beads) {
            source.addAll(bead.sourceLines);
            target.addAll(bead.targetLines);
        }
        return Aligner.doAlign(this.algorithmClass, this.calculatorType, this.counterType, source, target).stream().map(MutableBead::new).collect(Collectors.toList());
    }

    static enum CounterType {
        CHAR,
        WORD;

    }

    static enum CalculatorType {
        NORMAL,
        POISSON;

    }

    static enum AlgorithmClass {
        VITERBI,
        FB;

    }

    static enum ComparisonMode {
        HEAPWISE,
        PARSEWISE,
        ID;

    }
}

