/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.autotext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.omegat.core.Core;
import org.omegat.gui.editor.autocompleter.AutoCompleterItem;
import org.omegat.gui.editor.autocompleter.AutoCompleterListView;
import org.omegat.gui.editor.autotext.Autotext;
import org.omegat.tokenizer.DefaultTokenizer;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;

public class AutotextAutoCompleterView
extends AutoCompleterListView {
    public AutotextAutoCompleterView() {
        super(OStrings.getString("AC_AUTOTEXT_VIEW"));
    }

    @Override
    public List<AutoCompleterItem> computeListData(String prevText, boolean contextualOnly) {
        List<Autotext.AutotextItem> items = Autotext.getItems();
        ArrayList<AutoCompleterItem> result = new ArrayList<AutoCompleterItem>();
        for (Autotext.AutotextItem s : items) {
            if (!prevText.endsWith(s.source)) continue;
            result.add(new AutoCompleterItem(s.target, new String[]{s.source, s.comment}, s.source.length()));
        }
        if (!Core.getProject().getProjectProperties().getTargetLanguage().isSpaceDelimited() && result.isEmpty() && !contextualOnly) {
            for (Autotext.AutotextItem s : items) {
                result.add(new AutoCompleterItem(s.target, new String[]{s.source, s.comment}, 0));
            }
        }
        Collections.sort(result, new AutotextComparator());
        return result;
    }

    @Override
    public String itemToString(AutoCompleterItem item) {
        StringBuilder b = new StringBuilder();
        if (item.extras != null && item.extras.length > 0 && item.extras[0] != null && !item.extras[0].isEmpty()) {
            b.append(item.extras[0]).append(" \u2192 ");
        }
        if (item.payload != null) {
            b.append(item.payload);
        }
        if (item.extras != null && item.extras.length > 1 && item.extras[1] != null && !item.extras[1].isEmpty()) {
            b.append(" (").append(item.extras[1]).append(")");
        }
        return b.toString();
    }

    @Override
    public ITokenizer getTokenizer() {
        return new DefaultTokenizer();
    }

    @Override
    protected boolean isEnabled() {
        return Preferences.isPreferenceDefault("ac_autotext_enabled", true);
    }

    class AutotextComparator
    implements Comparator<AutoCompleterItem> {
        private boolean byLength = Preferences.isPreference("ac_autotext_sort_by_length");
        private boolean alphabetically = Preferences.isPreference("ac_autotext_sort_alphabetically");
        private boolean sortFullText = Preferences.isPreference("ac_autotext_sort_full_text");

        AutotextComparator() {
        }

        @Override
        public int compare(AutoCompleterItem o1, AutoCompleterItem o2) {
            if (this.byLength) {
                if (o1.payload.length() < o2.payload.length()) {
                    return 1;
                }
                if (o1.payload.length() > o2.payload.length()) {
                    return -1;
                }
            }
            if (this.alphabetically) {
                if (this.sortFullText) {
                    return o1.payload.compareTo(o2.payload);
                }
                return AutotextAutoCompleterView.this.itemToString(o1).compareTo(AutotextAutoCompleterView.this.itemToString(o2));
            }
            return 0;
        }
    }
}

