/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import gen.core.filters.Filters;
import java.awt.Window;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemLoopException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.madlonkay.supertmxmerge.StmProperties;
import org.madlonkay.supertmxmerge.SuperTmxMerge;
import org.madlonkay.supertmxmerge.data.ITmx;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.KnownException;
import org.omegat.core.data.CommandVarExpansion;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.ExternalTMFactory;
import org.omegat.core.data.ExternalTMX;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ITMXEntry;
import org.omegat.core.data.ImportFromAutoTMX;
import org.omegat.core.data.LastSegmentManager;
import org.omegat.core.data.ParseEntry;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SegmentProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.SyncTMX;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.data.TranslateEntry;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.matching.external.IExternalMemory;
import org.omegat.core.matching.external.IWritableExternalMemory;
import org.omegat.core.segmentation.SRX;
import org.omegat.core.segmentation.Segmenter;
import org.omegat.core.statistics.CalcStandardStatistics;
import org.omegat.core.statistics.Statistics;
import org.omegat.core.statistics.StatisticsInfo;
import org.omegat.core.statistics.StatsResult;
import org.omegat.core.team2.IRemoteRepository2;
import org.omegat.core.team2.RebaseAndCommit;
import org.omegat.core.team2.RemoteRepositoryProvider;
import org.omegat.core.threads.CommandMonitor;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IAlignCallback;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryReaderTSV;
import org.omegat.tokenizer.DefaultTokenizer;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.DirectoryMonitor;
import org.omegat.util.FileUtil;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.omegat.util.ProjectFileStorage;
import org.omegat.util.RuntimePreferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StreamUtil;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXReader2;
import org.omegat.util.TagUtil;
import org.omegat.util.gui.UIThreadsUtil;
import org.xml.sax.SAXParseException;

public class RealProject
implements IProject {
    private static final Logger LOGGER = Logger.getLogger(RealProject.class.getName());
    protected final ProjectProperties config;
    protected final RemoteRepositoryProvider remoteRepositoryProvider;
    private volatile PreparedStatus preparedStatus = PreparedStatus.NONE;
    private volatile RebaseAndCommit.Prepared tmxPrepared;
    private volatile RebaseAndCommit.Prepared glossaryPrepared;
    private boolean isOnlineMode;
    private RandomAccessFile raFile;
    private FileChannel lockChannel;
    private FileLock lock;
    private boolean modified;
    protected List<SourceTextEntry> allProjectEntries = new ArrayList<SourceTextEntry>(4096);
    protected ImportFromAutoTMX importHandler;
    private final StatisticsInfo hotStat = new StatisticsInfo();
    private final ITokenizer sourceTokenizer;
    private final ITokenizer targetTokenizer;
    private DirectoryMonitor tmMonitor;
    private DirectoryMonitor tmOtherLanguagesMonitor;
    private boolean isSaving = false;
    private Map<String, IExternalMemory> transMemories = new TreeMap<String, IExternalMemory>();
    private Set<IWritableExternalMemory> updatedExternalMemories = new HashSet<IWritableExternalMemory>();
    private Map<Language, ProjectTMX> otherTargetLangTMs = new TreeMap<Language, ProjectTMX>();
    protected ProjectTMX projectTMX;
    private boolean loaded = false;
    private Set<String> existSource = new HashSet<String>();
    private Set<EntryKey> existKeys = new HashSet<EntryKey>();
    protected List<IProject.FileInfo> projectFilesList = new ArrayList<IProject.FileInfo>();
    private static final TMXEntry EMPTY_TRANSLATION;
    private final boolean allowTranslationEqualToSource = Preferences.isPreference("wf_allowTransEqualToSrc");
    private final Stack<Process> processCache = new Stack();
    ProjectTMX.CheckOrphanedCallback checkOrphanedCallback = new ProjectTMX.CheckOrphanedCallback(){

        @Override
        public boolean existSourceInProject(String src) {
            return RealProject.this.existSource.contains(src);
        }

        @Override
        public boolean existEntryInProject(EntryKey key) {
            return RealProject.this.existKeys.contains(key);
        }
    };

    public RealProject(ProjectProperties props) {
        this.config = props;
        if (this.config.getRepositories() != null && !Core.getParams().containsKey("no-team")) {
            try {
                this.remoteRepositoryProvider = new RemoteRepositoryProvider(this.config.getProjectRootDir(), this.config.getRepositories(), this.config);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            this.remoteRepositoryProvider = null;
        }
        this.sourceTokenizer = this.createTokenizer(Core.getParams().get("ITokenizer"), props.getSourceTokenizer());
        Log.log("Source tokenizer: " + this.sourceTokenizer.getClass().getName());
        this.targetTokenizer = this.createTokenizer(Core.getParams().get("ITokenizerTarget"), props.getTargetTokenizer());
        Log.log("Target tokenizer: " + this.targetTokenizer.getClass().getName());
    }

    @Override
    public void saveProjectProperties() throws Exception {
        this.unlockProject();
        try {
            SRX.saveTo(this.config.getProjectSRX(), new File(this.config.getProjectInternal(), "segmentation.conf"));
            FilterMaster.saveConfig(this.config.getProjectFilters(), new File(this.config.getProjectInternal(), "filters.xml"));
            ProjectFileStorage.writeProjectFile(this.config);
        }
        finally {
            this.lockProject();
        }
        Preferences.setPreference("source_lang", this.config.getSourceLanguage().toString());
        Preferences.setPreference("target_lang", this.config.getTargetLanguage().toString());
    }

    public void createProject() {
        Log.logInfoRB("LOG_DATAENGINE_CREATE_START", new Object[0]);
        UIThreadsUtil.mustNotBeSwingThread();
        try {
            if (!this.lockProject()) {
                throw new KnownException("PROJECT_LOCKED", new Object[0]);
            }
            this.createDirectory(this.config.getProjectRoot(), null);
            this.createDirectory(this.config.getProjectInternal(), "omegat");
            this.createDirectory(this.config.getSourceRoot(), "source");
            this.createDirectory(this.config.getGlossaryRoot(), "glossary");
            this.createDirectory(this.config.getTMRoot(), "tm");
            this.createDirectory(this.config.getTMAutoRoot(), "auto");
            this.createDirectory(this.config.getTMEnforceRoot(), "enforce");
            this.createDirectory(this.config.getTMMTRoot(), "mt");
            this.createDirectory(this.config.getTMPenaltyRoot(), "penalty-xxx");
            this.createDirectory(this.config.getTMOtherLangRoot(), "tmx2source");
            this.createDirectory(this.config.getDictRoot(), "dictionary");
            this.createDirectory(this.config.getTargetRoot(), "target");
            this.saveProjectProperties();
            SRX srx = this.config.getProjectSRX();
            Core.setSegmenter(new Segmenter(srx == null ? Preferences.getSRX() : srx));
            this.loadTranslations();
            this.setProjectModified(true);
            this.saveProject(false);
            this.loadSourceFiles();
            this.allProjectEntries = Collections.unmodifiableList(this.allProjectEntries);
            this.importHandler = new ImportFromAutoTMX(this, this.allProjectEntries);
            this.importTranslationsFromSources();
            this.loadTM();
            this.loadOtherLanguages();
            this.loaded = true;
            Core.getMainWindow().showStatusMessageRB(null, new Object[0]);
        }
        catch (Exception e) {
            Log.logErrorRB(e, "CT_ERROR_CREATING_PROJECT", new Object[0]);
            Core.getMainWindow().displayErrorRB(e, "CT_ERROR_CREATING_PROJECT", new Object[0]);
        }
        Log.logInfoRB("LOG_DATAENGINE_CREATE_END", new Object[0]);
    }

    public synchronized void loadProject(boolean onlineMode) {
        block14: {
            Log.logInfoRB("LOG_DATAENGINE_LOAD_START", new Object[0]);
            UIThreadsUtil.mustNotBeSwingThread();
            try {
                if (!this.lockProject()) {
                    throw new KnownException("PROJECT_LOCKED", new Object[0]);
                }
                this.isOnlineMode = onlineMode;
                if (RuntimePreferences.isLocationSaveEnabled()) {
                    Preferences.setPreference("current_folder", new File(this.config.getProjectRoot()).getAbsoluteFile().getParent());
                    Preferences.save();
                }
                Core.getMainWindow().showStatusMessageRB("CT_LOADING_PROJECT", new Object[0]);
                if (this.remoteRepositoryProvider != null) {
                    try {
                        this.tmxPrepared = null;
                        this.glossaryPrepared = null;
                        this.remoteRepositoryProvider.switchAllToLatest();
                    }
                    catch (IRemoteRepository2.NetworkException e) {
                        Log.logErrorRB("TEAM_NETWORK_ERROR", e.getCause());
                        this.setOfflineMode();
                    }
                    this.remoteRepositoryProvider.copyFilesFromReposToProject("");
                    this.config.loadProjectFilters();
                    this.config.loadProjectSRX();
                }
                this.loadFilterSettings();
                this.loadSegmentationSettings();
                this.loadTranslations();
                if (this.remoteRepositoryProvider != null && this.isOnlineMode) {
                    Core.getMainWindow().showStatusMessageRB("TEAM_REBASE_AND_COMMIT", new Object[0]);
                    this.rebaseAndCommitProject(true);
                }
                try {
                    this.loadSourceFiles();
                }
                catch (UncheckedIOException e) {
                    if (e.getCause() != null && e.getCause() instanceof FileSystemLoopException) {
                        Log.logErrorRB(e.getCause(), "TF_LOAD_ERROR_SOURCE_LOOP_EXCEPTION", new Object[0]);
                        Core.getMainWindow().displayErrorRB(e.getCause(), "TF_LOAD_ERROR_SOURCE_LOOP_EXCEPTION", new Object[0]);
                    } else {
                        Log.logErrorRB(e, "TF_LOAD_ERROR_FILE_ACCESS", new Object[0]);
                        Core.getMainWindow().displayErrorRB(e, "TF_LOAD_ERROR_FILE_ACCESS", new Object[0]);
                    }
                    if (!this.loaded) {
                        this.unlockProject();
                    }
                    Log.logInfoRB("LOG_DATAENGINE_LOAD_END", new Object[0]);
                    return;
                }
                this.allProjectEntries = Collections.unmodifiableList(this.allProjectEntries);
                this.importHandler = new ImportFromAutoTMX(this, this.allProjectEntries);
                this.importTranslationsFromSources();
                this.loadTM();
                this.loadOtherLanguages();
                StatsResult stat = CalcStandardStatistics.buildProjectStats(this);
                stat.updateStatisticsInfo(this.hotStat);
                String fn = this.config.getProjectInternal() + "project_stats.txt";
                Statistics.writeStat(fn, stat.getTextData());
                this.loaded = true;
                Core.getMainWindow().showStatusMessageRB(null, new Object[0]);
                this.setProjectModified(false);
            }
            catch (OutOfMemoryError oome) {
                this.allProjectEntries.clear();
                this.projectFilesList.clear();
                this.transMemories.clear();
                this.projectTMX = null;
                long memory = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
                Log.logErrorRB("OUT_OF_MEMORY", memory);
                Log.log(oome);
                Core.getMainWindow().showErrorDialogRB("TF_ERROR", "OUT_OF_MEMORY", memory);
                System.exit(0);
            }
            catch (Throwable e) {
                Log.logErrorRB(e, "TF_LOAD_ERROR", new Object[0]);
                Core.getMainWindow().displayErrorRB(e, "TF_LOAD_ERROR", new Object[0]);
                if (this.loaded) break block14;
                this.unlockProject();
            }
        }
        Log.logInfoRB("LOG_DATAENGINE_LOAD_END", new Object[0]);
    }

    private void loadFilterSettings() {
        Filters filters = Optional.ofNullable(this.config.getProjectFilters()).orElse(Preferences.getFilters());
        Core.setFilterMaster(new FilterMaster(filters));
    }

    private void loadSegmentationSettings() {
        SRX srx = Optional.ofNullable(this.config.getProjectSRX()).orElse(Preferences.getSRX());
        Core.setSegmenter(new Segmenter(srx));
    }

    public Map<EntryKey, ITMXEntry> align(ProjectProperties props, File translatedDir) throws Exception {
        FilterMaster fm = Core.getFilterMaster();
        File root = new File(this.config.getSourceRoot());
        List<File> srcFileList = FileUtil.buildFileList(root, true);
        AlignFilesCallback alignFilesCallback = new AlignFilesCallback(props);
        String srcRoot = this.config.getSourceRoot();
        for (File file : srcFileList) {
            String midName = file.getPath().substring(srcRoot.length());
            fm.alignFile(root.toString(), midName, translatedDir.getPath(), new FilterContext(props), alignFilesCallback);
        }
        return alignFilesCallback.data;
    }

    @Override
    public boolean isProjectLoaded() {
        return this.loaded;
    }

    @Override
    public StatisticsInfo getStatistics() {
        return this.hotStat;
    }

    @Override
    public void closeProject() {
        this.loaded = false;
        this.flushProcessCache();
        this.tmMonitor.fin();
        this.tmOtherLanguagesMonitor.fin();
        this.unlockProject();
        Log.logInfoRB("LOG_DATAENGINE_CLOSE", new Object[0]);
    }

    protected boolean lockProject() {
        if (!RuntimePreferences.isProjectLockingEnabled()) {
            return true;
        }
        try {
            File lockFile = new File(this.config.getProjectRoot(), "omegat.project");
            this.raFile = new RandomAccessFile(lockFile, "rw");
            this.lockChannel = this.raFile.getChannel();
            this.lock = this.lockChannel.tryLock();
        }
        catch (Throwable ex) {
            Log.log(ex);
        }
        if (this.lock == null) {
            try {
                this.lockChannel.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.lockChannel = null;
            try {
                this.raFile.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.raFile = null;
            return false;
        }
        return true;
    }

    protected void unlockProject() {
        if (!RuntimePreferences.isProjectLockingEnabled()) {
            return;
        }
        try {
            if (this.lock != null) {
                this.lock.release();
            }
            if (this.lockChannel != null) {
                this.lockChannel.close();
            }
            if (this.raFile != null) {
                this.raFile.close();
            }
        }
        catch (Throwable ex) {
            Log.log(ex);
        }
        finally {
            try {
                this.lockChannel.close();
            }
            catch (Throwable throwable) {}
            try {
                this.raFile.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void compileProject(String sourcePattern) throws Exception {
        this.compileProject(sourcePattern, true);
    }

    public void compileProject(String sourcePattern, boolean doPostProcessing) throws Exception {
        this.compileProjectAndCommit(sourcePattern, doPostProcessing, false);
    }

    @Override
    public void compileProjectAndCommit(String sourcePattern, boolean doPostProcessing, boolean commitTargetFiles) throws Exception {
        Log.logInfoRB("LOG_DATAENGINE_COMPILE_START", new Object[0]);
        UIThreadsUtil.mustNotBeSwingThread();
        Pattern filePattern = Pattern.compile(sourcePattern);
        try {
            String fname;
            if (this.config.isExportTm("omegat")) {
                fname = this.config.getExportTMRoot() + this.config.getProjectName() + "-omegat.tmx";
                this.projectTMX.exportTMX(this.config, new File(fname), false, false, false);
            }
            if (this.config.isExportTm("level1")) {
                fname = this.config.getExportTMRoot() + this.config.getProjectName() + "-level1.tmx";
                this.projectTMX.exportTMX(this.config, new File(fname), true, false, false);
            }
            if (this.config.isExportTm("level2")) {
                fname = this.config.getExportTMRoot() + this.config.getProjectName() + "-level2.tmx";
                this.projectTMX.exportTMX(this.config, new File(fname), false, true, false);
            }
        }
        catch (Exception e) {
            Log.logErrorRB("CT_ERROR_CREATING_TMX", new Object[0]);
            Log.log(e);
            throw new IOException(OStrings.getString("CT_ERROR_CREATING_TMX") + "\n" + e.getMessage());
        }
        String srcRoot = this.config.getSourceRoot();
        String locRoot = this.config.getTargetRoot();
        FilterMaster fm = Core.getFilterMaster();
        List<String> pathList = FileUtil.buildRelativeFilesList(new File(srcRoot), Collections.emptyList(), this.config.getSourceRootExcludes());
        TranslateFilesCallback translateFilesCallback = new TranslateFilesCallback();
        int numberOfCompiled = 0;
        for (String midName : pathList) {
            Matcher fileMatch = filePattern.matcher(midName);
            if (!fileMatch.matches()) continue;
            File fn = new File(locRoot, midName);
            if (!fn.getParentFile().exists() && !fn.getParentFile().mkdirs()) {
                throw new IOException(OStrings.getString("CT_ERROR_CREATING_TARGET_DIR") + fn.getParentFile());
            }
            Core.getMainWindow().showStatusMessageRB("CT_COMPILE_FILE_MX", midName);
            translateFilesCallback.fileStarted(midName);
            fm.translateFile(srcRoot, midName, locRoot, new FilterContext(this.config), translateFilesCallback);
            translateFilesCallback.fileFinished();
            ++numberOfCompiled;
        }
        if (this.remoteRepositoryProvider != null && this.config.getTargetDir().isUnderRoot() && commitTargetFiles && this.isOnlineMode) {
            this.tmxPrepared = null;
            this.glossaryPrepared = null;
            try {
                Core.getMainWindow().showStatusMessageRB("TF_COMMIT_TARGET_START", new Object[0]);
                this.remoteRepositoryProvider.switchAllToLatest();
                this.remoteRepositoryProvider.copyFilesFromProjectToRepos(this.config.getTargetDir().getUnderRoot(), null);
                this.remoteRepositoryProvider.commitFiles(this.config.getTargetDir().getUnderRoot(), "Project translation");
                Core.getMainWindow().showStatusMessageRB("TF_COMMIT_TARGET_DONE", new Object[0]);
            }
            catch (Exception e) {
                Log.logErrorRB("TF_COMMIT_TARGET_ERROR", new Object[0]);
                Log.log(e);
                throw new IOException(OStrings.getString("TF_COMMIT_TARGET_ERROR") + "\n" + e.getMessage());
            }
        }
        if (numberOfCompiled == 1) {
            Core.getMainWindow().showStatusMessageRB("CT_COMPILE_DONE_MX_SINGULAR", new Object[0]);
        } else {
            Core.getMainWindow().showStatusMessageRB("CT_COMPILE_DONE_MX", new Object[0]);
        }
        CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.COMPILE);
        if (doPostProcessing) {
            this.flushProcessCache();
            if (Preferences.isPreference("allow_project_extern_cmd")) {
                this.doExternalCommand(this.config.getExternalCommand());
            }
            this.doExternalCommand(Preferences.getPreference("external_command"));
        }
        Log.logInfoRB("LOG_DATAENGINE_COMPILE_END", new Object[0]);
    }

    private void doExternalCommand(String command) {
        if (StringUtil.isEmpty(command)) {
            return;
        }
        Core.getMainWindow().showStatusMessageRB("CT_START_EXTERNAL_CMD", new Object[0]);
        CommandVarExpansion expander = new CommandVarExpansion(command);
        command = expander.expandVariables(this.config);
        Log.log("Executing command: " + command);
        try {
            Process p = Runtime.getRuntime().exec(StaticUtils.parseCLICommand(command));
            this.processCache.push(p);
            CommandMonitor stdout = CommandMonitor.newStdoutMonitor(p);
            CommandMonitor stderr = CommandMonitor.newStderrMonitor(p);
            stdout.start();
            stderr.start();
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            String message = cause == null ? e.getLocalizedMessage() : cause.getLocalizedMessage();
            Core.getMainWindow().showStatusMessageRB("CT_ERROR_STARTING_EXTERNAL_CMD", message);
        }
    }

    private void flushProcessCache() {
        while (!this.processCache.isEmpty()) {
            Process p = this.processCache.pop();
            try {
                p.exitValue();
            }
            catch (IllegalThreadStateException ex) {
                p.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void saveProject(boolean doTeamSync) {
        if (this.isSaving) {
            return;
        }
        this.isSaving = true;
        Log.logInfoRB("LOG_DATAENGINE_SAVE_START", new Object[0]);
        UIThreadsUtil.mustNotBeSwingThread();
        Core.getAutoSave().disable();
        try {
            Core.getMainWindow().getMainMenu().getProjectMenu().setEnabled(false);
            try {
                Preferences.save();
                try {
                    this.saveProjectProperties();
                    this.projectTMX.save(this.config, this.config.getProjectInternal() + "project_save.tmx", this.isProjectModified());
                    if (this.remoteRepositoryProvider != null && doTeamSync) {
                        this.tmxPrepared = null;
                        this.glossaryPrepared = null;
                        this.remoteRepositoryProvider.cleanPrepared();
                        Core.getMainWindow().showStatusMessageRB("TEAM_SYNCHRONIZE", new Object[0]);
                        this.rebaseAndCommitProject(true);
                        this.setOnlineMode();
                    }
                    this.setProjectModified(false);
                }
                catch (KnownException ex) {
                    throw ex;
                }
                catch (IRemoteRepository2.NetworkException e) {
                    if (this.isOnlineMode) {
                        Log.logErrorRB("TEAM_NETWORK_ERROR", e.getCause());
                        this.setOfflineMode();
                    }
                }
                catch (Exception e) {
                    Log.logErrorRB(e, "CT_ERROR_SAVING_PROJ", new Object[0]);
                    Core.getMainWindow().displayErrorRB(e, "CT_ERROR_SAVING_PROJ", new Object[0]);
                }
                LastSegmentManager.saveLastSegment();
                StatsResult stat = CalcStandardStatistics.buildProjectStats(this);
                stat.updateStatisticsInfo(this.hotStat);
                String fn = this.config.getProjectInternal() + "project_stats.txt";
                Statistics.writeStat(fn, stat.getTextData());
            }
            finally {
                Core.getMainWindow().getMainMenu().getProjectMenu().setEnabled(true);
            }
            CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.SAVE);
        }
        finally {
            Core.getAutoSave().enable();
        }
        Log.logInfoRB("LOG_DATAENGINE_SAVE_END", new Object[0]);
        this.isSaving = false;
    }

    @Override
    public void teamSyncPrepare() throws Exception {
        String glossaryPath;
        if (this.remoteRepositoryProvider == null || this.preparedStatus != PreparedStatus.NONE || !this.isOnlineMode) {
            return;
        }
        LOGGER.fine("Prepare team sync");
        this.tmxPrepared = null;
        this.glossaryPrepared = null;
        this.remoteRepositoryProvider.cleanPrepared();
        String tmxPath = this.config.getProjectInternalRelative() + "project_save.tmx";
        if (this.remoteRepositoryProvider.isUnderMapping(tmxPath)) {
            this.tmxPrepared = RebaseAndCommit.prepare(this.remoteRepositoryProvider, this.config.getProjectRootDir(), tmxPath);
        }
        if ((glossaryPath = this.config.getWritableGlossaryFile().getUnderRoot()) != null && this.remoteRepositoryProvider.isUnderMapping(glossaryPath)) {
            this.glossaryPrepared = RebaseAndCommit.prepare(this.remoteRepositoryProvider, this.config.getProjectRootDir(), glossaryPath);
        }
        this.preparedStatus = PreparedStatus.PREPARED;
    }

    @Override
    public boolean isTeamSyncPrepared() {
        return this.preparedStatus == PreparedStatus.PREPARED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void teamSync() {
        if (this.remoteRepositoryProvider == null || this.preparedStatus != PreparedStatus.PREPARED) {
            return;
        }
        LOGGER.fine("Rebase team sync");
        try {
            this.preparedStatus = PreparedStatus.PREPARED2;
            RealProject realProject = this;
            synchronized (realProject) {
                this.projectTMX.save(this.config, this.config.getProjectInternal() + "project_save.tmx", this.isProjectModified());
            }
            this.rebaseAndCommitProject(this.glossaryPrepared != null);
            this.preparedStatus = PreparedStatus.REBASED;
            new Thread(() -> {
                try {
                    Core.executeExclusively(true, () -> {
                        if (this.preparedStatus != PreparedStatus.REBASED) {
                            return;
                        }
                        LOGGER.fine("Commit team sync");
                        try {
                            String newVersion = RebaseAndCommit.commitPrepared(this.tmxPrepared, this.remoteRepositoryProvider, null);
                            if (this.glossaryPrepared != null) {
                                RebaseAndCommit.commitPrepared(this.glossaryPrepared, this.remoteRepositoryProvider, newVersion);
                            }
                            this.tmxPrepared = null;
                            this.glossaryPrepared = null;
                            this.remoteRepositoryProvider.cleanPrepared();
                        }
                        catch (Exception ex) {
                            Log.logErrorRB(ex, "CT_ERROR_SAVING_PROJ", new Object[0]);
                        }
                        this.preparedStatus = PreparedStatus.NONE;
                    });
                }
                catch (Exception ex) {
                    Log.logErrorRB(ex, "CT_ERROR_SAVING_PROJ", new Object[0]);
                }
            }).start();
        }
        catch (Exception ex) {
            Log.logErrorRB(ex, "CT_ERROR_SAVING_PROJ", new Object[0]);
            this.preparedStatus = PreparedStatus.NONE;
        }
    }

    private void rebaseAndCommitProject(boolean processGlossary) throws Exception {
        Log.logInfoRB("TEAM_REBASE_START", new Object[0]);
        String author = Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name"));
        final StringBuilder commitDetails = new StringBuilder("Translated by " + author);
        String tmxPath = this.config.getProjectInternalRelative() + "project_save.tmx";
        if (this.remoteRepositoryProvider.isUnderMapping(tmxPath)) {
            RebaseAndCommit.rebaseAndCommit(this.tmxPrepared, this.remoteRepositoryProvider, this.config.getProjectRootDir(), tmxPath, new RebaseAndCommit.IRebase(){
                ProjectTMX baseTMX;
                ProjectTMX headTMX;

                @Override
                public void parseBaseFile(File file) throws Exception {
                    this.baseTMX = new ProjectTMX(RealProject.this.config.getSourceLanguage(), RealProject.this.config.getTargetLanguage(), RealProject.this.config.isSentenceSegmentingEnabled(), file, null);
                }

                @Override
                public void parseHeadFile(File file) throws Exception {
                    this.headTMX = new ProjectTMX(RealProject.this.config.getSourceLanguage(), RealProject.this.config.getTargetLanguage(), RealProject.this.config.isSentenceSegmentingEnabled(), file, null);
                }

                @Override
                public void rebaseAndSave(File out) throws Exception {
                    RealProject.this.mergeTMX(this.baseTMX, this.headTMX, commitDetails);
                    RealProject.this.projectTMX.exportTMX(RealProject.this.config, out, false, false, true);
                }

                @Override
                public String getCommentForCommit() {
                    return commitDetails.toString();
                }

                @Override
                public String getFileCharset(File file) throws Exception {
                    return TMXReader2.detectCharset(file);
                }
            });
            if (this.projectTMX != null) {
                ProjectTMX newTMX = new ProjectTMX(this.config.getSourceLanguage(), this.config.getTargetLanguage(), this.config.isSentenceSegmentingEnabled(), new File(this.config.getProjectInternalDir(), "project_save.tmx"), null);
                this.projectTMX.replaceContent(newTMX);
            }
        }
        if (processGlossary) {
            String glossaryPath = this.config.getWritableGlossaryFile().getUnderRoot();
            File glossaryFile = this.config.getWritableGlossaryFile().getAsFile();
            new File(this.config.getProjectRootDir(), glossaryPath);
            if (glossaryPath != null && this.remoteRepositoryProvider.isUnderMapping(glossaryPath)) {
                final List<Object> glossaryEntries = glossaryFile.exists() ? GlossaryReaderTSV.read(glossaryFile, true) : Collections.emptyList();
                RebaseAndCommit.rebaseAndCommit(this.glossaryPrepared, this.remoteRepositoryProvider, this.config.getProjectRootDir(), glossaryPath, new RebaseAndCommit.IRebase(){
                    List<GlossaryEntry> baseGlossaryEntries;
                    List<GlossaryEntry> headGlossaryEntries;

                    @Override
                    public void parseBaseFile(File file) throws Exception {
                        this.baseGlossaryEntries = file.exists() ? GlossaryReaderTSV.read(file, true) : new ArrayList<GlossaryEntry>();
                    }

                    @Override
                    public void parseHeadFile(File file) throws Exception {
                        this.headGlossaryEntries = file.exists() ? GlossaryReaderTSV.read(file, true) : new ArrayList<GlossaryEntry>();
                    }

                    @Override
                    public void rebaseAndSave(File out) throws Exception {
                        ArrayList deltaAddedGlossaryLocal = new ArrayList(glossaryEntries);
                        deltaAddedGlossaryLocal.removeAll(this.baseGlossaryEntries);
                        ArrayList<GlossaryEntry> deltaRemovedGlossaryLocal = new ArrayList<GlossaryEntry>(this.baseGlossaryEntries);
                        deltaRemovedGlossaryLocal.removeAll(glossaryEntries);
                        this.headGlossaryEntries.addAll(deltaAddedGlossaryLocal);
                        this.headGlossaryEntries.removeAll(deltaRemovedGlossaryLocal);
                        for (GlossaryEntry ge : this.headGlossaryEntries) {
                            GlossaryReaderTSV.append(out, ge);
                        }
                    }

                    @Override
                    public String getCommentForCommit() {
                        String author = Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name"));
                        return "Glossary changes by " + author;
                    }

                    @Override
                    public String getFileCharset(File file) throws Exception {
                        return GlossaryReaderTSV.getFileEncoding(file);
                    }
                });
            }
        }
        Log.logInfoRB("TEAM_REBASE_END", new Object[0]);
    }

    protected void mergeTMX(ProjectTMX baseTMX, ProjectTMX headTMX, StringBuilder commitDetails) {
        StmProperties props = new StmProperties().setLanguageResource(OStrings.getResourceBundle()).setParentWindow((Window)Core.getMainWindow().getApplicationFrame()).setListViewThreshold(5);
        String srcLang = this.config.getSourceLanguage().getLanguage();
        String trgLang = this.config.getTargetLanguage().getLanguage();
        ProjectTMX mergedTMX = SuperTmxMerge.merge((ITmx)new SyncTMX(baseTMX, OStrings.getString("TMX_MERGE_BASE"), srcLang, trgLang), (ITmx)new SyncTMX(this.projectTMX, OStrings.getString("TMX_MERGE_MINE"), srcLang, trgLang), (ITmx)new SyncTMX(headTMX, OStrings.getString("TMX_MERGE_THEIRS"), srcLang, trgLang), (StmProperties)props);
        this.projectTMX.replaceContent(mergedTMX);
        Log.logDebug(LOGGER, "Merge report: {0}", props.getReport());
        commitDetails.append('\n');
        commitDetails.append(props.getReport().toString());
    }

    private void createDirectory(String dir, String dirType) throws IOException {
        File d = new File(dir);
        if (!d.isDirectory() && !d.mkdirs()) {
            StringBuilder msg = new StringBuilder(OStrings.getString("CT_ERROR_CREATE"));
            if (dirType != null) {
                msg.append("\n(.../").append(dirType).append("/)");
            }
            throw new IOException(msg.toString());
        }
    }

    private void loadTranslations() throws Exception {
        File file = new File(this.config.getProjectInternalDir(), "project_save.tmx");
        try {
            Core.getMainWindow().showStatusMessageRB("CT_LOAD_TMX", new Object[0]);
            this.projectTMX = new ProjectTMX(this.config.getSourceLanguage(), this.config.getTargetLanguage(), this.config.isSentenceSegmentingEnabled(), file, this.checkOrphanedCallback);
        }
        catch (SAXParseException ex) {
            Log.logErrorRB(ex, "TMXR_FATAL_ERROR_WHILE_PARSING", ex.getLineNumber(), ex.getColumnNumber());
            throw ex;
        }
        catch (Exception ex) {
            Log.logErrorRB(ex, "TMXR_EXCEPTION_WHILE_PARSING", file.getAbsolutePath(), Log.getLogLocation());
            throw ex;
        }
        if (file.exists()) {
            File backup = FileUtil.backupFile(file);
            FileUtil.removeOldBackups(file, 11);
            Core.getMainWindow().showStatusMessageRB("CT_LOAD_TMX_CREATE_BACKUP", backup.getName());
        } else {
            Core.getMainWindow().showStatusMessageRB("CT_LOAD_TMX_START_NEW", new Object[0]);
        }
    }

    private void loadSourceFiles() throws Exception {
        long st = System.currentTimeMillis();
        FilterMaster fm = Core.getFilterMaster();
        File root = new File(this.config.getSourceRoot());
        List srcPathList = FileUtil.buildRelativeFilesList(root, Collections.emptyList(), this.config.getSourceRootExcludes()).stream().sorted(StreamUtil.comparatorByList(this.getSourceFilesOrder())).collect(Collectors.toList());
        ArrayList<String> errorSrcList = new ArrayList<String>();
        for (String filepath : srcPathList) {
            Core.getMainWindow().showStatusMessageRB("CT_LOAD_FILE_MX", filepath);
            LoadFilesCallback loadFilesCallback = new LoadFilesCallback(this.existSource, this.existKeys, this.transMemories);
            IProject.FileInfo fi = new IProject.FileInfo();
            fi.filePath = filepath;
            try {
                loadFilesCallback.setCurrentFile(fi);
                IFilter filter = fm.loadFile(this.config.getSourceRoot() + filepath, new FilterContext(this.config), loadFilesCallback);
                loadFilesCallback.fileFinished();
                if (filter == null || fi.entries.isEmpty()) continue;
                fi.filterClass = filter.getClass();
                fi.filterFileFormatName = filter.getFileFormatName();
                try {
                    fi.fileEncoding = filter.getInEncodingLastParsedFile();
                }
                catch (Error e) {
                    fi.fileEncoding = "";
                }
                this.projectFilesList.add(fi);
            }
            catch (TranslationException e) {
                Log.logErrorRB("TF_SOURCE_LOAD_ERROR", e.getLocalizedMessage());
                Core.getMainWindow().displayErrorRB(e, "TF_SOURCE_LOAD_ERROR", filepath);
                errorSrcList.add(filepath);
            }
        }
        this.findNonUniqueSegments();
        if (errorSrcList.size() > 0) {
            Core.getMainWindow().showStatusMessageRB("CT_LOAD_SRC_SKIP_FILES", new Object[0]);
        } else {
            Core.getMainWindow().showStatusMessageRB("CT_LOAD_SRC_COMPLETE", new Object[0]);
        }
        long en = System.currentTimeMillis();
        Log.log("Load project source files: " + (en - st) + "ms");
    }

    protected void findNonUniqueSegments() {
        HashMap<String, SourceTextEntry> exists = new HashMap<String, SourceTextEntry>(16384);
        for (IProject.FileInfo fi : this.projectFilesList) {
            for (int i = 0; i < fi.entries.size(); ++i) {
                SourceTextEntry ste = fi.entries.get(i);
                SourceTextEntry prevSte = (SourceTextEntry)exists.get(ste.getSrcText());
                if (prevSte == null) {
                    exists.put(ste.getSrcText(), ste);
                    continue;
                }
                if (prevSte.duplicates == null) {
                    prevSte.duplicates = new ArrayList<SourceTextEntry>();
                }
                prevSte.duplicates.add(ste);
                ste.firstInstance = prevSte;
            }
        }
    }

    void importTranslationsFromSources() {
        HashMap<String, String> allowToImport = new HashMap<String, String>();
        for (IProject.FileInfo fi : this.projectFilesList) {
            for (int i = 0; i < fi.entries.size(); ++i) {
                SourceTextEntry ste = fi.entries.get(i);
                if (ste.getSourceTranslation() == null || ste.isSourceTranslationFuzzy() || ste.getSrcText().equals(ste.getSourceTranslation()) && !this.allowTranslationEqualToSource) continue;
                PrepareTMXEntry prepare = new PrepareTMXEntry();
                prepare.source = ste.getSrcText();
                TMXEntry en = this.projectTMX.getMultipleTranslation(ste.getKey());
                if (this.config.isSupportDefaultTranslations()) {
                    if (en != null) {
                        prepare.translation = ste.getSourceTranslation();
                        this.projectTMX.setTranslation(ste, en, false);
                        continue;
                    }
                    TMXEntry enDefault = this.projectTMX.getDefaultTranslation(ste.getSrcText());
                    if (enDefault == null) {
                        prepare.translation = ste.getSourceTranslation();
                        this.projectTMX.setTranslation(ste, new TMXEntry(prepare, true, null), true);
                        allowToImport.put(ste.getSrcText(), ste.getSourceTranslation());
                        continue;
                    }
                    String justImported = (String)allowToImport.get(ste.getSrcText());
                    if (justImported == null || ste.getSourceTranslation().equals(justImported)) continue;
                    prepare.translation = ste.getSourceTranslation();
                    this.projectTMX.setTranslation(ste, new TMXEntry(prepare, false, null), false);
                    continue;
                }
                if (en != null) continue;
                prepare.translation = ste.getSourceTranslation();
                this.projectTMX.setTranslation(ste, new TMXEntry(prepare, false, null), false);
            }
        }
    }

    private void loadTM() {
        File tmRoot = new File(this.config.getTMRoot());
        this.tmMonitor = new DirectoryMonitor(tmRoot, file -> {
            if (!ExternalTMFactory.isSupported(file)) {
                return;
            }
            if (file.getPath().replace('\\', '/').startsWith(this.config.getTMOtherLangRoot())) {
                return;
            }
            TreeMap<String, IExternalMemory> newTransMemories = new TreeMap<String, IExternalMemory>(new FileUtil.TmFileComparator(this.config.getTmDir().getAsFile()));
            newTransMemories.putAll(this.transMemories);
            HashSet<IWritableExternalMemory> newUpdatedExternalMemories = new HashSet<IWritableExternalMemory>(this.updatedExternalMemories);
            if (file.exists()) {
                try {
                    IExternalMemory newMemory = ExternalTMFactory.load(file);
                    newTransMemories.put(file.getPath(), newMemory);
                    try {
                        IWritableExternalMemory uNewMemory = (IWritableExternalMemory)newMemory;
                        if (uNewMemory.isWriteMode()) {
                            newUpdatedExternalMemories.add(uNewMemory);
                        }
                    }
                    catch (ClassCastException uNewMemory) {
                        // empty catch block
                    }
                    if (FileUtil.computeRelativePath(tmRoot, file).startsWith("auto/")) {
                        this.appendFromAutoMemory(newMemory, false);
                    } else if (FileUtil.computeRelativePath(tmRoot, file).startsWith("enforce/")) {
                        this.appendFromAutoMemory(newMemory, true);
                    }
                }
                catch (Exception e) {
                    String filename = file.getPath();
                    Log.logErrorRB(e, "TF_TM_LOAD_ERROR", filename);
                    Core.getMainWindow().displayErrorRB(e, "TF_TM_LOAD_ERROR", filename);
                }
            } else {
                newTransMemories.remove(file.getPath());
            }
            this.transMemories = newTransMemories;
            this.updatedExternalMemories = newUpdatedExternalMemories;
        });
        this.tmMonitor.checkChanges();
        this.tmMonitor.start();
    }

    private void loadOtherLanguages() {
        File tmOtherLanguagesRoot = new File(this.config.getTMOtherLangRoot());
        this.tmOtherLanguagesMonitor = new DirectoryMonitor(tmOtherLanguagesRoot, file -> {
            String name = file.getName();
            if (!name.matches("[A-Z]{2}([-_][A-Z]{2})?\\.tmx")) {
                return;
            }
            Language targetLanguage = new Language(name.substring(0, name.length() - ".tmx".length()));
            TreeMap<Language, ProjectTMX> newOtherTargetLangTMs = new TreeMap<Language, ProjectTMX>(this.otherTargetLangTMs);
            if (file.exists()) {
                try {
                    ProjectTMX newTMX = new ProjectTMX(this.config.getSourceLanguage(), targetLanguage, this.config.isSentenceSegmentingEnabled(), file, this.checkOrphanedCallback);
                    newOtherTargetLangTMs.put(targetLanguage, newTMX);
                }
                catch (Exception e) {
                    String filename = file.getPath();
                    Log.logErrorRB(e, "TF_TM_LOAD_ERROR", filename);
                    Core.getMainWindow().displayErrorRB(e, "TF_TM_LOAD_ERROR", filename);
                }
            } else {
                newOtherTargetLangTMs.remove(targetLanguage);
            }
            this.otherTargetLangTMs = newOtherTargetLangTMs;
        });
        this.tmOtherLanguagesMonitor.checkChanges();
        this.tmOtherLanguagesMonitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendFromAutoMemory(IExternalMemory autoMemory, boolean isEnforcedTMX) throws Exception {
        ProjectTMX projectTMX = this.projectTMX;
        synchronized (projectTMX) {
            this.importHandler.process((ExternalTMX)autoMemory, isEnforcedTMX);
        }
    }

    @Override
    public List<SourceTextEntry> getAllEntries() {
        return this.allProjectEntries;
    }

    @Override
    public TMXEntry getTranslationInfo(SourceTextEntry ste) {
        if (this.projectTMX == null) {
            return EMPTY_TRANSLATION;
        }
        TMXEntry r = this.projectTMX.getMultipleTranslation(ste.getKey());
        if (r == null) {
            r = this.projectTMX.getDefaultTranslation(ste.getSrcText());
        }
        if (r == null) {
            r = EMPTY_TRANSLATION;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProject.AllTranslations getAllTranslations(SourceTextEntry ste) {
        IProject.AllTranslations r = new IProject.AllTranslations();
        ProjectTMX projectTMX = this.projectTMX;
        synchronized (projectTMX) {
            r.defaultTranslation = this.projectTMX.getDefaultTranslation(ste.getSrcText());
            r.alternativeTranslation = this.projectTMX.getMultipleTranslation(ste.getKey());
            r.currentTranslation = r.alternativeTranslation != null ? r.alternativeTranslation : (r.defaultTranslation != null ? r.defaultTranslation : EMPTY_TRANSLATION);
            if (r.defaultTranslation == null) {
                r.defaultTranslation = EMPTY_TRANSLATION;
            }
            if (r.alternativeTranslation == null) {
                r.alternativeTranslation = EMPTY_TRANSLATION;
            }
        }
        return r;
    }

    @Override
    public ProjectProperties getProjectProperties() {
        return this.config;
    }

    @Override
    public boolean isProjectModified() {
        return this.modified;
    }

    private void setProjectModified(boolean isModified) {
        this.modified = isModified;
        if (isModified) {
            CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.MODIFIED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTranslation(SourceTextEntry entry, PrepareTMXEntry trans, boolean defaultTranslation, TMXEntry.ExternalLinked externalLinked, IProject.AllTranslations previous) throws IProject.OptimisticLockingFail {
        if (trans == null) {
            throw new IllegalArgumentException("RealProject.setTranslation(tr) can't be null");
        }
        ProjectTMX projectTMX = this.projectTMX;
        synchronized (projectTMX) {
            IProject.AllTranslations current = this.getAllTranslations(entry);
            boolean wasAlternative = current.alternativeTranslation.isTranslated();
            if (defaultTranslation) {
                if (!current.defaultTranslation.equals(previous.defaultTranslation)) {
                    throw new IProject.OptimisticLockingFail(previous.getDefaultTranslation().translation, current.getDefaultTranslation().translation, current);
                }
                if (wasAlternative) {
                    if (!current.alternativeTranslation.equals(previous.alternativeTranslation)) {
                        throw new IProject.OptimisticLockingFail(previous.getAlternativeTranslation().translation, current.getAlternativeTranslation().translation, current);
                    }
                    this.setTranslation(entry, new PrepareTMXEntry(), false, null);
                }
            } else if (!current.alternativeTranslation.equals(previous.alternativeTranslation)) {
                throw new IProject.OptimisticLockingFail(previous.getAlternativeTranslation().translation, current.getAlternativeTranslation().translation, current);
            }
            this.setTranslation(entry, trans, defaultTranslation, externalLinked);
        }
    }

    @Override
    public void setTranslation(SourceTextEntry entry, PrepareTMXEntry trans, boolean defaultTranslation, TMXEntry.ExternalLinked externalLinked) {
        if (trans == null) {
            throw new IllegalArgumentException("RealProject.setTranslation(tr) can't be null");
        }
        TMXEntry prevTrEntry = defaultTranslation ? this.projectTMX.getDefaultTranslation(entry.getSrcText()) : this.projectTMX.getMultipleTranslation(entry.getKey());
        trans.changer = Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name"));
        trans.changeDate = System.currentTimeMillis();
        if (prevTrEntry == null) {
            prevTrEntry = EMPTY_TRANSLATION;
            trans.creationDate = trans.changeDate;
            trans.creator = trans.changer;
        } else {
            trans.creationDate = prevTrEntry.creationDate;
            trans.creator = prevTrEntry.creator;
        }
        if (StringUtil.isEmpty(trans.note)) {
            trans.note = null;
        }
        trans.source = entry.getSrcText();
        TMXEntry newTrEntry = trans.translation == null && trans.note == null ? null : new TMXEntry(trans, defaultTranslation, externalLinked);
        this.setProjectModified(true);
        this.projectTMX.setTranslation(entry, newTrEntry, defaultTranslation);
        for (IWritableExternalMemory provider : this.updatedExternalMemories) {
            try {
                if (!provider.mustWrite(trans, entry)) continue;
                provider.registerTranslation(this.config.getSourceLanguage(), this.config.getTargetLanguage(), trans, entry);
            }
            catch (ClassCastException classCastException) {
            }
            catch (Exception other) {
                Log.log(other);
            }
        }
        int diff = prevTrEntry.translation == null ? 0 : -1;
        this.hotStat.numberOfTranslatedSegments = Math.max(0, Math.min(this.hotStat.numberOfUniqueSegments, this.hotStat.numberOfTranslatedSegments + (diff += trans.translation == null ? 0 : 1)));
    }

    @Override
    public void setNote(SourceTextEntry entry, TMXEntry oldTE, String note) {
        TMXEntry prevTrEntry;
        if (oldTE == null) {
            throw new IllegalArgumentException("RealProject.setNote(tr) can't be null");
        }
        if (note != null && note.isEmpty()) {
            note = null;
        }
        TMXEntry tMXEntry = prevTrEntry = oldTE.defaultTranslation ? this.projectTMX.getDefaultTranslation(entry.getSrcText()) : this.projectTMX.getMultipleTranslation(entry.getKey());
        if (prevTrEntry != null) {
            PrepareTMXEntry en = new PrepareTMXEntry(prevTrEntry);
            en.note = note;
            this.projectTMX.setTranslation(entry, new TMXEntry(en, prevTrEntry.defaultTranslation, prevTrEntry.linked), prevTrEntry.defaultTranslation);
        } else {
            PrepareTMXEntry en = new PrepareTMXEntry();
            en.source = entry.getSrcText();
            en.note = note;
            en.translation = null;
            this.projectTMX.setTranslation(entry, new TMXEntry(en, true, null), true);
        }
        this.setProjectModified(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iterateByDefaultTranslations(IProject.DefaultTranslationsIterator it) {
        if (this.projectTMX == null) {
            return;
        }
        Map.Entry<K, V>[] entryArray = this.projectTMX;
        synchronized (this.projectTMX) {
            Map.Entry<K, V>[] entries = this.entrySetToArray(this.projectTMX.defaults.entrySet());
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (Map.Entry en : entries) {
                it.iterate((String)en.getKey(), (TMXEntry)en.getValue());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iterateByMultipleTranslations(IProject.MultipleTranslationsIterator it) {
        if (this.projectTMX == null) {
            return;
        }
        Map.Entry<K, V>[] entryArray = this.projectTMX;
        synchronized (this.projectTMX) {
            Map.Entry<K, V>[] entries = this.entrySetToArray(this.projectTMX.alternatives.entrySet());
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (Map.Entry en : entries) {
                it.iterate((EntryKey)en.getKey(), (TMXEntry)en.getValue());
            }
            return;
        }
    }

    private <K, V> Map.Entry<K, V>[] entrySetToArray(Set<Map.Entry<K, V>> set) {
        Map.Entry[] a = new Map.Entry[set.size()];
        return set.toArray(a);
    }

    @Override
    public boolean isOrphaned(String source) {
        return !this.checkOrphanedCallback.existSourceInProject(source);
    }

    @Override
    public boolean isOrphaned(EntryKey entry) {
        return !this.checkOrphanedCallback.existEntryInProject(entry);
    }

    @Override
    public Map<String, IExternalMemory> getTransMemories() {
        return Collections.unmodifiableMap(this.transMemories);
    }

    @Override
    public Map<Language, ProjectTMX> getOtherTargetLanguageTMs() {
        return Collections.unmodifiableMap(this.otherTargetLangTMs);
    }

    @Override
    public ITokenizer getSourceTokenizer() {
        return this.sourceTokenizer;
    }

    @Override
    public ITokenizer getTargetTokenizer() {
        return this.targetTokenizer;
    }

    protected ITokenizer createTokenizer(String cmdLine, Class<?> projectPref) {
        if (!StringUtil.isEmpty(cmdLine)) {
            try {
                return (ITokenizer)this.getClass().getClassLoader().loadClass(cmdLine).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                Log.log(e.toString());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return (ITokenizer)projectPref.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            Log.log(e);
            return new DefaultTokenizer();
        }
    }

    @Override
    public List<IProject.FileInfo> getProjectFiles() {
        return Collections.unmodifiableList(this.projectFilesList);
    }

    @Override
    public String getTargetPathForSourceFile(String currentSource) {
        if (StringUtil.isEmpty(currentSource)) {
            return null;
        }
        try {
            return Core.getFilterMaster().getTargetForSource(this.config.getSourceRoot(), currentSource, new FilterContext(this.config));
        }
        catch (Exception e) {
            Log.log(e);
            return null;
        }
    }

    @Override
    public List<String> getSourceFilesOrder() {
        Path path = Paths.get(this.config.getProjectInternal(), "files_order.txt");
        try {
            return Files.readAllLines(path, StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void setSourceFilesOrder(List<String> filesList) {
        Path path = Paths.get(this.config.getProjectInternal(), "files_order.txt");
        try (BufferedWriter wr = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            for (String f : filesList) {
                wr.write(f);
                ((Writer)wr).write(10);
            }
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    protected String patchFileNameForEntryKey(String filename) {
        String f = Core.getParams().get("alternate-filename-from");
        String t = Core.getParams().get("alternate-filename-to");
        String fn = filename.replace('\\', '/');
        if (f != null && t != null) {
            fn = fn.replaceAll(f, t);
        }
        return StringUtil.removeXMLInvalidChars(fn);
    }

    void setOnlineMode() {
        if (!this.isOnlineMode) {
            Log.logInfoRB("VCS_ONLINE", new Object[0]);
            Core.getMainWindow().displayWarningRB("VCS_ONLINE", "VCS_ACCESS_PROBLEM", new Object[0]);
        }
        this.isOnlineMode = true;
        this.preparedStatus = PreparedStatus.NONE;
    }

    void setOfflineMode() {
        if (this.isOnlineMode) {
            Log.logInfoRB("VCS_ACCESS_PROBLEM", new Object[0]);
            Core.getMainWindow().displayWarningRB("VCS_ACCESS_PROBLEM", "VCS_ONLINE", new Object[0]);
        }
        this.isOnlineMode = false;
        this.preparedStatus = PreparedStatus.NONE;
    }

    @Override
    public boolean isRemoteProject() {
        return this.remoteRepositoryProvider != null;
    }

    @Override
    public void commitSourceFiles() throws Exception {
        if (this.isRemoteProject() && this.config.getSourceDir().isUnderRoot()) {
            try {
                Core.getMainWindow().showStatusMessageRB("TF_COMMIT_START", new Object[0]);
                this.remoteRepositoryProvider.switchAllToLatest();
                this.remoteRepositoryProvider.copyFilesFromProjectToRepos(this.config.getSourceDir().getUnderRoot(), null);
                this.remoteRepositoryProvider.commitFiles(this.config.getSourceDir().getUnderRoot(), "Commit source files");
                Core.getMainWindow().showStatusMessageRB("TF_COMMIT_DONE", new Object[0]);
            }
            catch (Exception e) {
                Log.logErrorRB("TF_COMMIT_ERROR", new Object[0]);
                Log.log(e);
                throw new IOException(OStrings.getString("TF_COMMIT_ERROR") + "\n" + e.getMessage(), e);
            }
        }
    }

    static {
        PrepareTMXEntry empty = new PrepareTMXEntry();
        empty.source = "";
        EMPTY_TRANSLATION = new TMXEntry(empty, true, null);
    }

    static class AlignFilesCallback
    implements IAlignCallback {
        Map<EntryKey, ITMXEntry> data = new TreeMap<EntryKey, ITMXEntry>();
        private final ProjectProperties config;
        List<String> sources = new ArrayList<String>();

        AlignFilesCallback(ProjectProperties props) {
            this.config = props;
        }

        @Override
        public void addTranslation(String id, String source, String translation, boolean isFuzzy, String sourcePath, IFilter filter) {
            if (source != null && translation != null) {
                ParseEntry.ParseEntryResult spr = new ParseEntry.ParseEntryResult();
                boolean removeSpaces = Core.getFilterMaster().getConfig().isRemoveSpacesNonseg();
                String sourceS = ParseEntry.stripSomeChars(source, spr, this.config.isRemoveTags(), removeSpaces);
                Object transS = ParseEntry.stripSomeChars(translation, spr, this.config.isRemoveTags(), removeSpaces);
                if (this.config.isSupportDefaultTranslations() && this.sources.contains(sourceS)) {
                    return;
                }
                this.sources.add(sourceS);
                PrepareTMXEntry tr = new PrepareTMXEntry();
                if (this.config.isSentenceSegmentingEnabled()) {
                    List<String> segmentsSource = Core.getSegmenter().segment(this.config.getSourceLanguage(), sourceS, null, null);
                    List<String> segmentsTranslation = Core.getSegmenter().segment(this.config.getTargetLanguage(), (String)transS, null, null);
                    if (segmentsTranslation.size() != segmentsSource.size()) {
                        if (isFuzzy) {
                            transS = "[" + filter.getFuzzyMark() + "] " + (String)transS;
                        }
                        tr.source = sourceS;
                        tr.translation = transS;
                        this.data.put(new EntryKey(sourcePath, sourceS, id, "", "", ""), tr);
                    } else {
                        for (int i = 0; i < segmentsSource.size(); i = (int)((short)(i + 1))) {
                            String oneSrc = segmentsSource.get(i);
                            Object oneTrans = segmentsTranslation.get(i);
                            if (isFuzzy) {
                                oneTrans = "[" + filter.getFuzzyMark() + "] " + (String)oneTrans;
                            }
                            tr.source = oneSrc;
                            tr.translation = oneTrans;
                            this.data.put(new EntryKey(sourcePath, oneSrc, id, "", "", ""), tr);
                        }
                    }
                } else {
                    if (isFuzzy) {
                        transS = "[" + filter.getFuzzyMark() + "] " + (String)transS;
                    }
                    tr.source = sourceS;
                    tr.translation = transS;
                    this.data.put(new EntryKey(sourcePath, sourceS, id, "", "", ""), tr);
                }
            }
        }
    }

    private class TranslateFilesCallback
    extends TranslateEntry {
        private String currentFile;

        @Override
        protected String getCurrentFile() {
            return this.currentFile;
        }

        TranslateFilesCallback() {
            super(RealProject.this.config);
        }

        protected void fileStarted(String fn) {
            this.currentFile = RealProject.this.patchFileNameForEntryKey(fn);
            super.fileStarted();
        }

        @Override
        protected String getSegmentTranslation(String id, int segmentIndex, String segmentSource, String prevSegment, String nextSegment, String path) {
            EntryKey ek = new EntryKey(this.currentFile, segmentSource, id, prevSegment, nextSegment, path);
            TMXEntry tr = RealProject.this.projectTMX.getMultipleTranslation(ek);
            if (tr == null) {
                tr = RealProject.this.projectTMX.getDefaultTranslation(ek.sourceText);
            }
            return tr != null ? tr.translation : null;
        }
    }

    protected class LoadFilesCallback
    extends ParseEntry {
        private IProject.FileInfo fileInfo;
        private String entryKeyFilename;
        private final Set<String> existSource;
        private final Set<EntryKey> existKeys;
        private final Map<String, IExternalMemory> externalTms;
        private ExternalTMFactory.Builder tmBuilder;

        public LoadFilesCallback(Set<String> existSource, Set<EntryKey> existKeys, Map<String, IExternalMemory> externalTms) {
            super(RealProject.this.config);
            this.existSource = existSource;
            this.existKeys = existKeys;
            this.externalTms = externalTms;
        }

        @Override
        public void setCurrentFile(IProject.FileInfo fi) {
            this.fileInfo = fi;
            super.setCurrentFile(fi);
            this.entryKeyFilename = RealProject.this.patchFileNameForEntryKey(this.fileInfo.filePath);
        }

        @Override
        public void fileFinished() {
            super.fileFinished();
            if (this.tmBuilder != null && this.externalTms != null) {
                this.externalTms.put(this.entryKeyFilename, this.tmBuilder.done());
            }
            this.fileInfo = null;
            this.tmBuilder = null;
        }

        @Override
        protected void addSegment(String id, short segmentIndex, String segmentSource, List<ProtectedPart> protectedParts, String segmentTranslation, boolean segmentTranslationFuzzy, String[] props, String prevSegment, String nextSegment, String path) {
            if (segmentSource.trim().isEmpty()) {
                throw new RuntimeException("Segment must not be empty");
            }
            EntryKey ek = new EntryKey(this.entryKeyFilename, segmentSource, id, prevSegment, nextSegment, path);
            protectedParts = TagUtil.applyCustomProtectedParts(segmentSource, PatternConsts.getPlaceholderPattern(), protectedParts);
            if (ek.sourceText.equals(segmentTranslation) && !RealProject.this.allowTranslationEqualToSource) {
                segmentTranslation = null;
            }
            SourceTextEntry srcTextEntry = new SourceTextEntry(ek, RealProject.this.allProjectEntries.size() + 1, props, segmentTranslation, protectedParts, segmentIndex == 0);
            srcTextEntry.setSourceTranslationFuzzy(segmentTranslationFuzzy);
            if (SegmentProperties.isReferenceEntry(props)) {
                if (this.tmBuilder == null) {
                    this.tmBuilder = new ExternalTMFactory.Builder(new File(this.entryKeyFilename).getName());
                }
                this.tmBuilder.addEntry(segmentSource, segmentTranslation, id, path, props);
            } else {
                RealProject.this.allProjectEntries.add(srcTextEntry);
                this.fileInfo.entries.add(srcTextEntry);
                this.existSource.add(segmentSource);
                this.existKeys.add(srcTextEntry.getKey());
            }
        }
    }

    static enum PreparedStatus {
        NONE,
        PREPARED,
        PREPARED2,
        REBASED;

    }
}

