/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.stat;

import java.awt.Font;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.omegat.core.Core;
import org.omegat.core.statistics.IStatsConsumer;
import org.omegat.gui.stat.StatisticsWindow;
import org.omegat.gui.stat.TitledTablePanel;
import org.omegat.util.Preferences;
import org.omegat.util.gui.DataTableStyling;
import org.omegat.util.gui.OSXIntegration;
import org.omegat.util.gui.TableColumnSizer;

public abstract class BaseStatisticsPanel
extends JPanel
implements IStatsConsumer {
    private final StatisticsWindow window;

    public BaseStatisticsPanel(StatisticsWindow window) {
        this.window = window;
    }

    @Override
    public void showProgress(int percent) {
        this.window.showProgress(percent);
    }

    @Override
    public void finishData() {
        this.window.finishData();
    }

    @Override
    public void setTextData(String data) {
        this.window.setTextData(data);
    }

    @Override
    public void setDataFile(String path) {
        File file = new File(path);
        OSXIntegration.setProxyIcon(this.getRootPane(), file.isFile() ? file : null);
    }

    protected TitledTablePanel generateTableDisplay(String title, String[] headers, String[][] data) {
        TitledTablePanel panel = new TitledTablePanel();
        DataTableStyling.applyColors(panel.table);
        panel.table.setDefaultRenderer(Object.class, DataTableStyling.getNumberCellRenderer());
        Font font = panel.table.getFont();
        if (Preferences.isPreference("project_files_use_font")) {
            font = Core.getMainWindow().getApplicationFont();
        }
        DataTableStyling.applyFont(panel.table, font);
        panel.title.setText(title);
        panel.table.setModel(new StringArrayTableModel(data));
        BaseStatisticsPanel.setTableHeaders(panel.table, headers);
        panel.table.getColumnModel().getColumn(0).setCellRenderer(DataTableStyling.getHeaderTextCellRenderer());
        TableColumnSizer.autoSize(panel.table, 0, false);
        panel.table.setPreferredScrollableViewportSize(panel.table.getPreferredSize());
        return panel;
    }

    protected static void setTableHeaders(JTable table, String[] headers) {
        for (int i = 0; i < headers.length; ++i) {
            TableColumn col = table.getColumnModel().getColumn(i);
            col.setHeaderValue(headers[i]);
        }
    }

    static class StringArrayTableModel
    extends AbstractTableModel {
        private final String[][] data;

        StringArrayTableModel(String[][] data) {
            this.data = data;
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 0 : this.data.length;
        }

        @Override
        public int getColumnCount() {
            return this.data == null || this.data.length == 0 ? 0 : (this.data[0] == null ? 0 : this.data[0].length);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[rowIndex][columnIndex];
        }
    }
}

