/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.JarURLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.omegat.core.Core;

public abstract class Cyclotis<T> {
    protected static final SimpleDateFormat SHORT_LOG_DATE_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    protected static final SimpleDateFormat LONG_LOG_DATE_FORMAT = new SimpleDateFormat("MM-dd HH:mm:ss");
    private static final HashMap<String, FileOutputStream> LOG_STREAMS = new HashMap();
    protected String name = "";
    protected String providerName = "Silvestris Cyclotis";
    private PrintStream logDest = System.err;
    private String logList;
    private ScriptEngine scriptEngine = null;
    private DigestAlgorithm digestAlgo;
    private static final Pattern doubleWord = Pattern.compile("(?:^|\\b)(\\w+)\\s(.+?)\\s\\1(?:\\b|$)", 2);
    private int limitReduce = 0;

    public Cyclotis(Properties propList) {
        if (propList.getProperty("provider.name") != null) {
            this.providerName = propList.getProperty("provider.name");
        }
        this.name = propList.getProperty("name");
        if (propList.getProperty("log.file") != null) {
            try {
                FileOutputStream fos;
                String fileName = propList.getProperty("log.file");
                if (!fileName.startsWith("/")) {
                    fileName = Core.getProject().getProjectProperties().getProjectRoot() + File.separator + fileName;
                }
                if ((fos = LOG_STREAMS.get(fileName)) != null) {
                    this.logDest = new PrintStream(fos);
                    this.logMessage("", "Shared log for " + this.providerName + "/" + this.name);
                } else {
                    boolean exist = new File(fileName).exists();
                    fos = new FileOutputStream(fileName, true);
                    this.logDest = new PrintStream(fos);
                    if (exist) {
                        this.logDest.println("\n\n");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (propList.getProperty("text.get.script") != null || propList.getProperty("text.put.script") != null) {
            ScriptEngineManager manager = new ScriptEngineManager(Cyclotis.class.getClassLoader());
            this.scriptEngine = manager.getEngineByName("javascript");
            String script = propList.getProperty("text.get.script");
            if (script != null) {
                try {
                    this.scriptEngine.eval("function pre(text) { " + script + " }");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.scriptEngine.eval("function pre(text) { return text; }");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            script = propList.getProperty("text.put.script");
            if (script != null) {
                try {
                    this.scriptEngine.eval("function post(text) { " + script + " }");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.scriptEngine.eval("function post(text) { return text; }");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.logList = propList.getProperty("log.list");
        if (this.logList == null) {
            this.logList = "";
        }
        if (this.logDest != System.err) {
            String buildDate = "unknown date";
            try {
                String rn = Cyclotis.class.getName().replace('.', '/') + ".class";
                JarURLConnection conn = (JarURLConnection)Cyclotis.class.getClassLoader().getResource(rn).openConnection();
                buildDate = LONG_LOG_DATE_FORMAT.format(new Date(conn.getJarFile().getEntry("META-INF/MANIFEST.MF").getTime()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.logDest.println(LONG_LOG_DATE_FORMAT.format(new Date()) + " - Starting logging  Cyclotis (" + buildDate + ") for " + this.providerName + " / " + this.name);
        }
        try {
            this.limitReduce = Integer.parseInt(propList.getProperty("limit.reduceWords"));
            this.logMessage("config", "Reducing words after " + this.limitReduce);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Cyclotis(Cyclotis ori) {
        this.name = ori.name;
        this.providerName = ori.providerName;
        this.logDest = ori.logDest;
        this.logList = ori.logList;
        this.digestAlgo = ori.digestAlgo;
        this.scriptEngine = ori.scriptEngine;
        this.limitReduce = ori.limitReduce;
    }

    public String reformatText(String text, boolean input) {
        if (this.scriptEngine == null) {
            return text;
        }
        String function = input ? "pre" : "post";
        try {
            Invocable inv = (Invocable)((Object)this.scriptEngine);
            Object eval = inv.invokeFunction(function, text);
            this.logMessage("javascript", function + "(" + text + ") evaluated as " + eval);
            if (eval == null) {
                return text;
            }
            return eval.toString();
        }
        catch (Exception e) {
            this.logMessage("javascript", function + "(" + text + ") not evaluated : " + e);
            return text;
        }
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getMemoryName() {
        if (this.name == null) {
            return this.getProviderName();
        }
        return this.name;
    }

    public void logMessage(String condition, String message) {
        if (this.logDest == null) {
            return;
        }
        if (!this.logList.contains(condition)) {
            return;
        }
        message = SHORT_LOG_DATE_FORMAT.format(new Date()) + " - <" + condition + "> " + message;
        if (this.logDest == System.err) {
            message = "[" + this.getProviderName() + "/" + this.getMemoryName() + "] " + message;
        } else if ("".equals(condition)) {
            System.err.println("[" + this.getProviderName() + "/" + this.getMemoryName() + "]: " + message);
        }
        this.logDest.println(message);
    }

    public void logException(Exception e) {
        this.logMessage("", "Exception:");
        e.printStackTrace();
        if (this.logDest != System.err) {
            e.printStackTrace(this.logDest);
        }
    }

    public abstract Object entryToLogString(T var1, boolean var2, boolean var3);

    public Object digest(String source) {
        if (this.digestAlgo == null) {
            return "";
        }
        return this.digestAlgo.digest(source);
    }

    public void logEntry(String condition, T entry, boolean detailed) {
        if (this.logDest == null) {
            return;
        }
        if (!this.logList.contains(condition)) {
            return;
        }
        this.logDest.println(this.entryToLogString(entry, detailed, this.digestAlgo != null));
    }

    public String reduceWords(String st) {
        Matcher m;
        if (this.limitReduce > st.length()) {
            return st;
        }
        this.logMessage("reduce-words", "String to reduce(" + st.length() + "): '" + st + "'");
        st = st.toLowerCase();
        st = st.replaceAll("\\W+", " ");
        while ((m = doubleWord.matcher(st)).find()) {
            st = m.replaceAll(" $1 $2 ");
        }
        st = st.trim();
        this.logMessage("reduce-words", "String reduced(" + st.length() + "):   '" + st + "'");
        return st;
    }

    public static interface DigestAlgorithm {
        public Object digest(String var1);
    }
}

