=head1 Package formats::YAML

Gives answers from web-creator in YAML 

=head1 METHODS

=cut
package formats::yaml;

use vr;

=head2 formats::yaml->message ($status, $cause, $where)

Basic message without contents

=cut

sub message {
	my $self = shift;
	my $status = shift || 'OK';
	my $cause = shift; $cause =~ s/[\r\n]//g;  if ($cause =~ /:|\n/) { $cause = "cause: '$cause'"; } elsif ($cause) { $cause = "cause: $cause"; }
	my $where = shift; $where = "perl-location: $where" if $where;
	return << "EOF";
server: $main::SERVER
response: 
    status: $status
    $cause
    $where
EOF
}

=head2 formats::yaml->envelope ([$status, $cause, $where], $contents)

Message with contents

=cut

sub envelope {
	my $self = shift;	
	my $status = shift; my $res = $self->message(@$status);
	$res .= shift;
}

=head2 formats::yaml->memory (%params)

Gives data about one memory

=cut
sub memory {
	shift; my %spec = @_;
	return << "EOF";
memory: 
    name: $spec{mem_name}
    connection: 
        server: $spec{host}
        port: $spec{port} 
        catalog: $spec{catalog}
        table: $spec{table}
EOF
}

use Dancer ':syntax';

=head2 formats::json->listMemories (%memories)

Displays data about hash of memories

=cut
sub listMemories {
	shift; my %MEM = @_;
	my $MEMORIES = "memories:\n";
	while (my ($key, $tab) = each (%MEM)) {
		my $keyYaml = $key; $keyYaml =~ s!\s*(\w+)='(\w+)'!    $1: $2\n!g or $keyYaml = "    for: $keyYaml";
		$MEMORIES .= "  - \n$keyYaml\n    list:\n";
		foreach my $mem (@$tab) {
			$mem->{mem_name} ||= $mem->{table} || $mem->{tablename} || $mem->{table_name};
			$MEMORIES .= << "EOF";
      - name: $mem->{mem_name}
        connection: 
           server: $mem->{host}
           port: $mem->{port}
           catalog: $mem->{catalog}
           table: $mem->{table_schema}.$mem->{table_name}
EOF
			my $info = "";
			$info .= "           creation-date: $mem->{creation}\n" if defined $mem->{creation};	# not an optional field, unless not declared in the table
			while (my ($name, $field) = each (%{config->{list}{fields}})) { $info .=  "           $name: $mem->{$name}\n" if defined $mem->{$name}; }
			if (ref config->{list}{sql}{view}{fields}{added}) {
    			while (my ($name, $field) = each (%{config->{list}{sql}{view}{fields}{added}})) { 
    				my $val = vr::interpolation($field, $mem);
    				$info .= "           $name: $val\n";
    			}
    		}
			$MEMORIES .= "        info:\n$info" if $info;
		}

	}
	return $MEMORIES;
}

sub MIME { 'application/json' }

1;

=head1 License

Copyright 2014 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
