#! /usr/bin/perl

=head1 DESCRIPTION

This script reads config file and does the creation of the databases.
It makes use of Dancer but is NOT a Dancer application: must be called only once, 
after you wrote config.yml but before you call the application.

=head1 INSTALLATION REQUIREMENTS

This script does not replace SQL/db/dbcreator.pl, it is based on it: you must install it and put in the YAML configuration where it is.

If the configuration implies to create catalogs, you will need:

=over 1

=item The Postgres client 'createdb' installed in the machine hosting the script (but can create databases in other machines);

=item A Postgres user with admin rights (normal user cannot load extensions)

=back

Owner of the databases created by this script is the user defined in config.yml

=cut

use Dancer qw(config);
$ENV{CYCLOTIS_MODE} = config->{'SQL-scripts'}{mode} if config->{'SQL-scripts'}{mode}; 
push(@main::INC, config->{'SQL-scripts'}{dir});
require DbCreator;

=pod

In case this user is not a super-user, you must specify a super-user, which will be used only during creation 

Syntax: init-db.pl -- -u <user-name> [-p password]

Double dash is necessary to tell the script not to use options to configure Dancer.

"init-db.pl -u" without user name, will use the system user name. If you have sudo rights, "sudo -u postgres init-db.pl -u" should work.
Password is mandatory unless you configured Postgres with 'peer', 'ident' or 'trust' authentication method.

=cut
my $userSpec = config->{database}{user};
if (shift =~ /^\-u(.*)$/) {
  my $adminUser; if ($adminUser = $1) { $adminUser =~ s/^.+=//; }
  elsif ($ARGV[0] !~ /^-/) { $adminUser = shift; }
  else { $adminUser = getpwuid $<; }
  $userSpec = "$adminUser#$userSpec";
}
if (shift =~ /^-p(.*)$/) {
  my $pwd; if ($pwd = $1) { $pwd =~ s/^.+=//; }
  elsif ($ARGV[0] !~ /^-/) { $pwd = shift; }
  else { print "Type password: "; $pwd = readline; $pwd =~ s/\r?\n$//; }
  $userSpec =~ s/\#/:$pwd\#/; # insert password before owner
}

use vr;

foreach my $host (vr::possibleValues (config->{database}{host})) {
	foreach my $port (vr::possibleValues (config->{database}{port})) {
		foreach my $db (vr::possibleValues (config->{database}{catalog})) {			
			DbCreator::createDatabase(sprintf('%s@%s:%i/%s', $userSpec, $host->{value}, $port->{value}, $db->{value}));
      if (config->{list}{sql}{table}{name}) { 
        my $type = config->{'SQL-scripts'}{mode} . '::TableCreator'; eval "require $type";
        my $creator = bless { dbiSpec => vr::dbiSpec({ host => $host->{value}, port => $port->{value}, catalog => $db->{value} }) }, $type;
	      $creator->{dbh} = DBI->connect($creator->{dbiSpec}, config->{database}{user},config->{database}{pass});
	      $creator->loadTables(); $creator->doCreate_table('public.mem'); # will  create view, if exist 
        
      }
      if (config->{database}{table} =~ /^(.+)\./) {
        my $schemas = $1;
        require DBI; my $dbh = DBI->connect("DBI:Pg:host=$host->{value};port=$port->{value};dbname=$db->{value}", config->{database}{user}, config->{database}{password});
  		  foreach my $sc0 (vr::possibleValues ($schemas)) {			
		   	  DbCreator::doCreate_schema($dbh, $sc0->{value});
		    }
      }
		}
	}
}