/*
 * Decompiled with CFR 0.152.
 */
package org.dict.zip;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAccessInputStream
extends InputStream {
    protected RandomAccessFile in;
    protected int mark = 0;

    public RandomAccessInputStream(RandomAccessFile randomAccessFile) {
        this.in = randomAccessFile;
    }

    public RandomAccessInputStream(String string, String string2) throws IOException {
        this(new RandomAccessFile(string, string2));
    }

    @Override
    public int available() throws IOException {
        return this.getLength() - this.getPos();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public int getLength() throws IOException {
        return (int)this.in.length();
    }

    public int getPos() throws IOException {
        return (int)this.in.getFilePointer();
    }

    @Override
    public synchronized void mark(int n) {
        try {
            this.mark = this.getPos();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.in.readFully(byArray);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.seek(this.mark);
    }

    public void seek(long l) throws IOException {
        this.in.seek(l);
    }

    @Override
    public long skip(long l) throws IOException {
        return this.in.skipBytes((int)l);
    }
}

