/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.proj;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.omegat.core.Core;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.external.ProjectMemory;
import org.omegat.util.Preferences;
import org.omegat.util.TMXProp;
import org.silvestrislab.cyclotis.omegat.PostgresqlCyclotisTMX;
import org.silvestrislab.cyclotis.omegat.proj.ctx.ContextMode;
import org.silvestrislab.cyclotis.omegat.proj.ctx.IntContextMode;
import org.silvestrislab.cyclotis.omegat.proj.ctx.StringContextMode;

public class PostgresqlProjectMemory
extends PostgresqlCyclotisTMX<ProjectMemory.ContextTMXEntry>
implements ProjectMemory.IExternalProjectMemory {
    private PreparedStatement pRemove;
    protected int col_context_type;
    private ContextMode contextMode;
    private long timeStampDiff = 0L;

    public PostgresqlProjectMemory(Properties propList) throws SQLException, ClassNotFoundException {
        super(propList);
        String author;
        this.contextMode = this.col_context_type == 0 ? IntContextMode.forProperties(propList) : StringContextMode.forProperties(propList, this.col_context_type);
        this.logMessage("", "Context mode is " + this.contextMode);
        try {
            PreparedStatement sNow = this.connection.prepareStatement("select NOW()");
            ResultSet rs = sNow.executeQuery();
            rs.next();
            this.timeStampDiff = rs.getTimestamp(1).getTime() - System.currentTimeMillis();
            this.logMessage("", "Server to client timestamp difference: " + this.timeStampDiff);
        }
        catch (Exception e) {
            this.logMessage("", "Cannot find server timestamp : " + e.getMessage());
        }
        String table = propList.getProperty("table");
        if (table == null) {
            table = "MEM";
        }
        if ((author = propList.getProperty("author")) == null) {
            author = Preferences.getPreferenceDefault((String)"team_Author", (String)System.getProperty("user.name"));
        }
        this.getInsertStatement().setString(3, author);
        this.pRemove = this.connection.prepareStatement("delete from " + this.tableWrite + " where context=?" + (this.contextMode.isUnique() ? "" : "and src=?"));
    }

    @Override
    protected List<String> insertFields() {
        ArrayList<String> res = new ArrayList<String>(4);
        res.add("SRC");
        res.add("TRA");
        res.add("AUTHOR");
        res.add("CONTEXT");
        res.add("NOTE");
        if (this.col_props != null) {
            res.add("PROPS");
        }
        if (this.hasNote) {
            res.add("NOTE");
        }
        if (this.mem_id != null && this.mem_id instanceof Integer) {
            res.add("MEM_ID");
        }
        if (this.mem_id instanceof Long) {
            res.add("MEM_CODE");
        } else if (this.mem_id instanceof String) {
            res.add("MEM_PATH");
        }
        return res;
    }

    @Override
    public boolean isWriteMode() {
        return true;
    }

    @Override
    protected void registerColumn(String col_name, String udt_schema, String udt_name, int maxLength, String defaultVal) throws SQLException {
        if (col_name.equalsIgnoreCase("CONTEXT")) {
            if (udt_name.startsWith("INT")) {
                this.col_context_type = 0;
            }
            if (udt_name.startsWith("VARCHAR")) {
                this.col_context_type = maxLength;
            }
            if (udt_name.startsWith("TEXT")) {
                this.col_context_type = Integer.MAX_VALUE;
            }
            if (udt_name.startsWith("BPCHAR")) {
                this.col_context_type = -maxLength;
            }
            this.logMessage("", "registerColumn: " + this + " .col_context_type = " + this.col_context_type + " (type was " + udt_name + ")");
        }
        super.registerColumn(col_name, udt_schema, udt_name, maxLength, defaultVal);
    }

    @Override
    protected String selectCondition() {
        return "date >= ? or changedate >= ?";
    }

    @Override
    protected ProjectMemory.ContextTMXEntry buildEntry(ResultSet set) throws SQLException {
        ProjectMemory.ContextTMXEntry entry = new ProjectMemory.ContextTMXEntry();
        entry.source = this.reformatText(set.getString("SRC"), true);
        entry.translation = this.reformatText(set.getString("TRA"), true);
        try {
            entry.creator = set.getString("AUTHOR");
            entry.creationDate = set.getDate("DATE").getTime();
            entry.changer = set.getString("CHANGER");
            entry.changeDate = set.getDate("CHANGEDATE").getTime();
            entry.note = set.getString("NOTE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        entry.otherProperties = this.col_props.read(set.getObject("PROPS"));
        this.contextMode.fillEntry(entry, set);
        try {
            entry.linked = TMXEntry.ExternalLinked.valueOf((String)entry.getPropValue("externalLinked"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entry;
    }

    public List<ProjectMemory.ContextTMXEntry> findChanges(long timeStamp) throws Exception {
        PreparedStatement pSelect = this.getSelectStatement();
        pSelect.setTimestamp(1, new Timestamp(timeStamp + this.timeStampDiff));
        pSelect.setTimestamp(2, new Timestamp(timeStamp + this.timeStampDiff));
        return this.retreiveQuery(pSelect);
    }

    public void registerTranslation(ProjectMemory.ContextTMXEntry entry) throws Exception {
        PreparedStatement pInsert = this.getInsertStatement();
        SourceTextEntry ste = (SourceTextEntry)Core.getProject().getAllEntries().get(entry.entryNum - 1);
        this.contextMode.toDatabase(pInsert, 4, ste, entry.isDefault);
        this.getInsertStatement().setString(5, entry.note);
        ArrayList<TMXProp> list = new ArrayList<TMXProp>();
        list.add(new TMXProp("entryNum", Integer.toString(entry.entryNum)));
        if (entry.linked != null) {
            list.add(new TMXProp("externalLinked", entry.linked.toString()));
        }
        pInsert.setObject(6, this.col_props.write(list));
        super.registerTranslation((PrepareTMXEntry)entry);
    }

    public void removeTranslation(ProjectMemory.ContextTMXEntry entry) throws Exception {
        SourceTextEntry ste = (SourceTextEntry)Core.getProject().getAllEntries().get(entry.entryNum - 1);
        this.contextMode.toDatabase(this.pRemove, 1, ste, entry.isDefault);
        if (this.contextMode.isUnique()) {
            this.pRemove.setString(2, entry.source);
        }
        this.pRemove.executeUpdate();
    }
}

