/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.tm;

import java.util.List;
import java.util.Properties;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.external.IWritableExternalMemory;
import org.omegat.util.Language;
import org.omegat.util.TMXProp;
import org.silvestrislab.cyclotis.omegat.HttpCyclotisTMX;
import org.silvestrislab.cyclotis.omegat.tm.PropertiesStore;
import org.silvestrislab.cyclotis.omegat.tm.SaveConditions;

public class HttpMemory
extends HttpCyclotisTMX<PrepareTMXEntry>
implements IWritableExternalMemory {
    private boolean isUpdate = true;
    private SaveConditions conditions;
    private PropertiesStore store;

    public HttpMemory(Properties propList) {
        super(propList);
        this.store = new PropertiesStore(this, propList);
        if (propList.getProperty("update") != null) {
            String updateString = propList.getProperty("update");
            boolean bl = this.isUpdate = !updateString.equalsIgnoreCase("false");
            if (this.isUpdate) {
                this.conditions = SaveConditions.forProperty(updateString);
            }
            System.out.println(this.getMemoryName() + " save condition = " + this.conditions);
        } else if (propList.getProperty("table.exclude") != null) {
            this.urlFind = this.urlFind + "?exclude=" + propList.getProperty("table.exclude");
            this.isUpdate = false;
        } else {
            this.isUpdate = false;
        }
    }

    @Override
    public PrepareTMXEntry analyzeLine(String[] cols) {
        PrepareTMXEntry entry = new PrepareTMXEntry();
        this.fillEntry(entry, cols);
        entry.otherProperties.add(new TMXProp("db.table.name", cols[8]));
        entry.otherProperties = this.store.fromDatabase(entry.otherProperties, entry);
        return entry;
    }

    public List<PrepareTMXEntry> findMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception {
        return this.httpGet("fuzzy", "$otadcupnN", text);
    }

    public boolean isWriteMode() {
        return this.isUpdate;
    }

    public boolean mustWrite(PrepareTMXEntry entryContents, SourceTextEntry entrySource) {
        return this.conditions.mustWrite(this, entryContents, entrySource);
    }

    public void registerTranslation(Language sLang, Language tLang, PrepareTMXEntry entryContents, SourceTextEntry entrySource) throws Exception {
        entryContents.otherProperties = this.store.toDatabase(entryContents, entrySource);
        this.registerTranslation(entryContents);
    }
}

