/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReflectionUtil {
    private static final Logger LOGGER = Logger.getLogger(ReflectionUtil.class.getName());

    public static Map<String, String> simplePropsToMap(Object object) {
        if (object == null) {
            return Collections.EMPTY_MAP;
        }
        Method[] methods = object.getClass().getMethods();
        if (methods.length == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Method m : methods) {
            if (!m.getName().startsWith("get") || m.getParameterTypes().length != 0 || !m.getReturnType().isPrimitive() && !m.getReturnType().equals(String.class)) continue;
            try {
                Object value = m.invoke(object, new Object[0]);
                result.put(m.getName().substring("get".length()), value == null ? "null" : value.toString());
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    public static Map<String, String> simpleMembersToMap(Object object) {
        if (object == null) {
            return Collections.EMPTY_MAP;
        }
        Field[] fields = object.getClass().getDeclaredFields();
        if (fields.length == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Field f : fields) {
            if (!f.getType().isPrimitive() && !f.getType().equals(String.class)) continue;
            try {
                Object value = f.get(object);
                result.put(f.getName(), value == null ? "null" : value.toString());
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    public static Map<String, String> listPropsToMap(List<Object> list) {
        if (list == null || list.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap count = new HashMap();
        for (Object o : list) {
            try {
                Method m = o.getClass().getDeclaredMethod("getContent", new Class[0]);
                if (m == null) {
                    throw new RuntimeException("TUV contained item that didn't respond to getContent().");
                }
                if (!m.getReturnType().equals(String.class)) continue;
                Integer n = (Integer)count.get(o.getClass());
                if (n == null) {
                    n = 1;
                }
                result.put(o.getClass().getSimpleName() + n, (String)m.invoke(o, new Object[0]));
                count.put(o.getClass(), n + 1);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }
}

