/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.WikiGet;

public class MicrosoftTranslate
extends BaseTranslate {
    protected static final String URL_TOKEN = "https://datamarket.accesscontrol.windows.net/v2/OAuth2-13/";
    protected static final String URL_TRANSLATE = "http://api.microsofttranslator.com/v2/Http.svc/Translate";
    protected static final Pattern RE_RESPONSE = Pattern.compile("<string.+?>(.+)</string>");
    protected String accessToken;
    int pos;
    String str;

    @Override
    protected String getPreferenceName() {
        return "allow_microsoft_translate";
    }

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_MICROSOFT");
    }

    @Override
    protected synchronized String translate(Language sLang, Language tLang, String text) throws Exception {
        String prev = this.getFromCache(sLang, tLang, text = text.length() > 10000 ? text.substring(0, 9997) + "..." : text);
        if (prev != null) {
            return prev;
        }
        String langFrom = this.checkMSLang(sLang);
        String langTo = this.checkMSLang(tLang);
        try {
            String translation;
            if (this.accessToken == null) {
                this.requestToken();
                translation = this.requestTranslate(langFrom, langTo, text);
            } else {
                try {
                    translation = this.requestTranslate(langFrom, langTo, text);
                }
                catch (WikiGet.ResponseError ex) {
                    if (ex.code == 400) {
                        this.requestToken();
                        translation = this.requestTranslate(langFrom, langTo, text);
                    }
                    throw ex;
                }
            }
            if (translation != null) {
                this.putToCache(sLang, tLang, text, translation);
            }
            return translation;
        }
        catch (WikiGet.ResponseError ex) {
            return ex.getLocalizedMessage();
        }
        catch (Exception ex) {
            Log.log(ex);
            return ex.getLocalizedMessage();
        }
    }

    private String checkMSLang(Language language) {
        if (language.getLanguage().compareToIgnoreCase("zh-cn") == 0) {
            return "zh-CHS";
        }
        if (language.getLanguage().compareToIgnoreCase("zh-tw") == 0 || language.getLanguage().compareToIgnoreCase("zh-hk") == 0) {
            return "zh-CHT";
        }
        return language.getLanguageCode();
    }

    private void requestToken() throws Exception {
        TreeMap<String, String> p = new TreeMap<String, String>();
        if (System.getProperty("microsoft.api.client_id") == null || System.getProperty("microsoft.api.client_secret") == null) {
            throw new Exception(OStrings.getString("MT_ENGINE_MICROSOFT_KEY_NOTFOUND"));
        }
        p.put("client_id", System.getProperty("microsoft.api.client_id"));
        p.put("client_secret", System.getProperty("microsoft.api.client_secret"));
        p.put("scope", "http://api.microsofttranslator.com");
        p.put("grant_type", "client_credentials");
        String r = WikiGet.post(URL_TOKEN, p, null);
        Map<String, String> rmap = this.unpackJson(r);
        this.accessToken = rmap.get("access_token");
    }

    private String requestTranslate(String langFrom, String langTo, String text) throws Exception {
        TreeMap<String, String> p = new TreeMap<String, String>();
        p.put("appId", "Bearer " + this.accessToken);
        p.put("text", text);
        p.put("from", langFrom);
        p.put("to", langTo);
        p.put("contentType", "text/plain");
        String r = WikiGet.get(URL_TRANSLATE, p, null);
        Matcher m = RE_RESPONSE.matcher(r);
        if (m.matches()) {
            String translatedText = m.group(1);
            translatedText = translatedText.replace("&lt;", "<");
            translatedText = translatedText.replace("&gt;", ">");
            return translatedText;
        }
        Log.logWarningRB("MT_ENGINE_MICROSOFT_WRONG_RESPONSE", new Object[0]);
        return null;
    }

    public Map<String, String> unpackJson(String v) {
        if (!v.startsWith("{") || !v.endsWith("}")) {
            throw new RuntimeException("Wrong");
        }
        this.str = v.substring(v.offsetByCodePoints(0, 1), v.offsetByCodePoints(v.length(), -1));
        this.pos = 0;
        TreeMap<String, String> result = new TreeMap<String, String>();
        while (true) {
            String key = this.readString();
            this.mustBe(58);
            String value = this.readString();
            result.put(key, value);
            if (this.pos == this.str.length()) break;
            this.mustBe(44);
        }
        return result;
    }

    String readString() {
        if (this.str.codePointAt(this.pos) != 34) {
            throw new RuntimeException("Wrong");
        }
        int startOffset = this.str.offsetByCodePoints(this.pos, 1);
        int endOffset = this.str.indexOf(34, startOffset);
        if (endOffset < 0) {
            throw new RuntimeException("Wrong");
        }
        String result = this.str.substring(startOffset, endOffset);
        this.pos = this.str.offsetByCodePoints(endOffset, 1);
        return result;
    }

    void mustBe(int c) {
        int cp = this.str.codePointAt(this.pos);
        if (cp != c) {
            throw new RuntimeException("Wrong");
        }
        this.pos += Character.charCount(cp);
    }
}

