/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.lucene;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.FSDirectory;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.matching.external.IBrowsableMemory;
import org.omegat.core.matching.external.lucene.NgramAnalyzer;
import org.omegat.util.Language;

public class LuceneReader
implements IBrowsableMemory {
    private final NgramAnalyzer analyzer = new NgramAnalyzer();
    private IndexReader indexReader;
    private IndexSearcher searcher;
    private String name;

    public LuceneReader(Properties prop) throws IOException {
        this(new File(prop.getProperty("dir")));
    }

    public LuceneReader(File indexDirectory) throws IOException {
        if (!indexDirectory.isDirectory()) {
            indexDirectory = indexDirectory.getParentFile();
        }
        this.name = indexDirectory.getPath();
        this.indexReader = IndexReader.open(FSDirectory.open(indexDirectory));
        this.searcher = new IndexSearcher(this.indexReader);
        File stopFile = new File(indexDirectory, "stop");
        if (stopFile.exists()) {
            this.analyzer.loadstopNgrams(stopFile.getPath());
        }
    }

    @Override
    public String getProviderName() {
        return "Lucene";
    }

    @Override
    public String getMemoryName() {
        return this.name;
    }

    @Override
    public List<PrepareTMXEntry> findMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception {
        ArrayList<PrepareTMXEntry> result = new ArrayList<PrepareTMXEntry>(maxCount);
        BooleanQuery query = new BooleanQuery();
        TokenStream queryTokenStream = this.analyzer.tokenStream("src", new StringReader(text));
        TermAttribute termAtt = queryTokenStream.addAttribute(TermAttribute.class);
        queryTokenStream.reset();
        HashSet<String> terms = new HashSet<String>();
        while (queryTokenStream.incrementToken()) {
            terms.add(termAtt.term());
        }
        for (String current : terms) {
            Term t = new Term("src", current);
            query.add(new TermQuery(t), BooleanClause.Occur.SHOULD);
        }
        queryTokenStream.end();
        queryTokenStream.close();
        int minShould = terms.size() * minScore / 200;
        if (minShould > 1) {
            query.setMinimumNumberShouldMatch(minShould);
        }
        TopScoreDocCollector topCollector = TopScoreDocCollector.create(maxCount, true);
        this.searcher.search((Query)query, topCollector);
        for (ScoreDoc sdoc : topCollector.topDocs().scoreDocs) {
            Document doc = this.searcher.doc(sdoc.doc);
            result.add(this.toEntry(doc));
        }
        return result;
    }

    @Override
    public List<PrepareTMXEntry> getEntries() throws Exception {
        ArrayList<PrepareTMXEntry> aList = new ArrayList<PrepareTMXEntry>(this.indexReader.maxDoc() - 1);
        for (int i = 0; i < this.indexReader.maxDoc(); ++i) {
            if (this.indexReader.isDeleted(i)) continue;
            Document doc = this.indexReader.document(i);
            aList.add(this.toEntry(doc));
        }
        return aList;
    }

    private PrepareTMXEntry toEntry(Document doc) {
        PrepareTMXEntry entry = new PrepareTMXEntry();
        entry.source = doc.get("src");
        entry.translation = doc.get("tra");
        entry.creator = doc.get("author");
        entry.changer = doc.get("changer");
        return entry;
    }
}

