/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.segmentation;

import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Rule
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7645267236376489908L;
    private boolean breakRule;
    private Pattern beforebreak;
    private Pattern afterbreak;

    public Rule() {
    }

    public Rule(boolean breakRule, String beforebreak, String afterbreak) {
        this.setBreakRule(breakRule);
        this.setBeforebreak(beforebreak);
        this.setAfterbreak(afterbreak);
    }

    public Rule clone() {
        Rule result = new Rule();
        result.breakRule = this.breakRule;
        result.beforebreak = this.beforebreak;
        result.afterbreak = this.afterbreak;
        return result;
    }

    public boolean isBreakRule() {
        return this.breakRule;
    }

    public void setBreakRule(boolean breakRule) {
        this.breakRule = breakRule;
    }

    public String getBeforebreak() {
        if (this.beforebreak != null) {
            return this.beforebreak.pattern();
        }
        return null;
    }

    public Pattern getCompiledBeforebreak() {
        return this.beforebreak;
    }

    public void setBeforebreak(String beforebreak) throws PatternSyntaxException {
        this.beforebreak = this.compilePattern(beforebreak);
    }

    public String getAfterbreak() {
        if (this.afterbreak != null) {
            return this.afterbreak.pattern();
        }
        return null;
    }

    public Pattern getCompiledAfterbreak() {
        return this.afterbreak;
    }

    public void setAfterbreak(String afterbreak) throws PatternSyntaxException {
        this.afterbreak = this.compilePattern(afterbreak);
    }

    private Pattern compilePattern(String pattern) {
        Pattern testFlags = Pattern.compile(pattern);
        if ((testFlags.flags() & 2) == 2) {
            return Pattern.compile(pattern, 96);
        }
        return Pattern.compile(pattern, 32);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Rule)) {
            return false;
        }
        Rule that = (Rule)obj;
        return this.breakRule == that.breakRule && this.getBeforebreak().equals(that.getBeforebreak()) && this.getAfterbreak().equals(that.getAfterbreak());
    }

    public int hashCode() {
        return (this.isBreakRule() ? 1 : -1) + this.getBeforebreak().hashCode() - this.getAfterbreak().hashCode();
    }

    public String toString() {
        return (this.isBreakRule() ? "Break " : "Exception ") + "Before: " + this.getBeforebreak() + "After: " + this.getAfterbreak();
    }
}

