/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team;

import org.omegat.core.Core;
import org.omegat.core.team.GITRemoteRepository;
import org.omegat.core.team.IRemoteRepository;
import org.omegat.core.team.SVNRemoteRepository;
import org.omegat.gui.dialogs.TeamUserPassDialog;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class RepositoryUtils {
    public static boolean askForCredentials(IRemoteRepository.Credentials credentials, String message) {
        TeamUserPassDialog userPassDialog = new TeamUserPassDialog(Core.getMainWindow().getApplicationFrame());
        if (!StringUtil.isEmpty(credentials.username)) {
            userPassDialog.setFixedUsername(credentials.username);
        }
        userPassDialog.descriptionTextArea.setText(message);
        userPassDialog.setVisible(true);
        if (userPassDialog.getReturnStatus() == 1) {
            credentials.username = userPassDialog.userText.getText();
            credentials.password = userPassDialog.getPasswordCopy();
            credentials.saveAsPlainText = userPassDialog.cbForceSavePlainPassword.isSelected();
            credentials.readOnly = userPassDialog.cbReadOnly.isSelected();
            return true;
        }
        return false;
    }

    private static String getUsernameFromUrl(String url) {
        int at = url.indexOf(64);
        if (at == -1) {
            return null;
        }
        String username = url.substring(0, at);
        int slashes = username.indexOf("://");
        if (slashes != -1) {
            username = username.substring(slashes + "://".length());
        }
        return username;
    }

    public static class RepoTypeDetector {
        private String url = null;
        public IRemoteRepository.Credentials credentials = null;
        public Class<? extends IRemoteRepository> repoType = null;

        public RepoTypeDetector(String url, IRemoteRepository.Credentials credentials) {
            this.url = url;
            this.credentials = credentials;
        }

        public void execute() throws Exception {
            boolean firstPass = true;
            while (true) {
                try {
                    this.repoType = this.detect(this.credentials);
                }
                catch (IRemoteRepository.AuthenticationException ex) {
                    boolean entered;
                    if (this.credentials == null) {
                        this.credentials = new IRemoteRepository.Credentials();
                        this.credentials.username = RepositoryUtils.getUsernameFromUrl(this.url);
                    }
                    if (!(entered = RepositoryUtils.askForCredentials(this.credentials, OStrings.getString(firstPass ? "TEAM_USERPASS_FIRST" : "TEAM_USERPASS_WRONG")))) {
                        throw new RuntimeException("User declined to enter credentials.", ex);
                    }
                    firstPass = false;
                    continue;
                }
                break;
            }
        }

        private Class<? extends IRemoteRepository> detect(IRemoteRepository.Credentials credentials) throws Exception {
            IRemoteRepository.AuthenticationException thrown = null;
            try {
                if (GITRemoteRepository.isGitRepository(this.url, credentials)) {
                    return GITRemoteRepository.class;
                }
            }
            catch (IRemoteRepository.AuthenticationException ex) {
                thrown = ex;
            }
            if (SVNRemoteRepository.isSVNRepository(this.url, credentials)) {
                return SVNRemoteRepository.class;
            }
            if (thrown != null) {
                throw thrown;
            }
            return null;
        }
    }

    public static abstract class AskCredentials {
        public IRemoteRepository.Credentials credentials = null;

        public void execute(IRemoteRepository repository) throws Exception {
            boolean firstPass = true;
            while (true) {
                try {
                    this.callRepository();
                }
                catch (IRemoteRepository.AuthenticationException ex) {
                    if (this.credentials == null) {
                        this.credentials = new IRemoteRepository.Credentials();
                    }
                    boolean entered = RepositoryUtils.askForCredentials(this.credentials, OStrings.getString(firstPass ? "TEAM_USERPASS_FIRST" : "TEAM_USERPASS_WRONG"));
                    repository.setCredentials(this.credentials);
                    if (!entered) {
                        throw ex;
                    }
                    firstPass = false;
                    continue;
                }
                break;
            }
        }

        protected abstract void callRepository() throws Exception;
    }
}

