/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.threads;

import java.util.regex.PatternSyntaxException;
import org.omegat.core.Core;
import org.omegat.core.search.Searcher;
import org.omegat.core.threads.LongProcessInterruptedException;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.gui.search.SearchWindowController;
import org.omegat.util.Log;

public class SearchThread
extends LongProcessThread {
    private SearchWindowController m_window;
    private Searcher m_searcher;

    public SearchThread(SearchWindowController window, Searcher searcher) {
        this.m_window = window;
        this.m_searcher = searcher;
        this.m_searcher.setThread(this);
    }

    @Override
    public void run() {
        try {
            try {
                this.m_searcher.search();
                this.checkInterrupted();
                this.m_window.displaySearchResult(this.m_searcher);
            }
            catch (LongProcessInterruptedException longProcessInterruptedException) {
            }
            catch (PatternSyntaxException e) {
                this.m_window.displayErrorRB(e, "ST_REGEXP_ERROR", new Object[0]);
            }
            catch (Exception e) {
                Log.logErrorRB(e, "ST_FILE_SEARCH_ERROR", new Object[0]);
                Core.getMainWindow().displayErrorRB(e, "ST_FILE_SEARCH_ERROR", new Object[0]);
            }
        }
        catch (RuntimeException re) {
            Log.logErrorRB(re, "ST_FATAL_ERROR", new Object[0]);
            Core.getMainWindow().displayErrorRB(re, "ST_FATAL_ERROR", new Object[0]);
        }
    }
}

